/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Strings;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueObjectTypeBlock
extends ValueObjectTypeBase<ValueBlock>
implements IValueTypeNamed<ValueBlock>,
IValueTypeNullable<ValueBlock> {
    public ValueObjectTypeBlock() {
        super("block");
    }

    @Override
    public ValueBlock getDefault() {
        return ValueBlock.of(null);
    }

    @Override
    public String toCompactString(ValueBlock value) {
        if (value.getRawValue().isPresent()) {
            IBlockState blockState = (IBlockState)value.getRawValue().get();
            ItemStack itemStack = BlockHelpers.getItemStackFromBlockState((IBlockState)blockState);
            if (itemStack != null) {
                return itemStack.func_82833_r();
            }
            return blockState.func_177230_c().func_149732_F();
        }
        return "";
    }

    @Override
    public String serialize(ValueBlock value) {
        if (!value.getRawValue().isPresent()) {
            return "";
        }
        Pair serializedBlockState = BlockHelpers.serializeBlockState((IBlockState)((IBlockState)value.getRawValue().get()));
        return String.format("%s$%s", serializedBlockState.getLeft(), serializedBlockState.getRight());
    }

    @Override
    public ValueBlock deserialize(String value) {
        if (Strings.isNullOrEmpty((String)value)) {
            return ValueBlock.of(null);
        }
        String[] parts = value.split("\\$");
        try {
            return ValueBlock.of(BlockHelpers.deserializeBlockState((Pair)Pair.of((Object)parts[0], (Object)Integer.parseInt(parts[1]))));
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new RuntimeException(String.format("Something went wrong while deserializing '%s'.", value));
        }
    }

    @Override
    public String getName(ValueBlock a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueBlock a) {
        return !a.getRawValue().isPresent();
    }

    public static class ValueBlock
    extends ValueOptionalBase<IBlockState> {
        private ValueBlock(IBlockState blockState) {
            super(ValueTypes.OBJECT_BLOCK, blockState);
        }

        public static ValueBlock of(IBlockState blockState) {
            return new ValueBlock(blockState);
        }

        @Override
        protected boolean isEqual(IBlockState a, IBlockState b) {
            return a.func_177230_c().func_176201_c(a) == b.func_177230_c().func_176201_c(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeBlock.ValueBlock()";
        }
    }
}

