/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import com.google.common.base.Optional;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNamed;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeNullable;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueObjectTypeBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueOptionalBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;

public class ValueObjectTypeFluidStack
extends ValueObjectTypeBase<ValueFluidStack>
implements IValueTypeNamed<ValueFluidStack>,
IValueTypeNullable<ValueFluidStack> {
    public ValueObjectTypeFluidStack() {
        super("fluidstack");
    }

    @Override
    public ValueFluidStack getDefault() {
        return ValueFluidStack.of(null);
    }

    @Override
    public String toCompactString(ValueFluidStack value) {
        Optional fluidStack = value.getRawValue();
        return fluidStack.isPresent() ? String.format("%s (%s mB)", ((FluidStack)fluidStack.get()).getLocalizedName(), ((FluidStack)fluidStack.get()).amount) : "";
    }

    @Override
    public String serialize(ValueFluidStack value) {
        NBTTagCompound tag = new NBTTagCompound();
        Optional fluidStack = value.getRawValue();
        if (fluidStack.isPresent()) {
            ((FluidStack)fluidStack.get()).writeToNBT(tag);
        }
        return tag.toString();
    }

    @Override
    public ValueFluidStack deserialize(String value) {
        try {
            NBTTagCompound tag = JsonToNBT.func_180713_a((String)value);
            FluidStack fluidStack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)tag);
            return ValueFluidStack.of(fluidStack);
        }
        catch (NBTException e) {
            return null;
        }
    }

    @Override
    public String getName(ValueFluidStack a) {
        return this.toCompactString(a);
    }

    @Override
    public boolean isNull(ValueFluidStack a) {
        return !a.getRawValue().isPresent();
    }

    public static class ValueFluidStack
    extends ValueOptionalBase<FluidStack> {
        private ValueFluidStack(FluidStack fluidStack) {
            super(ValueTypes.OBJECT_FLUIDSTACK, fluidStack);
        }

        public static ValueFluidStack of(FluidStack fluidStack) {
            return new ValueFluidStack(fluidStack);
        }

        @Override
        protected boolean isEqual(FluidStack a, FluidStack b) {
            return a.isFluidStackIdentical(b);
        }

        @Override
        public String toString() {
            return "ValueObjectTypeFluidStack.ValueFluidStack()";
        }
    }
}

