/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.variable;

import java.util.Collections;
import java.util.Set;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueTypeCategory;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeBase;

public abstract class ValueTypeCategoryBase<V extends IValue>
extends ValueTypeBase<V>
implements IValueTypeCategory<V> {
    protected final Set<IValueType<?>> elements;

    public ValueTypeCategoryBase(String typeName, int color, String colorFormat, Set<IValueType<?>> elements) {
        super(typeName, color, colorFormat);
        this.elements = Collections.unmodifiableSet(elements);
    }

    public ValueTypeCategoryBase(String typeName, int color, String colorFormat) {
        super(typeName, color, colorFormat);
        this.elements = null;
    }

    @Override
    public boolean isCategory() {
        return true;
    }

    @Override
    public V getDefault() {
        return null;
    }

    @Override
    public String getUnlocalizedName() {
        return this.getUnlocalizedPrefix() + ".name";
    }

    @Override
    public String toCompactString(V value) {
        return null;
    }

    @Override
    public boolean correspondsTo(IValueType valueType) {
        return valueType == this || this.elements == null ? true : this.elements.contains(valueType);
    }

    @Override
    public String serialize(V value) {
        throw new UnsupportedOperationException("This operation is not allowed");
    }

    @Override
    public V deserialize(String value) {
        throw new UnsupportedOperationException("This operation is not allowed");
    }

    @Override
    protected String getModId() {
        return "integrateddynamics";
    }

    @Override
    public Set<IValueType<?>> getElements() {
        return Collections.unmodifiableSet(this.elements);
    }

    @Override
    public boolean hasDefaultLogicProgrammerElement() {
        return false;
    }
}

