/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public final class Helpers {
    public static final Predicate<Entity> SELECTOR_IS_PLAYER = new Predicate<Entity>(){

        public boolean apply(@Nullable Entity p_apply_1_) {
            return p_apply_1_ instanceof EntityPlayer;
        }
    };

    public static FluidStack getFluidStack(ItemStack itemStack) {
        return FluidUtil.getFluidContained((ItemStack)itemStack);
    }

    public static int getFluidStackCapacity(ItemStack itemStack) {
        IFluidTankProperties[] arr$;
        int len$;
        int i$;
        IFluidHandler fluidHandler = FluidUtil.getFluidHandler((ItemStack)itemStack);
        if (fluidHandler != null && (i$ = 0) < (len$ = (arr$ = fluidHandler.getTankProperties()).length)) {
            IFluidTankProperties properties = arr$[i$];
            return properties.getCapacity();
        }
        return 0;
    }

    public static <T> List<T> joinList(List<T> list, T newElement) {
        ImmutableList.Builder builder = ImmutableList.builder().addAll(list);
        if (newElement != null) {
            builder.add(newElement);
        }
        return builder.build();
    }

    public static String createPatternOfLength(int length) {
        StringBuilder pattern = new StringBuilder();
        boolean first = true;
        for (int i = 0; i < length; ++i) {
            if (first) {
                first = false;
            } else {
                pattern.append(",");
            }
            pattern.append("%s");
        }
        return pattern.toString();
    }
}

