/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityDispatcher;
import net.minecraftforge.fml.common.eventhandler.Event;
import org.cyclops.cyclopscore.persist.IDirtyMarkListener;
import org.cyclops.cyclopscore.persist.nbt.INBTProvider;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.nbt.NBTProviderComponent;
import org.cyclops.integrateddynamics.GeneralConfig;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.part.AttachCapabilitiesEventPart;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.property.IAspectProperties;

public abstract class PartStateBase<P extends IPartType>
implements IPartState<P>,
INBTProvider,
IDirtyMarkListener {
    private boolean dirty = false;
    private boolean update = false;
    private INBTProvider nbtProviderComponent = new NBTProviderComponent((INBTProvider)this);
    @NBTPersist
    private int updateInterval = GeneralConfig.defaultPartUpdateFreq;
    @NBTPersist
    private int id = -1;
    @NBTPersist
    private Map<String, IAspectProperties> aspectProperties = Maps.newHashMap();
    @NBTPersist
    private boolean enabled = true;
    private CapabilityDispatcher capabilities = null;
    private Map<Capability<?>, Object> volatileCapabilities = Maps.newHashMap();

    @Override
    public void writeToNBT(NBTTagCompound tag) {
        this.writeGeneratedFieldsToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.readGeneratedFieldsFromNBT(tag);
    }

    @Override
    public void generateId() {
        this.id = IntegratedDynamics.globalCounters.getNext("part");
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.updateInterval = updateInterval;
    }

    @Override
    public int getUpdateInterval() {
        return this.updateInterval;
    }

    @Override
    public boolean isDirtyAndReset() {
        boolean wasDirty = this.dirty;
        this.dirty = false;
        return wasDirty;
    }

    @Override
    public boolean isUpdateAndReset() {
        boolean wasUpdate = this.update;
        this.update = false;
        return wasUpdate;
    }

    public void onDirty() {
        this.dirty = true;
    }

    public void sendUpdate() {
        this.update = true;
    }

    @Override
    public IAspectProperties getAspectProperties(IAspect aspect) {
        return this.aspectProperties.get(aspect.getUnlocalizedName());
    }

    @Override
    public void setAspectProperties(IAspect aspect, IAspectProperties properties) {
        this.aspectProperties.put(aspect.getUnlocalizedName(), properties);
        this.sendUpdate();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void gatherCapabilities(P partType) {
        AttachCapabilitiesEventPart event = new AttachCapabilitiesEventPart((IPartType)partType, this);
        MinecraftForge.EVENT_BUS.post((Event)event);
        this.capabilities = event.getCapabilities().size() > 0 ? new CapabilityDispatcher(event.getCapabilities()) : null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability) {
        return this.volatileCapabilities.containsKey(capability) || this.capabilities != null && this.capabilities.hasCapability(capability, null);
    }

    @Override
    public <T> T getCapability(Capability<T> capability) {
        Object o = this.volatileCapabilities.get(capability);
        if (o != null) {
            return (T)o;
        }
        return (T)(this.capabilities == null ? null : this.capabilities.getCapability(capability, null));
    }

    @Override
    public <T> void addVolatileCapability(Capability<T> capability, T value) {
        this.volatileCapabilities.put(capability, value);
    }

    @Override
    public void removeVolatileCapability(Capability<?> capability) {
        this.volatileCapabilities.remove(capability);
    }

    public void writeGeneratedFieldsToNBT(NBTTagCompound arg0) {
        this.nbtProviderComponent.writeGeneratedFieldsToNBT(arg0);
    }

    public void readGeneratedFieldsFromNBT(NBTTagCompound arg0) {
        this.nbtProviderComponent.readGeneratedFieldsFromNBT(arg0);
    }
}

