/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part.write;

import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.cyclops.cyclopscore.helper.CollectionHelpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.aspect.IAspect;
import org.cyclops.integrateddynamics.api.part.aspect.IAspectWrite;
import org.cyclops.integrateddynamics.api.part.write.IPartStateWriter;
import org.cyclops.integrateddynamics.api.part.write.IPartTypeWriter;
import org.cyclops.integrateddynamics.core.part.PartStateActiveVariableBase;
import org.cyclops.integrateddynamics.part.aspect.Aspects;

public class PartStateWriterBase<P extends IPartTypeWriter>
extends PartStateActiveVariableBase<P>
implements IPartStateWriter<P> {
    @NBTPersist
    private String activeAspectName = null;
    @NBTPersist
    private Map<String, List<L10NHelpers.UnlocalizedString>> errorMessages = Maps.newHashMap();
    private boolean firstTick = true;

    public PartStateWriterBase(int inventorySize) {
        super(inventorySize);
    }

    @Override
    protected void validate(IPartNetwork network) {
        if (this.getActiveAspect() != null) {
            this.currentVariableFacade.validate(network, new Validator(this, this.getActiveAspect()), (IValueType)this.getActiveAspect().getValueType());
        }
    }

    @Override
    protected void onCorruptedState() {
        super.onCorruptedState();
        this.activeAspectName = null;
    }

    @Override
    public boolean hasVariable() {
        return this.getActiveAspect() != null && this.getErrors(this.getActiveAspect()).isEmpty() && super.hasVariable();
    }

    @Override
    public void triggerAspectInfoUpdate(P partType, PartTarget target, IAspectWrite newAspect) {
        this.onVariableContentsUpdated(partType, target);
        IAspectWrite activeAspect = this.getActiveAspect();
        if (activeAspect != null && activeAspect != newAspect) {
            activeAspect.onDeactivate(partType, target, this);
        }
        if (newAspect != null && activeAspect != newAspect) {
            newAspect.onActivate(partType, target, this);
        }
        this.activeAspectName = newAspect == null ? null : newAspect.getUnlocalizedName();
    }

    @Override
    public void onVariableContentsUpdated(P partType, PartTarget target) {
        super.onVariableContentsUpdated(partType, target);
        IAspectWrite activeAspect = this.getActiveAspect();
        if (activeAspect != null) {
            this.addError(activeAspect, null);
        }
    }

    @Override
    public IAspectWrite getActiveAspect() {
        if (this.activeAspectName == null) {
            return null;
        }
        IAspect aspect = Aspects.REGISTRY.getAspect(this.activeAspectName);
        if (!(aspect instanceof IAspectWrite)) {
            return null;
        }
        return (IAspectWrite)aspect;
    }

    @Override
    public List<L10NHelpers.UnlocalizedString> getErrors(IAspectWrite aspect) {
        List<L10NHelpers.UnlocalizedString> errors = this.errorMessages.get(aspect.getUnlocalizedName());
        if (errors == null) {
            return Collections.emptyList();
        }
        return errors;
    }

    @Override
    public void addError(IAspectWrite aspect, L10NHelpers.UnlocalizedString error) {
        if (error == null) {
            this.errorMessages.remove(aspect.getUnlocalizedName());
        } else {
            CollectionHelpers.addToMapList(this.errorMessages, (Object)aspect.getUnlocalizedName(), (Object)error);
        }
        this.onDirty();
        this.sendUpdate();
    }

    @Override
    public Class<? extends IPartState> getPartStateClass() {
        return IPartStateWriter.class;
    }

    @Override
    public boolean checkAndResetFirstTick() {
        if (this.firstTick) {
            this.firstTick = false;
            return true;
        }
        return false;
    }

    public static class Validator
    implements IVariableFacade.IValidator {
        private final IPartStateWriter state;
        private final IAspectWrite aspect;

        public Validator(IPartStateWriter state, IAspectWrite aspect) {
            this.state = state;
            this.aspect = aspect;
        }

        @Override
        public void addError(L10NHelpers.UnlocalizedString error) {
            this.state.addError(this.aspect, error);
        }
    }
}

