/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.jei.squeezer;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.recipe.BlankRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipe;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemAndFluidStackRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.ItemStackRecipeComponent;
import org.cyclops.integrateddynamics.block.BlockSqueezer;

public class SqueezerRecipeJEI
extends BlankRecipeWrapper {
    private final List<ItemStack> inputItem;
    private final List<ItemStack> outputItem;
    private final FluidStack outputFluid;

    public SqueezerRecipeJEI(IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> recipe) {
        this.inputItem = ((ItemStackRecipeComponent)recipe.getInput()).getItemStacks();
        this.outputItem = ((ItemAndFluidStackRecipeComponent)recipe.getOutput()).getItemStacks();
        this.outputFluid = ((ItemAndFluidStackRecipeComponent)recipe.getOutput()).getFluidStack();
    }

    public List getInputs() {
        return this.getInputItem();
    }

    public List getOutputs() {
        return this.getOutputItem();
    }

    public List<FluidStack> getFluidOutputs() {
        return Lists.newArrayList((Object[])new FluidStack[]{this.getOutputFluid()});
    }

    public static List<SqueezerRecipeJEI> getAllRecipes() {
        return Lists.transform((List)BlockSqueezer.getInstance().getRecipeRegistry().allRecipes(), (Function)new Function<IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent>, SqueezerRecipeJEI>(){

            @Nullable
            public SqueezerRecipeJEI apply(IRecipe<ItemStackRecipeComponent, ItemAndFluidStackRecipeComponent, DummyPropertiesComponent> input) {
                return new SqueezerRecipeJEI(input);
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SqueezerRecipeJEI)) {
            return false;
        }
        SqueezerRecipeJEI other = (SqueezerRecipeJEI)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<ItemStack> this$inputItem = this.getInputItem();
        List<ItemStack> other$inputItem = other.getInputItem();
        if (this$inputItem == null ? other$inputItem != null : !((Object)this$inputItem).equals(other$inputItem)) {
            return false;
        }
        List<ItemStack> this$outputItem = this.getOutputItem();
        List<ItemStack> other$outputItem = other.getOutputItem();
        if (this$outputItem == null ? other$outputItem != null : !((Object)this$outputItem).equals(other$outputItem)) {
            return false;
        }
        FluidStack this$outputFluid = this.getOutputFluid();
        FluidStack other$outputFluid = other.getOutputFluid();
        return !(this$outputFluid == null ? other$outputFluid != null : !this$outputFluid.equals(other$outputFluid));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SqueezerRecipeJEI;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ItemStack> $inputItem = this.getInputItem();
        result = result * 59 + ($inputItem == null ? 43 : ((Object)$inputItem).hashCode());
        List<ItemStack> $outputItem = this.getOutputItem();
        result = result * 59 + ($outputItem == null ? 43 : ((Object)$outputItem).hashCode());
        FluidStack $outputFluid = this.getOutputFluid();
        result = result * 59 + ($outputFluid == null ? 43 : $outputFluid.hashCode());
        return result;
    }

    public List<ItemStack> getInputItem() {
        return this.inputItem;
    }

    public List<ItemStack> getOutputItem() {
        return this.outputItem;
    }

    public FluidStack getOutputFluid() {
        return this.outputFluid;
    }

    public String toString() {
        return "SqueezerRecipeJEI(inputItem=" + this.getInputItem() + ", outputItem=" + this.getOutputItem() + ", outputFluid=" + this.getOutputFluid() + ")";
    }
}

