/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.modcompat.mcmultipart;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcmultipart.MCMultiPartMod;
import mcmultipart.block.TileMultipartContainer;
import mcmultipart.client.multipart.AdvancedParticleManager;
import mcmultipart.multipart.IMultipart;
import mcmultipart.multipart.IMultipartContainer;
import mcmultipart.multipart.ISlottedPart;
import mcmultipart.multipart.MultipartHelper;
import mcmultipart.multipart.OcclusionHelper;
import mcmultipart.multipart.PartSlot;
import mcmultipart.raytrace.PartMOP;
import mcmultipart.raytrace.RayTraceUtils;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.cyclops.cyclopscore.block.property.ExtendedBlockStateBuilder;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.cyclopscore.datastructure.EnumFacingMap;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.block.IDynamicLightBlock;
import org.cyclops.integrateddynamics.api.block.IDynamicRedstoneBlock;
import org.cyclops.integrateddynamics.api.block.cable.ICable;
import org.cyclops.integrateddynamics.api.block.cable.ICableNetwork;
import org.cyclops.integrateddynamics.api.network.INetworkElement;
import org.cyclops.integrateddynamics.api.network.INetworkElementProvider;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.part.IPartContainer;
import org.cyclops.integrateddynamics.api.part.IPartContainerFacade;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.path.ICablePathElement;
import org.cyclops.integrateddynamics.api.tileentity.ITileCableNetwork;
import org.cyclops.integrateddynamics.block.BlockCable;
import org.cyclops.integrateddynamics.block.BlockCableConfig;
import org.cyclops.integrateddynamics.core.block.cable.CableNetworkComponent;
import org.cyclops.integrateddynamics.core.block.cable.NetworkElementProviderComponent;
import org.cyclops.integrateddynamics.core.helper.PartHelpers;
import org.cyclops.integrateddynamics.core.path.CablePathElement;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.MultipartBase;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartCableNetworkComponent;
import org.cyclops.integrateddynamics.modcompat.mcmultipart.PartPartType;

public class PartCable
extends MultipartBase
implements ICableNetwork<IPartNetwork, ICablePathElement>,
INetworkElementProvider,
IDynamicRedstoneBlock,
IDynamicLightBlock,
ITileCableNetwork,
IPartContainerFacade,
ITickable {
    private final PartCableNetworkComponent cableNetworkComponent = new PartCableNetworkComponent<PartCable>(this);
    private final NetworkElementProviderComponent<IPartNetwork> networkElementProviderComponent = new NetworkElementProviderComponent(this);
    private final EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> partData;
    @NBTPersist
    private EnumFacingMap<Boolean> connected = EnumFacingMap.newMap();
    @NBTPersist
    private EnumFacingMap<Boolean> forceDisconnected;
    @NBTPersist
    private int lightLevel = 0;
    @NBTPersist
    private int redstoneLevel = 0;
    @NBTPersist
    private boolean allowsRedstone = false;
    private IPartNetwork network = null;
    private IPartContainer partContainer = null;
    private boolean addSilent = false;
    private boolean sendFurtherUpdates = true;

    public PartCable() {
        this(EnumFacingMap.newMap(), (EnumFacingMap<Boolean>)EnumFacingMap.newMap());
    }

    public PartCable(EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> partData, EnumFacingMap<Boolean> forceDisconnected) {
        this.partData = partData;
        this.forceDisconnected = forceDisconnected;
    }

    public EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> getPartData() {
        return this.partData;
    }

    public EnumFacingMap<Boolean> getForceDisconnected() {
        return this.forceDisconnected;
    }

    @Override
    protected ItemStack getItemStack() {
        return new ItemStack((Block)BlockCable.getInstance());
    }

    public IBlockState getExtendedState(IBlockState state) {
        ExtendedBlockStateBuilder builder = ExtendedBlockStateBuilder.builder((IExtendedBlockState)((IExtendedBlockState)state));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            builder.withProperty(BlockCable.CONNECTED[side.ordinal()], (Object)this.isConnected(side));
            boolean hasPart = this.hasPart(side);
            if (hasPart) {
                builder.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)this.getPart(side).getRenderPosition());
                continue;
            }
            builder.withProperty(BlockCable.PART_RENDERPOSITIONS[side.ordinal()], (Object)IPartType.RenderPosition.NONE);
        }
        return builder.build();
    }

    public BlockStateContainer createBlockState() {
        return new ExtendedBlockState((Block)MCMultiPartMod.multipart, new IProperty[0], (IUnlistedProperty[])ArrayUtils.addAll((Object[])BlockCable.PART_RENDERPOSITIONS, (Object[])BlockCable.CONNECTED));
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return BlockCable.getInstance().getCableBoundingBox(null);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addDestroyEffects(AdvancedParticleManager advancedParticleManager) {
        advancedParticleManager.addBlockDestroyEffects(this.getPos(), BlockCable.getInstance().texture);
        return true;
    }

    public void addOcclusionBoxes(List<AxisAlignedBB> list) {
        list.add(BlockCable.getInstance().getCableBoundingBox(null));
    }

    public void addSelectionBoxes(List<AxisAlignedBB> list) {
        list.add(BlockCable.getInstance().getCableBoundingBox(null));
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.isConnected(side)) {
                list.add(BlockCable.getInstance().getCableBoundingBox(side));
                continue;
            }
            if (!this.hasPart(side)) continue;
            list.add(this.getPart(side).getRenderPosition().getSidedCableBoundingBox(side));
        }
    }

    protected void addCollisionBoxConditional(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity, EnumFacing side) {
        AxisAlignedBB box = BlockCable.getInstance().getCableBoundingBox(side);
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    protected void addCollisionBoxWithPartConditional(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity, EnumFacing side) {
        AxisAlignedBB box = this.getPart(side).getRenderPosition().getSidedCableBoundingBox(side);
        if (box.func_72326_a(mask)) {
            list.add(box);
        }
    }

    protected EnumFacing getSubHitSide(int subHit) {
        if (subHit == -1) {
            return null;
        }
        int i = 0;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.isConnected(side)) {
                if (i == subHit) {
                    return side;
                }
                ++i;
            }
            if (!this.hasPart(side)) continue;
            if (i == subHit) {
                return side;
            }
            ++i;
        }
        return null;
    }

    public void addCollisionBoxes(AxisAlignedBB mask, List<AxisAlignedBB> list, Entity collidingEntity) {
        this.addCollisionBoxConditional(mask, list, collidingEntity, null);
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (this.isConnected(side)) {
                this.addCollisionBoxConditional(mask, list, collidingEntity, side);
                continue;
            }
            if (!this.hasPart(side)) continue;
            this.addCollisionBoxWithPartConditional(mask, list, collidingEntity, side);
        }
    }

    public boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.TRANSLUCENT;
    }

    public ResourceLocation getModelPath() {
        return new ResourceLocation(IntegratedDynamics._instance.getModId(), BlockCableConfig._instance.getNamedId());
    }

    public EnumSet<PartSlot> getSlotMask() {
        return EnumSet.of(PartSlot.CENTER);
    }

    public void detectPresentParts() {
        IMultipartContainer container = this.getContainer();
        for (IMultipart multipart : container.getParts()) {
            if (!(multipart instanceof PartPartType)) continue;
            final PartPartType partPart = (PartPartType)multipart;
            PartHelpers.setPart(this.getNetwork(), this.getWorld(), this.getPos(), partPart.getFacing(), partPart.getPartType(), partPart.getPartType().getDefaultState(), new PartHelpers.IPartStateHolderCallback(){

                @Override
                public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                    PartCable.this.partData.put((Enum)partPart.getFacing(), partStateHolder);
                    PartCable.this.sendUpdate();
                }
            });
        }
    }

    public void onAdded() {
        super.onAdded();
        if (!this.isAddSilent()) {
            this.cableNetworkComponent.addToNetwork(this.getWorld(), this.getPos());
            this.detectPresentParts();
        }
    }

    public void harvest(EntityPlayer player, PartMOP hit) {
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        this.networkElementProviderComponent.onPreBlockDestroyed(this.getNetwork(world, pos), world, pos, false);
        this.cableNetworkComponent.onPreBlockDestroyed(world, pos);
        super.harvest(player, hit);
    }

    public void onRemoved() {
        super.onRemoved();
        this.cableNetworkComponent.onPostBlockDestroyed(this.getWorld(), this.getPos());
    }

    public boolean onActivated(EntityPlayer player, EnumHand hand, ItemStack stack, PartMOP hit) {
        EnumFacing cableConnectionHit = this.getSubHitSide(hit.subHit);
        return !this.getWorld().field_72995_K ? BlockCable.onCableActivated(this.getWorld(), this.getPos(), BlockCable.getInstance().func_176223_P(), player, hand, player.func_184586_b(hand), hit.field_178784_b, cableConnectionHit) : super.onActivated(player, hand, stack, hit);
    }

    public void onNeighborBlockChange(Block neighborBlock) {
        super.onNeighborBlockChange(neighborBlock);
        World world = this.getWorld();
        BlockPos pos = this.getPos();
        this.cableNetworkComponent.updateConnections(world, pos);
        this.networkElementProviderComponent.onBlockNeighborChange(this.getNetwork(world, pos), world, pos, neighborBlock);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag = super.writeToNBT(tag);
        PartHelpers.writePartsToNBT(this.getPos(), tag, this.partData);
        return tag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readFromNBT(NBTTagCompound tag) {
        EnumFacingMap<PartHelpers.PartStateHolder<?, ?>> enumFacingMap = this.partData;
        synchronized (enumFacingMap) {
            PartHelpers.readPartsFromNBT(this.getNetwork(), this.getPos(), tag, this.partData, this.getWorld());
        }
        super.readFromNBT(tag);
    }

    protected boolean hasPart(EnumFacing side) {
        return this.getPartContainer().hasPart(side);
    }

    protected IPartType getPart(EnumFacing side) {
        return this.getPartContainer().getPart(side);
    }

    public boolean isForceDisconnected(EnumFacing side) {
        if (this.hasPart(side)) {
            return true;
        }
        if (!this.forceDisconnected.containsKey((Object)side)) {
            return false;
        }
        return (Boolean)this.forceDisconnected.get((Object)side);
    }

    public void setConnected(EnumFacing side, boolean connected) {
        this.connected.put((Enum)side, (Object)connected);
    }

    public void onPartChanged(IMultipart part) {
        super.onPartChanged(part);
        if (this.sendFurtherUpdates) {
            this.updateConnections();
        }
    }

    public Collection<INetworkElement> createNetworkElements(World world, BlockPos blockPos) {
        HashSet sidedElements = Sets.newHashSet();
        for (Map.Entry<EnumFacing, IPartType<?, ?>> entry : this.getPartContainer().getParts().entrySet()) {
            if (this.getPartContainer().getPartState(entry.getKey()) == null) continue;
            sidedElements.add(entry.getValue().createNetworkElement(this, DimPos.of((World)world, (BlockPos)blockPos), entry.getKey()));
        }
        return sidedElements;
    }

    @Override
    public ICablePathElement createPathElement(World world, BlockPos blockPos) {
        return new CablePathElement(this, DimPos.of((World)world, (BlockPos)blockPos));
    }

    @Override
    public void initNetwork(World world, BlockPos pos) {
        this.cableNetworkComponent.initNetwork(world, pos);
    }

    @Override
    public boolean canConnect(World world, BlockPos selfPosition, ICable connector, EnumFacing side) {
        return this.cableNetworkComponent.canConnect(world, selfPosition, connector, side);
    }

    @Override
    public void updateConnections(World world, BlockPos pos) {
        this.cableNetworkComponent.updateConnections(world, pos);
    }

    @Override
    public void triggerUpdateNeighbourConnections(World world, BlockPos pos) {
        this.cableNetworkComponent.triggerUpdateNeighbourConnections(world, pos);
    }

    @Override
    public boolean isConnected(World world, BlockPos pos, EnumFacing side) {
        return this.cableNetworkComponent.isConnected(world, pos, side);
    }

    @Override
    public void disconnect(World world, BlockPos pos, EnumFacing side) {
        this.cableNetworkComponent.disconnect(world, pos, side);
    }

    @Override
    public void reconnect(World world, BlockPos pos, EnumFacing side) {
        this.cableNetworkComponent.reconnect(world, pos, side);
    }

    @Override
    public void remove(World world, BlockPos pos, EntityPlayer player) {
        this.networkElementProviderComponent.onPreBlockDestroyed(this.getNetwork(world, pos), world, pos, false);
        this.cableNetworkComponent.onPreBlockDestroyed(world, pos);
        this.cableNetworkComponent.remove(world, pos, player);
        this.cableNetworkComponent.onPostBlockDestroyed(world, pos);
    }

    @Override
    public void resetCurrentNetwork(World world, BlockPos pos) {
        this.cableNetworkComponent.resetCurrentNetwork(world, pos);
    }

    @Override
    public void setNetwork(IPartNetwork network, World world, BlockPos pos) {
        this.cableNetworkComponent.setNetwork(network, world, pos);
    }

    @Override
    public IPartNetwork getNetwork(World world, BlockPos pos) {
        return this.cableNetworkComponent.getNetwork(world, pos);
    }

    @Override
    public void setLightLevel(IBlockAccess world, BlockPos pos, EnumFacing side, int level) {
        this.lightLevel = level;
        this.sendUpdate();
    }

    @Override
    public int getLightLevel(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.lightLevel;
    }

    @Override
    public void disableRedstoneAt(IBlockAccess world, BlockPos pos, EnumFacing side) {
        this.setRedstoneLevel(world, pos, side, 0);
    }

    @Override
    public void setRedstoneLevel(IBlockAccess world, BlockPos pos, EnumFacing side, int level) {
        this.redstoneLevel = level;
        this.sendUpdate();
    }

    @Override
    public int getRedstoneLevel(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.redstoneLevel;
    }

    @Override
    public void setAllowRedstoneInput(IBlockAccess world, BlockPos pos, EnumFacing side, boolean allow) {
        this.allowsRedstone = allow;
        this.sendUpdate();
    }

    @Override
    public boolean isAllowRedstoneInput(IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.allowsRedstone;
    }

    @Override
    public boolean canConnect(ICable connector, EnumFacing side) {
        return !this.isForceDisconnected(side) && this.getContainer().getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side)) == null && OcclusionHelper.occlusionTest((Iterable)this.getContainer().getParts(), (Predicate)new Predicate<IMultipart>(){

            public boolean apply(@Nullable IMultipart input) {
                return input == PartCable.this;
            }
        }, (AxisAlignedBB[])new AxisAlignedBB[]{BlockCable.getInstance().getCableBoundingBox(side)});
    }

    @Override
    public void updateConnections() {
        World world = this.getWorld();
        for (EnumFacing side : EnumFacing.field_82609_l) {
            boolean canConnectThis = this.canConnect(this, side);
            boolean cableConnected = canConnectThis && CableNetworkComponent.canSideConnect(world, this.getPos(), side, this);
            this.setConnected(side, cableConnected);
            if (cableConnected || !canConnectThis) continue;
            this.forceDisconnected.put((Enum)side, (Object)false);
        }
        this.markDirty();
        this.sendUpdate();
    }

    @Override
    public boolean isConnected(EnumFacing side) {
        if (this.getPos() == null) {
            return false;
        }
        if (this.connected.isEmpty()) {
            this.updateConnections();
        }
        return !this.isForceDisconnected(side) && this.connected != null && (Boolean)this.connected.get((Object)side) != false;
    }

    @Override
    public void disconnect(EnumFacing side) {
        this.forceDisconnected.put((Enum)side, (Object)true);
    }

    @Override
    public void reconnect(EnumFacing side) {
        this.forceDisconnected.remove((Object)side);
    }

    @Override
    public void resetCurrentNetwork() {
        this.network = null;
    }

    @Override
    public void setNetwork(IPartNetwork network) {
        this.network = network;
    }

    @Override
    public IPartNetwork getNetwork() {
        return this.network;
    }

    protected IPartContainer getPartContainer() {
        if (this.partContainer == null) {
            this.partContainer = new VirtualPartContainer();
        }
        return this.partContainer;
    }

    @Override
    public IPartContainer getPartContainer(IBlockAccess world, BlockPos pos) {
        return this.getPartContainer();
    }

    @Override
    @Nullable
    public EnumFacing getWatchingSide(World world, BlockPos pos, EntityPlayer player) {
        Vec3d start = RayTraceUtils.getStart((EntityPlayer)player);
        Vec3d end = RayTraceUtils.getEnd((EntityPlayer)player);
        RayTraceUtils.AdvancedRayTraceResultPart result = ((TileMultipartContainer)world.func_175625_s(pos)).getPartContainer().collisionRayTrace(start, end);
        if (result == null || result.hit == null) {
            return null;
        }
        IMultipart multipart = ((PartMOP)result.hit).partHit;
        if (!(multipart instanceof PartPartType)) {
            return null;
        }
        PartPartType partPartType = (PartPartType)((PartMOP)result.hit).partHit;
        return partPartType != null ? partPartType.getFacing() : null;
    }

    public void func_73660_a() {
        if (!MinecraftHelpers.isClientSide()) {
            for (PartHelpers.PartStateHolder partStateHolder : this.partData.values()) {
                Object partState = partStateHolder.getState();
                if (partState.isDirtyAndReset()) {
                    this.markDirty();
                }
                if (!partState.isUpdateAndReset()) continue;
                this.sendUpdate();
            }
        }
    }

    public void setAddSilent(boolean addSilent) {
        this.addSilent = addSilent;
    }

    public boolean isAddSilent() {
        return this.addSilent;
    }

    public void setSendFurtherUpdates(boolean sendFurtherUpdates) {
        this.sendFurtherUpdates = sendFurtherUpdates;
    }

    public class VirtualPartContainer
    implements IPartContainer {
        protected PartPartType getPartPart(EnumFacing side) {
            ISlottedPart multipart;
            IMultipartContainer container = PartCable.this.getContainer();
            if (container != null && (multipart = container.getPartInSlot(PartSlot.getFaceSlot((EnumFacing)side))) instanceof PartPartType) {
                return (PartPartType)multipart;
            }
            return null;
        }

        @Override
        public DimPos getPosition() {
            return DimPos.of((World)PartCable.this.getWorld(), (BlockPos)PartCable.this.getPos());
        }

        @Override
        public Map<EnumFacing, IPartType<?, ?>> getParts() {
            HashMap parts = Maps.newHashMap();
            for (EnumFacing side : EnumFacing.field_82609_l) {
                IPartType partType = this.getPart(side);
                if (partType == null) continue;
                parts.put(side, partType);
            }
            return parts;
        }

        @Override
        public boolean hasParts() {
            for (IMultipart multipart : PartCable.this.getContainer().getParts()) {
                if (!(multipart instanceof PartPartType)) continue;
                return true;
            }
            return false;
        }

        @Override
        public <P extends IPartType<P, S>, S extends IPartState<P>> void setPart(final EnumFacing side, IPartType<P, S> part, IPartState<P> partState) {
            PartPartType partPart = new PartPartType(side, part);
            PartHelpers.setPart(PartCable.this.getNetwork(), PartCable.this.getWorld(), PartCable.this.getPos(), side, part, partState, new PartHelpers.IPartStateHolderCallback(){

                @Override
                public void onSet(PartHelpers.PartStateHolder<?, ?> partStateHolder) {
                    PartCable.this.partData.put((Enum)side, partStateHolder);
                    PartCable.this.sendUpdate();
                }
            });
            MultipartHelper.addPart((World)PartCable.this.getWorld(), (BlockPos)PartCable.this.getPos(), (IMultipart)partPart);
        }

        @Override
        public <P extends IPartType<P, S>, S extends IPartState<P>> boolean canAddPart(EnumFacing side, IPartType<P, S> part) {
            return !this.hasPart(side) && MultipartHelper.canAddPart((World)PartCable.this.getWorld(), (BlockPos)PartCable.this.getPos(), (IMultipart)new PartPartType(side, part));
        }

        @Override
        public IPartType getPart(EnumFacing side) {
            PartPartType partPartType = this.getPartPart(side);
            if (partPartType != null) {
                return partPartType.getPartType();
            }
            return null;
        }

        @Override
        public boolean hasPart(EnumFacing side) {
            return this.getPart(side) != null;
        }

        @Override
        public IPartType removePart(EnumFacing side, EntityPlayer player) {
            PartPartType partPartType = this.getPartPart(side);
            if (partPartType != null) {
                IPartType removed = partPartType.getPartType();
                for (ItemStack itemStack : partPartType.getDrops()) {
                    ItemStackHelpers.spawnItemStackToPlayer((World)PartCable.this.getWorld(), (BlockPos)PartCable.this.getPos(), (ItemStack)itemStack, (EntityPlayer)player);
                }
                PartCable.this.getContainer().removePart((IMultipart)partPartType);
                PartCable.this.partData.remove((Object)side);
                PartCable.this.sendUpdate();
                return removed;
            }
            return null;
        }

        @Override
        public void setPartState(EnumFacing side, IPartState partState) {
            PartCable.this.partData.put((Enum)side, PartHelpers.PartStateHolder.of(this.getPart(side), partState));
            PartCable.this.sendUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public IPartState getPartState(EnumFacing side) {
            EnumFacingMap enumFacingMap = PartCable.this.partData;
            synchronized (enumFacingMap) {
                PartHelpers.PartStateHolder partStateHolder = (PartHelpers.PartStateHolder)PartCable.this.partData.get((Object)side);
                if (partStateHolder != null) {
                    NBTTagCompound tag = new NBTTagCompound();
                    partStateHolder.getState().writeToNBT(tag);
                    return partStateHolder.getState();
                }
            }
            return null;
        }
    }
}

