/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.network;

import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.cyclops.cyclopscore.datastructure.DimPos;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.network.IEventListenableNetworkElement;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.core.network.TileNetworkElement;
import org.cyclops.integrateddynamics.tileentity.TileProxy;

public class ProxyNetworkElement
extends TileNetworkElement<TileProxy>
implements IEventListenableNetworkElement<IPartNetwork, TileProxy> {
    public ProxyNetworkElement(DimPos pos) {
        super(pos);
    }

    protected int getId() {
        return ((TileProxy)this.getTile()).getProxyId();
    }

    @Override
    public boolean onNetworkAddition(IPartNetwork network) {
        if (super.onNetworkAddition(network)) {
            if (!network.addProxy(this.getId(), this.getPos())) {
                IntegratedDynamics.clog(Level.WARN, "A proxy already existed in the network, this is possibly a result from item duplication.");
                ((TileProxy)this.getTile()).generateNewProxyId();
                return network.addProxy(this.getId(), this.getPos());
            }
            return true;
        }
        return false;
    }

    @Override
    public void onNetworkRemoval(IPartNetwork network) {
        super.onNetworkRemoval(network);
        network.removeProxy(this.getId());
    }

    @Override
    public int getConsumptionRate() {
        return 2;
    }

    @Override
    @Nullable
    public TileProxy getNetworkEventListener() {
        return (TileProxy)this.getTile();
    }

    @Override
    protected Class<TileProxy> getTileClass() {
        return TileProxy.class;
    }
}

