/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.tileentity;

import com.google.common.collect.Sets;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IProxyVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.api.item.IVariableFacadeHandlerRegistry;
import org.cyclops.integrateddynamics.core.evaluate.ProxyVariableFacadeHandler;
import org.cyclops.integrateddynamics.core.item.ProxyVariableFacade;
import org.cyclops.integrateddynamics.core.tileentity.TileActiveVariableBase;
import org.cyclops.integrateddynamics.network.ProxyNetworkElement;

public class TileProxy
extends TileActiveVariableBase<ProxyNetworkElement> {
    public static final int SLOT_READ = 0;
    public static final int SLOT_WRITE_IN = 1;
    public static final int SLOT_WRITE_OUT = 2;
    public static final String GLOBALCOUNTER_KEY = "proxy";
    @NBTPersist
    private int proxyId = -1;

    public TileProxy() {
        super(3, GLOBALCOUNTER_KEY);
        this.addSlotsToSide(EnumFacing.UP, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.DOWN, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.SOUTH, Sets.newHashSet((Object[])new Integer[]{0}));
        this.addSlotsToSide(EnumFacing.WEST, Sets.newHashSet((Object[])new Integer[]{2}));
        this.addSlotsToSide(EnumFacing.EAST, Sets.newHashSet((Object[])new Integer[]{1}));
    }

    public boolean func_180462_a(int slot, ItemStack itemStack, EnumFacing side) {
        return slot != 2 && super.func_180462_a(slot, itemStack, side);
    }

    public void generateNewProxyId() {
        this.proxyId = IntegratedDynamics.globalCounters.getNext(GLOBALCOUNTER_KEY);
        this.func_70296_d();
    }

    public void onLoad() {
        super.onLoad();
        if (!MinecraftHelpers.isClientSide() && this.proxyId == -1) {
            this.generateNewProxyId();
        }
    }

    @Override
    public int getSlotRead() {
        return 0;
    }

    @Override
    public void onDirty() {
        super.onDirty();
        if (!this.field_145850_b.field_72995_K && this.func_70301_a(1) != null && this.func_70301_a(2) == null) {
            ItemStack outputStack = this.writeProxyInfo(!this.func_145831_w().field_72995_K, this.func_70304_b(1), this.proxyId);
            this.func_70299_a(2, outputStack);
        }
    }

    public ItemStack writeProxyInfo(boolean generateId, ItemStack itemStack, final int proxyId) {
        IVariableFacadeHandlerRegistry registry = (IVariableFacadeHandlerRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(IVariableFacadeHandlerRegistry.class);
        return registry.writeVariableFacadeItem(generateId, itemStack, ProxyVariableFacadeHandler.getInstance(), new IVariableFacadeHandlerRegistry.IVariableFacadeFactory<IProxyVariableFacade>(){

            @Override
            public IProxyVariableFacade create(boolean generateId) {
                return new ProxyVariableFacade(generateId, proxyId);
            }

            @Override
            public IProxyVariableFacade create(int id) {
                return new ProxyVariableFacade(id, proxyId);
            }
        });
    }

    @Override
    protected void preValidate(IVariableFacade variableStored) {
        super.preValidate(variableStored);
        if (variableStored instanceof IProxyVariableFacade && ((IProxyVariableFacade)variableStored).getProxyId() == this.getProxyId()) {
            this.addError(new L10NHelpers.UnlocalizedString("variable.integrateddynamics.error.recursion", new Object[]{variableStored.getId()}));
        }
    }

    public int getProxyId() {
        return this.proxyId;
    }
}

