/*
 * Decompiled with CFR 0.152.
 */
package aroma1997.backup;

import aroma1997.backup.AromaBackup;
import aroma1997.backup.Config;
import aroma1997.backup.ThreadBackup;
import aroma1997.core.log.LogHelper;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.apache.logging.log4j.Level;

public class ThreadSchedule
extends Thread {
    private static ThreadSchedule instance;
    private boolean shouldrun = true;
    static long nextbackup;

    public ThreadSchedule() {
        instance = this;
        this.setName("AromaBackup-Schedule");
        this.setDaemon(true);
        nextbackup = System.currentTimeMillis() + Config.instance.delay;
        this.start();
    }

    @Override
    public void run() {
        AromaBackup.instance.logger.log(Level.INFO, "Starting Backup Schedule.");
        while (this.shouldrun && FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
            if (nextbackup > System.currentTimeMillis() || ThreadBackup.isRunning()) {
                try {
                    ThreadSchedule.sleep(2500L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            LogHelper.debugLog((String)"Doing a non-forced Backup.");
            ThreadBackup.doBackup();
        }
        LogHelper.debugLog((String)("shouldrun = " + this.shouldrun + " Server = " + FMLCommonHandler.instance().getMinecraftServerInstance()));
        AromaBackup.instance.logger.log(Level.INFO, "Stopping Backup Schedule.");
    }

    public static boolean isScheduleThreadRunning() {
        return instance != null && ThreadSchedule.instance.shouldrun;
    }

    public static void startNewThread() {
        if (!ThreadSchedule.isScheduleThreadRunning()) {
            new ThreadSchedule();
        }
    }

    public static void stopThread() {
        if (ThreadSchedule.isScheduleThreadRunning()) {
            ThreadSchedule.instance.shouldrun = false;
        }
    }
}

