/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.bagginses.event;

import java.util.ArrayList;
import java.util.Iterator;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import nl.lang2619.bagginses.helpers.BagFinder;
import nl.lang2619.bagginses.inventory.InventoryBag;
import nl.lang2619.bagginses.items.bags.Bag;
import nl.lang2619.bagginses.items.bags.container.BagContainer;
import nl.lang2619.bagginses.references.BagMode;
import nl.lang2619.bagginses.references.BagTypes;

public class ItemDropEvent {
    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        EntityPlayer player;
        ItemStack bagStack;
        if (event.getSource().func_76355_l() == "player" && (bagStack = BagFinder.getBag(player = (EntityPlayer)event.getSource().func_76346_g())) != null) {
            Bag bag = (Bag)bagStack.func_77973_b();
            if (bag.getMode() != BagMode.PICKUP) {
                return;
            }
            if (bag.getType() == BagTypes.VOID) {
                return;
            }
            Iterator drops = event.getDrops().iterator();
            ArrayList<EntityItem> toRemove = new ArrayList<EntityItem>();
            if (bag.getType() == BagTypes.ENDER) {
                while (drops.hasNext()) {
                    EntityItem stack = (EntityItem)drops.next();
                    if (player.func_71005_bN().func_174894_a(stack.func_92059_d()) != null) continue;
                    toRemove.add(stack);
                }
            } else {
                BagTypes type = bag.getType();
                InventoryBag inv = new InventoryBag(bagStack);
                BagContainer container = new BagContainer(player, inv);
                block1: while (drops.hasNext()) {
                    EntityItem stack = (EntityItem)drops.next();
                    for (int i = 0; i < type.getColumns() * type.getRows(); ++i) {
                        if (!container.func_75139_a(i).func_75214_a(stack.func_92059_d())) continue;
                        if (inv.func_70301_a(i) == null) {
                            inv.func_70299_a(i, stack.func_92059_d());
                            toRemove.add(stack);
                            continue block1;
                        }
                        if (!ItemStack.func_179545_c((ItemStack)inv.func_70301_a(i), (ItemStack)stack.func_92059_d())) continue;
                        ItemStack invStack = inv.func_70301_a(i);
                        Slot slot = container.func_75139_a(i);
                        int resultingStackSize = stack.func_92059_d().field_77994_a + invStack.field_77994_a;
                        int max = Math.min(stack.func_92059_d().func_77976_d(), slot.func_75219_a());
                        if (resultingStackSize <= max) {
                            invStack.field_77994_a = resultingStackSize;
                            toRemove.add(stack);
                            continue block1;
                        }
                        if (invStack.field_77994_a >= max) continue;
                        stack.func_92059_d().field_77994_a -= max - invStack.field_77994_a;
                        invStack.field_77994_a = max;
                    }
                }
                inv.save();
            }
            event.getDrops().removeAll(toRemove);
        }
    }

    @SubscribeEvent
    public void onBlockDrops(BlockEvent.HarvestDropsEvent event) {
        ItemStack bagStack;
        if (event.getHarvester() != null && (bagStack = BagFinder.getBag(event.getHarvester())) != null) {
            Bag bag = (Bag)bagStack.func_77973_b();
            if (bag.getMode() != BagMode.PICKUP) {
                return;
            }
            if (bag.getType() == BagTypes.VOID) {
                return;
            }
            Iterator drops = event.getDrops().iterator();
            ArrayList<ItemStack> toRemove = new ArrayList<ItemStack>();
            if (bag.getType() == BagTypes.ENDER) {
                while (drops.hasNext()) {
                    ItemStack stack = (ItemStack)drops.next();
                    if (event.getHarvester().func_71005_bN().func_174894_a(stack) != null) continue;
                    toRemove.add(stack);
                }
            } else {
                BagTypes type = bag.getType();
                InventoryBag inv = new InventoryBag(bagStack);
                BagContainer container = new BagContainer(event.getHarvester(), inv);
                block1: while (drops.hasNext()) {
                    ItemStack stack = (ItemStack)drops.next();
                    for (int i = 0; i < type.getColumns() * type.getRows(); ++i) {
                        if (!container.func_75139_a(i).func_75214_a(stack)) continue;
                        if (inv.func_70301_a(i) == null) {
                            inv.func_70299_a(i, stack);
                            toRemove.add(stack);
                            continue block1;
                        }
                        if (!ItemStack.func_179545_c((ItemStack)inv.func_70301_a(i), (ItemStack)stack)) continue;
                        ItemStack invStack = inv.func_70301_a(i);
                        Slot slot = container.func_75139_a(i);
                        int resultingStackSize = stack.field_77994_a + invStack.field_77994_a;
                        int max = Math.min(stack.func_77976_d(), slot.func_75219_a());
                        if (resultingStackSize <= max) {
                            invStack.field_77994_a = resultingStackSize;
                            toRemove.add(stack);
                            continue block1;
                        }
                        if (invStack.field_77994_a >= max) continue;
                        stack.field_77994_a -= max - invStack.field_77994_a;
                        invStack.field_77994_a = max;
                    }
                }
                inv.save();
            }
            event.getDrops().removeAll(toRemove);
        }
    }
}

