/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.bagginses.gameanalytics.minecraft;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nl.lang2619.bagginses.gameanalytics.events.GAUserEvent;
import nl.lang2619.bagginses.gameanalytics.minecraft.MCSimpleAnalytics;
import nl.lang2619.bagginses.gameanalytics.util.ACLock;

public final class ActivityReportTickEventHandler {
    private static ACLock lock = new ACLock();
    private static boolean initialized;
    private static List<MCSimpleAnalytics> analyticsList;
    private static long nextActivityReport;
    private static GAUserEvent activityGAEvent;

    private ActivityReportTickEventHandler() {
    }

    static void addToReportList(MCSimpleAnalytics mcSimpleAnalytics) {
        try (ACLock acl = lock.lockAC();){
            if (!initialized) {
                initialized = true;
                FMLCommonHandler.instance().bus().register((Object)new ActivityReportTickEventHandler());
            }
            for (MCSimpleAnalytics analytics : analyticsList) {
                String mod;
                if (!analytics.gameKey().equals(mcSimpleAnalytics.gameKey()) || !analytics.secretKey().equals(mcSimpleAnalytics.secretKey()) || analytics.isClient != mcSimpleAnalytics.isClient) continue;
                try {
                    ModContainer activeMod = Loader.instance().activeModContainer();
                    StringBuilder sb = new StringBuilder(activeMod.getModId());
                    sb.append(" -> ").append(activeMod.getName());
                    mod = sb.toString();
                }
                catch (Exception e) {
                    mod = "Some mod";
                }
                System.err.println(mod + " tried to instantiate an MCSimpleAnalytics instance with a key pair that was already registered!" + " If you see this message, please report it to the mod developer!");
                return;
            }
            analyticsList.add(mcSimpleAnalytics);
        }
    }

    private static void sendAnalyticsActivityEvent() {
        block17: {
            long now = System.currentTimeMillis();
            if (now >= nextActivityReport) {
                try (ACLock acl = lock.lockAC();){
                    if (now < nextActivityReport) break block17;
                    nextActivityReport = now + 10000L;
                    for (MCSimpleAnalytics analytics : analyticsList) {
                        if (!analytics.isActive()) continue;
                        if (activityGAEvent == null) {
                            GAUserEvent ae = new GAUserEvent(analytics);
                            try {
                                ae.installSite(analytics.isClient ? Minecraft.func_71410_x().field_71474_y.field_74363_ab : "server");
                                ae.installAdGroup(System.getProperty("os.arch"));
                                ae.installAd(System.getProperty("os.name"));
                                ae.installCampaign(System.getProperty("os.version"));
                                ae.installPublisher(System.getProperty("java.runtime.version"));
                                ae.installKeyword(analytics.isClient ? "client" : "server");
                            }
                            catch (Exception e) {
                                System.err.println("Couldnot get all system properties: " + e);
                            }
                            activityGAEvent = ae;
                        }
                        analytics.event(activityGAEvent, false);
                    }
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ActivityReportTickEventHandler.sendAnalyticsActivityEvent();
        }
    }

    @SideOnly(value=Side.SERVER)
    @SubscribeEvent
    public void serverTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ActivityReportTickEventHandler.sendAnalyticsActivityEvent();
        }
    }

    static {
        analyticsList = new ArrayList<MCSimpleAnalytics>();
        nextActivityReport = 0L;
    }
}

