/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.bagginses.items.bags;

import com.mojang.realmsclient.gui.ChatFormatting;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryEnderChest;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import nl.lang2619.bagginses.Bagginses;
import nl.lang2619.bagginses.config.ModConfig;
import nl.lang2619.bagginses.helpers.ChatUtils;
import nl.lang2619.bagginses.helpers.ItemHelper;
import nl.lang2619.bagginses.helpers.NBTHelper;
import nl.lang2619.bagginses.items.ModItems;
import nl.lang2619.bagginses.references.BagMode;
import nl.lang2619.bagginses.references.BagTypes;

public class Bag
extends Item {
    String color;
    BagTypes type;
    BagMode mode;

    public Bag(String color, BagTypes type) {
        this.field_77777_bU = 1;
        this.func_77637_a(Bagginses.BagTab);
        this.color = color;
        this.type = type;
        this.mode = BagMode.DEFAULT;
    }

    public String getColor() {
        return this.color;
    }

    public BagTypes getType() {
        return this.type;
    }

    public BagMode getMode() {
        return this.mode;
    }

    public String func_77667_c(ItemStack itemStack) {
        if (this.type == BagTypes.TIER2) {
            return "backpack_" + this.color + "T2";
        }
        if (this.type == BagTypes.TIER3) {
            return "backpack_" + this.color + "T3";
        }
        return "backpack_" + this.color;
    }

    public boolean func_77651_p() {
        return true;
    }

    public boolean func_77636_d(ItemStack stack) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("soulbound") && stack.func_77978_p().func_74767_n("soulbound")) {
            return true;
        }
        return stack.func_77948_v();
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack itemStack, World world, EntityPlayer player, EnumHand hand) {
        if (player.func_70093_af()) {
            this.changeMode(itemStack, world, player, hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
        }
        if (!world.field_72995_K) {
            if (!ItemHelper.hasOwnerUUID(itemStack)) {
                ItemHelper.setOwner(itemStack, player);
            }
            NBTHelper.setUUID(itemStack);
            NBTHelper.setBoolean(itemStack, "bagOpen", true);
            if (this.type == BagTypes.TIER1) {
                player.openGui((Object)Bagginses.instance, 0, world, 0, 0, 0);
            }
            if (this.type == BagTypes.TIER2) {
                player.openGui((Object)Bagginses.instance, 2, world, 0, 0, 0);
            }
            if (this.type == BagTypes.TIER3) {
                player.openGui((Object)Bagginses.instance, 3, world, 0, 0, 0);
            }
            if (this.type == BagTypes.VOID) {
                player.openGui((Object)Bagginses.instance, 1, world, 0, 0, 0);
            }
            if (this.type == BagTypes.ENDER) {
                InventoryEnderChest inventoryEnderChest = player.func_71005_bN();
                player.func_71007_a((IInventory)inventoryEnderChest);
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
    }

    private void changeMode(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (this.type == BagTypes.VOID) {
            return;
        }
        if (!ModConfig.bagPickUp) {
            return;
        }
        this.mode = this.mode.next();
        if (world.field_72995_K) {
            ChatUtils.sendNoSpamMessages(14, (ITextComponent)new TextComponentString(ChatFormatting.AQUA + "Mode: " + this.mode.getName()));
        }
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean advanced) {
        super.func_77624_a(stack, player, list, advanced);
        if (((Bag)stack.func_77973_b()).getMode() != BagMode.DEFAULT) {
            list.add(ChatFormatting.AQUA + "Mode: " + (Object)((Object)this.mode));
        }
        if (this.isSoulBound(stack)) {
            list.add(ChatFormatting.LIGHT_PURPLE + "Soulbound");
        }
        try {
            String msg = "";
            if (ModItems.bags.get(this.color).getServerDesc() != null && !ModItems.bags.get(this.color).getServerDesc().equals("")) {
                msg = ModItems.bags.get(this.color).getServerDesc();
            } else if (ModItems.bags.get(this.color).getDesc() != null && !ModItems.bags.get(this.color).getDesc().equals("")) {
                msg = ModItems.bags.get(this.color).getDesc();
            }
            if (!"".equals(msg)) {
                String[] parts = msg.split("\n");
                for (int i = 0; i < Math.min(3, parts.length); ++i) {
                    if (parts[i] == null || "".equals(parts[i])) continue;
                    list.add(parts[i]);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private boolean isSoulBound(ItemStack stack) {
        try {
            if (stack != null && stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("soulbound") && stack.func_77978_p().func_74767_n("soulbound")) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

