/*
 * Decompiled with CFR 0.152.
 */
package nl.lang2619.bagginses.items.bags.container;

import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import nl.lang2619.bagginses.config.ModConfig;
import nl.lang2619.bagginses.helpers.NBTHelper;
import nl.lang2619.bagginses.inventory.InventoryBag;
import nl.lang2619.bagginses.items.bags.Bag;
import nl.lang2619.bagginses.items.bags.container.ContainerBagginses;
import nl.lang2619.bagginses.references.BagTypes;
import nl.lang2619.bagginses.references.BlockList;
import nl.lang2619.bagginses.references.StackUtils;

public class BagContainer
extends ContainerBagginses {
    int bagStartX = 0;
    int bagStartY = 0;
    private final EntityPlayer entityPlayer;
    public final InventoryBag inventoryBag;
    private int blockedSlot;
    private int bagInventoryRows;
    private int bagInventoryColumns;
    boolean foid = false;
    String color;

    public BagContainer(EntityPlayer entityPlayer, InventoryBag inventoryBag) {
        this.entityPlayer = entityPlayer;
        this.inventoryBag = inventoryBag;
        Bag item = (Bag)inventoryBag.parentItemStack.func_77973_b();
        BagTypes type = item.getType();
        this.color = item.getColor();
        this.foid = type == BagTypes.VOID;
        this.bagInventoryRows = type.getRows();
        this.bagInventoryColumns = type.getColumns();
        this.bagStartX = type.getBagStartX();
        this.bagStartY = type.getBagStartY();
        int i = 0;
        for (int bagRowIndex = 0; bagRowIndex < this.bagInventoryRows; ++bagRowIndex) {
            for (int bagColumnIndex = 0; bagColumnIndex < this.bagInventoryColumns; ++bagColumnIndex) {
                this.func_75146_a(new SlotBag(this, inventoryBag, entityPlayer, bagColumnIndex + bagRowIndex * this.bagInventoryColumns, this.bagStartX + bagColumnIndex * 18, this.bagStartY + bagRowIndex * 18));
                ++i;
            }
        }
        int added = 0;
        if (this.foid) {
            added = 36;
        }
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, inventoryColumnIndex + inventoryRowIndex * 9 + 9, 8 + inventoryColumnIndex * 18, 30 + 18 * this.bagInventoryRows + inventoryRowIndex * 18 + added));
            }
        }
        for (int actionBarSlotIndex = 0; actionBarSlotIndex < 9; ++actionBarSlotIndex) {
            this.func_75146_a(new Slot((IInventory)entityPlayer.field_71071_by, actionBarSlotIndex, 8 + actionBarSlotIndex * 18, 30 + 18 * this.bagInventoryRows + 58 + added));
        }
        this.blockedSlot = entityPlayer.field_71071_by.field_70461_c + 27 + i;
    }

    public void func_75134_a(EntityPlayer player) {
        super.func_75134_a(player);
        if (!player.field_70170_p.field_72995_K) {
            InventoryPlayer invPlayer = player.field_71071_by;
            for (ItemStack itemStack : invPlayer.field_70462_a) {
                if (itemStack == null || !NBTHelper.hasTag(itemStack, "bagOpen")) continue;
                NBTHelper.removeTag(itemStack, "bagOpen");
            }
            this.saveInventory(player);
        }
    }

    public boolean isItemStackParent(ItemStack itemStack) {
        if (NBTHelper.hasUUID(itemStack)) {
            UUID stackUUID = new UUID(itemStack.func_77978_p().func_74763_f("UUIDMostSig"), itemStack.func_77978_p().func_74763_f("UUIDLeastSig"));
            return this.inventoryBag.matchesUUID(stackUUID);
        }
        return false;
    }

    public ItemStack func_82846_b(EntityPlayer p, int slotIndex) {
        if (!this.foid) {
            ItemStack newItemStack = null;
            Slot slot = (Slot)this.field_75151_b.get(slotIndex);
            if (slot != null && slot.func_75216_d()) {
                ItemStack itemStack = slot.func_75211_c();
                newItemStack = itemStack.func_77946_l();
                if (slotIndex < this.bagInventoryRows * this.bagInventoryColumns ? !this.func_75135_a(itemStack, this.bagInventoryRows * this.bagInventoryColumns, this.field_75151_b.size(), false) : (itemStack.func_77973_b() instanceof Bag ? (slotIndex < this.bagInventoryRows * this.bagInventoryColumns + 27 ? !this.func_75135_a(itemStack, this.bagInventoryRows * this.bagInventoryColumns + 27, this.field_75151_b.size(), false) : !this.func_75135_a(itemStack, this.bagInventoryRows * this.bagInventoryColumns, this.bagInventoryRows * this.bagInventoryColumns + 27, false)) : !this.func_75135_a(itemStack, 0, this.bagInventoryRows * this.bagInventoryColumns, false))) {
                    return null;
                }
                if (itemStack.field_77994_a == 0) {
                    slot.func_75215_d(null);
                } else {
                    slot.func_75218_e();
                }
            }
            return newItemStack;
        }
        return this.transferVoid(p, slotIndex);
    }

    private ItemStack transferVoid(EntityPlayer player, int slotIndex) {
        ItemStack originalStack = null;
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        int numSlots = this.field_75151_b.size();
        if (slot != null && slot.func_75216_d()) {
            ItemStack stackInSlot = slot.func_75211_c();
            originalStack = stackInSlot.func_77946_l();
            if ((slotIndex < numSlots - 36 || !this.tryShiftItem(stackInSlot, numSlots)) && (slotIndex >= numSlots - 36 && slotIndex < numSlots - 9 ? !this.shiftItemStack(stackInSlot, numSlots - 9, numSlots) : (slotIndex >= numSlots - 9 && slotIndex < numSlots ? !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots - 9) : !this.shiftItemStack(stackInSlot, numSlots - 36, numSlots)))) {
                return null;
            }
            slot.func_75220_a(stackInSlot, originalStack);
            if (stackInSlot.field_77994_a <= 0) {
                slot.func_75215_d(null);
            } else {
                slot.func_75218_e();
            }
            if (stackInSlot.field_77994_a == originalStack.field_77994_a) {
                return null;
            }
            slot.func_82870_a(player, stackInSlot);
        }
        return originalStack;
    }

    private boolean tryShiftItem(ItemStack stackToShift, int numSlots) {
        for (int machineIndex = 0; machineIndex < numSlots - 36; ++machineIndex) {
            Slot slot = (Slot)this.field_75151_b.get(machineIndex);
            if (!slot.func_75214_a(stackToShift) || !this.shiftItemStack(stackToShift, machineIndex, machineIndex + 1)) continue;
            return true;
        }
        return false;
    }

    protected boolean shiftItemStack(ItemStack stackToShift, int start, int end) {
        ItemStack stackInSlot;
        Slot slot;
        int slotIndex;
        boolean changed = false;
        if (stackToShift.func_77985_e()) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot == null || !StackUtils.isIdenticalItem(stackInSlot, stackToShift)) continue;
                int resultingStackSize = stackInSlot.field_77994_a + stackToShift.field_77994_a;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                if (resultingStackSize <= max) {
                    stackToShift.field_77994_a = 0;
                    stackInSlot.field_77994_a = resultingStackSize;
                    slot.func_75218_e();
                    changed = true;
                    continue;
                }
                if (stackInSlot.field_77994_a >= max) continue;
                stackToShift.field_77994_a -= max - stackInSlot.field_77994_a;
                stackInSlot.field_77994_a = max;
                slot.func_75218_e();
                changed = true;
            }
        }
        if (stackToShift.field_77994_a > 0) {
            for (slotIndex = start; stackToShift.field_77994_a > 0 && slotIndex < end; ++slotIndex) {
                slot = (Slot)this.field_75151_b.get(slotIndex);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot != null) continue;
                int max = Math.min(stackToShift.func_77976_d(), slot.func_75219_a());
                stackInSlot = stackToShift.func_77946_l();
                stackInSlot.field_77994_a = Math.min(stackToShift.field_77994_a, max);
                stackToShift.field_77994_a -= stackInSlot.field_77994_a;
                slot.func_75215_d(stackInSlot);
                slot.func_75218_e();
                changed = true;
            }
        }
        return changed;
    }

    public void saveInventory(EntityPlayer player) {
        this.inventoryBag.onGuiSaved(player);
    }

    public int getNumColumns() {
        return this.bagInventoryRows;
    }

    public ItemStack func_184996_a(int slotID, int clickedButton, ClickType clickType, EntityPlayer player) {
        if (slotID == this.blockedSlot) {
            return null;
        }
        return super.func_184996_a(slotID, clickedButton, clickType, player);
    }

    private class SlotBag
    extends Slot {
        private final EntityPlayer entityPlayer;
        private BagContainer containerBag;

        public SlotBag(BagContainer containerBag, IInventory inventory, EntityPlayer entityPlayer, int slotIndex, int x, int y) {
            super(inventory, slotIndex, x, y);
            this.entityPlayer = entityPlayer;
            this.containerBag = containerBag;
        }

        public void func_75218_e() {
            super.func_75218_e();
            if (!BagContainer.this.foid && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
                this.containerBag.saveInventory(this.entityPlayer);
            }
        }

        public boolean func_75214_a(ItemStack itemStack) {
            if (itemStack == null) {
                return true;
            }
            itemStack = itemStack.func_77946_l();
            itemStack.field_77994_a = 1;
            if (!(itemStack.func_77973_b() instanceof Bag)) {
                if (BagContainer.this.foid) {
                    return true;
                }
                if (ModConfig.whitelist) {
                    return BlockList.contains(itemStack.func_77973_b(), itemStack.func_77952_i(), BagContainer.this.color);
                }
                return !BlockList.contains(itemStack.func_77973_b(), itemStack.func_77952_i(), BagContainer.this.color);
            }
            return false;
        }
    }
}

