/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.api.client.render;

import com.enderio.core.api.client.render.IWidgetIcon;
import com.enderio.core.client.render.RenderUtil;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;

public interface IWidgetMap {
    public int getSize();

    public ResourceLocation getTexture();

    public void render(IWidgetIcon var1, double var2, double var4);

    public void render(IWidgetIcon var1, double var2, double var4, boolean var6);

    public void render(IWidgetIcon var1, double var2, double var4, boolean var6, boolean var7);

    public void render(IWidgetIcon var1, double var2, double var4, double var6, boolean var8);

    public void render(IWidgetIcon var1, double var2, double var4, double var6, boolean var8, boolean var9);

    public void render(IWidgetIcon var1, double var2, double var4, double var6, double var8, double var10, boolean var12);

    public void render(IWidgetIcon var1, double var2, double var4, double var6, double var8, double var10, boolean var12, boolean var13);

    public static class WidgetMapImpl
    implements IWidgetMap {
        private final int size;
        private final ResourceLocation res;

        public WidgetMapImpl(int size, ResourceLocation res) {
            this.size = size;
            this.res = res;
        }

        @Override
        public int getSize() {
            return this.size;
        }

        @Override
        public ResourceLocation getTexture() {
            return this.res;
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y) {
            this.render(widget, x, y, false);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, boolean doDraw) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), 0.0, doDraw);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, boolean doDraw, boolean flipY) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), 0.0, doDraw, flipY);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, double zLevel, boolean doDraw) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), zLevel, doDraw);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, double zLevel, boolean doDraw, boolean flipY) {
            this.render(widget, x, y, widget.getWidth(), widget.getHeight(), zLevel, doDraw, flipY);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw) {
            this.render(widget, x, y, width, height, zLevel, doDraw, false);
        }

        @Override
        public void render(IWidgetIcon widget, double x, double y, double width, double height, double zLevel, boolean doDraw, boolean flipY) {
            VertexBuffer tes = Tessellator.func_178181_a().func_178180_c();
            if (doDraw) {
                RenderUtil.bindTexture(this.getTexture());
                tes.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            }
            double minU = (double)widget.getX() / (double)this.getSize();
            double maxU = (double)(widget.getX() + widget.getWidth()) / (double)this.getSize();
            double minV = (double)widget.getY() / (double)this.getSize();
            double maxV = (double)(widget.getY() + widget.getHeight()) / (double)this.getSize();
            if (flipY) {
                tes.func_181662_b(x, y + height, zLevel).func_187315_a(minU, minV).func_181675_d();
                tes.func_181662_b(x + width, y + height, zLevel).func_187315_a(maxU, minV).func_181675_d();
                tes.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(maxU, maxV).func_181675_d();
                tes.func_181662_b(x, y + 0.0, zLevel).func_187315_a(minU, maxV).func_181675_d();
            } else {
                tes.func_181662_b(x, y + height, zLevel).func_187315_a(minU, maxV).func_181675_d();
                tes.func_181662_b(x + width, y + height, zLevel).func_187315_a(maxU, maxV).func_181675_d();
                tes.func_181662_b(x + width, y + 0.0, zLevel).func_187315_a(maxU, minV).func_181675_d();
                tes.func_181662_b(x, y + 0.0, zLevel).func_187315_a(minU, minV).func_181675_d();
            }
            if (widget.getOverlay() != null) {
                widget.getOverlay().getMap().render(widget.getOverlay(), x, y, width, height, zLevel, false, flipY);
            }
            if (doDraw) {
                Tessellator.func_178181_a().func_78381_a();
            }
        }
    }
}

