/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.network;

import com.enderio.core.common.network.NetworkUtil;
import com.enderio.core.common.util.Log;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageTileNBT
implements IMessage,
IMessageHandler<MessageTileNBT, IMessage> {
    TileEntity te;
    long pos;
    NBTTagCompound tags;
    boolean renderOnUpdate = false;

    public MessageTileNBT() {
    }

    public MessageTileNBT(TileEntity te) {
        this.te = te;
        this.pos = te.func_174877_v().func_177986_g();
        this.tags = new NBTTagCompound();
        te.func_189515_b(this.tags);
    }

    public void toBytes(ByteBuf buffer) {
        buffer.writeLong(this.pos);
        NetworkUtil.writeNBTTagCompound(this.tags, buffer);
    }

    public void fromBytes(ByteBuf dis) {
        this.pos = dis.readLong();
        this.tags = NetworkUtil.readNBTTagCompound(dis);
    }

    public BlockPos getPos() {
        return BlockPos.func_177969_a((long)this.pos);
    }

    public IMessage onMessage(MessageTileNBT msg, MessageContext ctx) {
        this.te = this.handle(ctx.getServerHandler().field_147369_b.field_70170_p);
        if (this.te != null && this.renderOnUpdate) {
            IBlockState bs = this.te.func_145831_w().func_180495_p(msg.getPos());
            this.te.func_145831_w().func_184138_a(msg.getPos(), bs, bs, 3);
        }
        return null;
    }

    private TileEntity handle(World world) {
        if (world == null) {
            Log.warn("PacketUtil.handleTileEntityPacket: TileEntity null world processing tile entity packet.");
            return null;
        }
        TileEntity te = world.func_175625_s(this.getPos());
        if (te == null) {
            Log.warn("PacketUtil.handleTileEntityPacket: TileEntity null when processing tile entity packet.");
            return null;
        }
        te.func_145839_a(this.tags);
        return te;
    }
}

