/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.api.common.util.ITankAccess;
import com.enderio.core.common.util.ItemUtil;
import com.enderio.core.common.util.Util;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.wrappers.FluidContainerItemWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidContainerRegistryWrapper;
import net.minecraftforge.fluids.capability.wrappers.FluidHandlerWrapper;

public class FluidUtil {
    @CapabilityInject(value=IFluidHandler.class)
    private static final Capability<IFluidHandler> FLUID_HANDLER = null;

    public static IFluidHandler getFluidHandlerCapability(@Nullable ICapabilityProvider provider, EnumFacing side) {
        if (provider != null && provider.hasCapability(FLUID_HANDLER, side)) {
            return (IFluidHandler)provider.getCapability(FLUID_HANDLER, side);
        }
        return FluidUtil.getLegacyHandler(provider, side);
    }

    public static IFluidHandler getFluidHandlerCapability(ItemStack stack) {
        return FluidUtil.getFluidHandlerCapability((ICapabilityProvider)stack, null);
    }

    @Deprecated
    private static IFluidHandler getLegacyHandler(ICapabilityProvider provider, EnumFacing side) {
        if (provider instanceof ItemStack) {
            ItemStack stack = (ItemStack)provider;
            if (stack.func_77973_b() instanceof IFluidContainerItem) {
                return new FluidContainerItemWrapper((IFluidContainerItem)stack.func_77973_b(), stack);
            }
            if (FluidContainerRegistry.isContainer((ItemStack)stack)) {
                return new FluidContainerRegistryWrapper(stack);
            }
        }
        if (provider instanceof net.minecraftforge.fluids.IFluidHandler) {
            return new FluidHandlerWrapper((net.minecraftforge.fluids.IFluidHandler)provider, side);
        }
        return null;
    }

    public static Map<EnumFacing, IFluidHandler> getNeighbouringFluidHandlers(World worldObj, BlockPos location) {
        HashMap<EnumFacing, IFluidHandler> res = new HashMap<EnumFacing, IFluidHandler>();
        for (EnumFacing dir : EnumFacing.field_82609_l) {
            IFluidHandler fh = FluidUtil.getFluidHandler(worldObj, location.func_177972_a(dir), dir.func_176734_d());
            if (fh == null) continue;
            res.put(dir, fh);
        }
        return res;
    }

    private static IFluidHandler getFluidHandler(World worldObj, BlockPos location, EnumFacing side) {
        return FluidUtil.getFluidHandlerCapability((ICapabilityProvider)worldObj.func_175625_s(location), side);
    }

    public static FluidStack getFluidTypeFromItem(ItemStack stack) {
        Fluid fluid;
        if (stack == null) {
            return null;
        }
        stack = stack.func_77946_l();
        stack.field_77994_a = 1;
        IFluidHandler handler = FluidUtil.getFluidHandlerCapability(stack);
        if (handler != null) {
            return handler.drain(1000, false);
        }
        if (Block.func_149634_a((Item)stack.func_77973_b()) instanceof IFluidBlock && (fluid = ((IFluidBlock)Block.func_149634_a((Item)stack.func_77973_b())).getFluid()) != null) {
            return new FluidStack(fluid, 1000);
        }
        return null;
    }

    public static boolean isFluidContainer(ItemStack stack) {
        return FluidUtil.isFluidContainer((ICapabilityProvider)stack, null);
    }

    public static boolean isFluidContainer(ICapabilityProvider provider, EnumFacing side) {
        return FluidUtil.getFluidHandlerCapability(provider, side) != null;
    }

    public static boolean hasEmptyCapacity(ItemStack stack) {
        IFluidHandler handler = FluidUtil.getFluidHandlerCapability(stack);
        if (handler == null) {
            return false;
        }
        IFluidTankProperties[] props = handler.getTankProperties();
        if (props == null) {
            return false;
        }
        for (IFluidTankProperties tank : props) {
            int cap = tank.getCapacity();
            FluidStack contents = tank.getContents();
            if (cap < 0 || contents != null && contents.amount >= cap) continue;
            return true;
        }
        return false;
    }

    public static FluidAndStackResult tryFillContainer(ItemStack target, FluidStack source) {
        if (target == null || target.func_77973_b() == null || source == null || source.getFluid() == null || source.amount <= 0) {
            return new FluidAndStackResult(null, null, target, source);
        }
        ItemStack filledStack = target.func_77946_l();
        filledStack.field_77994_a = 1;
        IFluidHandler handler = FluidUtil.getFluidHandlerCapability(filledStack);
        if (handler == null) {
            return new FluidAndStackResult(null, null, target, source);
        }
        int filledAmount = handler.fill(source.copy(), true);
        if (filledAmount <= 0) {
            return new FluidAndStackResult(null, null, target, source);
        }
        FluidStack resultFluid = source.copy();
        resultFluid.amount = filledAmount;
        ItemStack remainderStack = target.func_77946_l();
        --remainderStack.field_77994_a;
        if (remainderStack.field_77994_a <= 0) {
            remainderStack = null;
        }
        FluidStack remainderFluid = source.copy();
        remainderFluid.amount -= filledAmount;
        if (remainderFluid.amount <= 0) {
            remainderFluid = null;
        }
        return new FluidAndStackResult(filledStack, resultFluid, remainderStack, remainderFluid);
    }

    public static FluidAndStackResult tryDrainContainer(ItemStack source, FluidStack target, int capacity) {
        FluidStack drained;
        if (source == null || source.func_77973_b() == null) {
            return new FluidAndStackResult(null, null, source, target);
        }
        ItemStack emptiedStack = source.func_77946_l();
        emptiedStack.field_77994_a = 1;
        IFluidHandler handler = FluidUtil.getFluidHandlerCapability(emptiedStack);
        if (handler == null) {
            return new FluidAndStackResult(null, null, target, source);
        }
        int maxDrain = capacity - (target != null ? target.amount : 0);
        if (target != null) {
            FluidStack available = target.copy();
            available.amount = maxDrain;
            drained = handler.drain(available, true);
        } else {
            drained = handler.drain(maxDrain, true);
        }
        if (drained == null || drained.amount <= 0) {
            return new FluidAndStackResult(null, null, source, target);
        }
        ItemStack remainderStack = source.func_77946_l();
        --remainderStack.field_77994_a;
        if (remainderStack.field_77994_a <= 0) {
            remainderStack = null;
        }
        FluidStack remainderFluid = target != null ? target.copy() : new FluidStack(drained, 0);
        remainderFluid.amount += drained.amount;
        if (emptiedStack.field_77994_a <= 0) {
            emptiedStack = null;
        }
        return new FluidAndStackResult(emptiedStack, drained, remainderStack, remainderFluid);
    }

    public static FluidAndStackResult tryDrainContainer(ItemStack source, ITankAccess tank) {
        FluidAndStackResult result = new FluidAndStackResult(null, null, null, source);
        if (source == null || source.func_77973_b() == null || tank == null) {
            return result;
        }
        ItemStack emptiedStack = source.func_77946_l();
        emptiedStack.field_77994_a = 1;
        IFluidHandler handler = FluidUtil.getFluidHandlerCapability(emptiedStack);
        if (handler == null) {
            return result;
        }
        FluidStack contentType = FluidUtil.getFluidTypeFromItem(source);
        if (contentType == null) {
            return result;
        }
        FluidTank targetTank = tank.getInputTank(contentType);
        if (targetTank == null) {
            return result;
        }
        return FluidUtil.tryDrainContainer(source, targetTank.getFluid(), targetTank.getCapacity());
    }

    public static boolean fillPlayerHandItemFromInternalTank(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ITankAccess tank) {
        return FluidUtil.fillPlayerHandItemFromInternalTank(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityPlayer, hand, tank);
    }

    public static boolean fillPlayerHandItemFromInternalTank(World world, int x, int y, int z, EntityPlayer entityPlayer, EnumHand hand, ITankAccess tank) {
        ItemStack heldItem = entityPlayer.func_184586_b(hand);
        boolean doFill = !entityPlayer.field_71075_bZ.field_75098_d || heldItem == null || heldItem.func_77973_b() != Items.field_151133_ar;
        for (FluidTank subTank : tank.getOutputTanks()) {
            FluidAndStackResult fill = FluidUtil.tryFillContainer(entityPlayer.func_184586_b(hand), subTank.getFluid());
            if (fill.result.fluidStack == null) continue;
            subTank.setFluid(fill.remainder.fluidStack);
            tank.setTanksDirty();
            if (doFill) {
                int i;
                if (fill.remainder.itemStack == null) {
                    entityPlayer.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, fill.result.itemStack);
                    return true;
                }
                entityPlayer.func_184201_a(hand == EnumHand.MAIN_HAND ? EntityEquipmentSlot.MAINHAND : EntityEquipmentSlot.OFFHAND, fill.remainder.itemStack);
                if (fill.result.itemStack.func_77985_e()) {
                    for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                        ItemStack inventoryItem = entityPlayer.field_71071_by.field_70462_a[i];
                        if (!ItemUtil.areStackMergable(inventoryItem, fill.result.itemStack) || inventoryItem.field_77994_a >= inventoryItem.func_77976_d()) continue;
                        fill.result.itemStack.field_77994_a += inventoryItem.field_77994_a;
                        entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                        return true;
                    }
                }
                for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                    if (entityPlayer.field_71071_by.field_70462_a[i] != null) continue;
                    entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                    return true;
                }
                if (!world.field_72995_K) {
                    double x0 = ((double)x + entityPlayer.field_70165_t) / 2.0;
                    double y0 = ((double)y + entityPlayer.field_70163_u) / 2.0 + 0.5;
                    double z0 = ((double)z + entityPlayer.field_70161_v) / 2.0;
                    Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
                }
            }
            return true;
        }
        return false;
    }

    public static boolean fillInternalTankFromPlayerHandItem(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ITankAccess tank) {
        return FluidUtil.fillInternalTankFromPlayerHandItem(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), entityPlayer, hand, tank);
    }

    public static boolean fillInternalTankFromPlayerHandItem(World world, int x, int y, int z, EntityPlayer entityPlayer, EnumHand hand, ITankAccess tank) {
        FluidAndStackResult fill = FluidUtil.tryDrainContainer(entityPlayer.func_184586_b(hand), tank);
        if (fill.result.fluidStack == null) {
            return false;
        }
        tank.getInputTank(fill.result.fluidStack).setFluid(fill.remainder.fluidStack);
        tank.setTanksDirty();
        if (!entityPlayer.field_71075_bZ.field_75098_d) {
            int i;
            if (fill.remainder.itemStack == null) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, fill.result.itemStack);
                return true;
            }
            entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, fill.remainder.itemStack);
            if (fill.result.itemStack == null) {
                return true;
            }
            if (fill.result.itemStack.func_77985_e()) {
                for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                    ItemStack inventoryItem = entityPlayer.field_71071_by.field_70462_a[i];
                    if (!ItemUtil.areStackMergable(inventoryItem, fill.result.itemStack) || inventoryItem.field_77994_a >= inventoryItem.func_77976_d()) continue;
                    fill.result.itemStack.field_77994_a += inventoryItem.field_77994_a;
                    entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                    return true;
                }
            }
            for (i = 0; i < entityPlayer.field_71071_by.field_70462_a.length; ++i) {
                if (entityPlayer.field_71071_by.field_70462_a[i] != null) continue;
                entityPlayer.field_71071_by.func_70299_a(i, fill.result.itemStack);
                return true;
            }
            if (!world.field_72995_K) {
                double x0 = ((double)x + entityPlayer.field_70165_t) / 2.0;
                double y0 = ((double)y + entityPlayer.field_70163_u) / 2.0 + 0.5;
                double z0 = ((double)z + entityPlayer.field_70161_v) / 2.0;
                Util.dropItems(world, fill.result.itemStack, x0, y0, z0, true);
            }
        }
        return true;
    }

    public static boolean areFluidsTheSame(Fluid fluid, Fluid fluid2) {
        if (fluid == null) {
            return fluid2 == null;
        }
        if (fluid2 == null) {
            return false;
        }
        return fluid == fluid2 || fluid.getName().equals(fluid2.getName());
    }

    public static class FluidAndStackResult {
        public final FluidAndStack result;
        public final FluidAndStack remainder;

        public FluidAndStackResult(FluidAndStack result, FluidAndStack remainder) {
            this.result = result;
            this.remainder = remainder;
        }

        public FluidAndStackResult(FluidStack fluidStackResult, ItemStack itemStackResult, FluidStack fluidStackRemainder, ItemStack itemStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }

        public FluidAndStackResult(ItemStack itemStackResult, FluidStack fluidStackResult, ItemStack itemStackRemainder, FluidStack fluidStackRemainder) {
            this.result = new FluidAndStack(fluidStackResult, itemStackResult);
            this.remainder = new FluidAndStack(fluidStackRemainder, itemStackRemainder);
        }
    }

    public static class FluidAndStack {
        public final FluidStack fluidStack;
        public final ItemStack itemStack;

        public FluidAndStack(FluidStack fluidStack, ItemStack itemStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }

        public FluidAndStack(ItemStack itemStack, FluidStack fluidStack) {
            this.fluidStack = fluidStack;
            this.itemStack = itemStack;
        }
    }
}

