/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common;

import it.zerono.mods.zerocore.lib.world.WorldGenMinableOres;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Random;
import net.minecraft.util.math.ChunkPos;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;

public class BigReactorsTickHandler {
    protected HashMap<Integer, Queue<ChunkPos>> chunkRegenMap;
    protected static final long maximumDeltaTimeNanoSecs = 16000000L;
    private final WorldGenMinableOres _oresWorldGen;

    public BigReactorsTickHandler(WorldGenMinableOres oresWorldGen) {
        this._oresWorldGen = oresWorldGen;
    }

    public void addRegenChunk(int dimensionId, ChunkPos chunkCoord) {
        if (this.chunkRegenMap == null) {
            this.chunkRegenMap = new HashMap();
        }
        if (!this.chunkRegenMap.containsKey(dimensionId)) {
            LinkedList<ChunkPos> list = new LinkedList<ChunkPos>();
            list.add(chunkCoord);
            this.chunkRegenMap.put(dimensionId, list);
        } else if (!this.chunkRegenMap.get(dimensionId).contains(chunkCoord)) {
            this.chunkRegenMap.get(dimensionId).add(chunkCoord);
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        int dimensionId;
        if (event.side == Side.SERVER && event.phase == TickEvent.Phase.END && null != this.chunkRegenMap && !event.world.field_72995_K && this.chunkRegenMap.containsKey(dimensionId = event.world.field_73011_w.getDimension())) {
            ChunkPos nextChunk;
            Queue<ChunkPos> chunksToGen = this.chunkRegenMap.get(dimensionId);
            long startTime = System.nanoTime();
            while (System.nanoTime() - startTime < 16000000L && !chunksToGen.isEmpty() && (nextChunk = chunksToGen.poll()) != null) {
                Random fmlRandom = new Random(event.world.func_72905_C());
                long xSeed = fmlRandom.nextLong() >> 3;
                long zSeed = fmlRandom.nextLong() >> 3;
                fmlRandom.setSeed(xSeed * (long)nextChunk.field_77276_a + zSeed * (long)nextChunk.field_77275_b ^ event.world.func_72905_C());
                this._oresWorldGen.generateChunk(fmlRandom, nextChunk.field_77276_a, nextChunk.field_77275_b, event.world);
            }
            if (chunksToGen.isEmpty()) {
                this.chunkRegenMap.remove(dimensionId);
            }
        }
    }
}

