/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.block;

import cofh.api.block.IDismantleable;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.block.BlockBR;
import erogenousbeef.bigreactors.common.block.DeviceType;
import erogenousbeef.bigreactors.common.interfaces.IWrenchable;
import erogenousbeef.bigreactors.common.tileentity.TileEntityCyaniteReprocessor;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityBeefBase;
import erogenousbeef.bigreactors.utils.StaticUtils;
import it.zerono.mods.zerocore.lib.block.properties.Orientation;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.oredict.OreDictionary;

public class BlockBRDevice
extends BlockBR
implements IDismantleable {
    public static final int META_CYANITE_REPROCESSOR = 0;
    private static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");
    private DeviceType _type;

    public BlockBRDevice(DeviceType type, String blockName) {
        super(blockName, Material.field_151573_f);
        this._type = type;
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(1.0f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)Orientation.HFACING, (Comparable)EnumFacing.NORTH));
    }

    @Override
    public void onPostRegister() {
        super.onPostRegister();
        String name = this._type.oreDictionaryName;
        if (name.length() > 0) {
            OreDictionary.registerOre((String)name, (ItemStack)this.createItemStack());
        }
    }

    @Override
    public void onPostClientRegister() {
        Item item = Item.func_150898_a((Block)this);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing enumfacing = EnumFacing.func_82600_a((int)meta);
        if (EnumFacing.Axis.Y == enumfacing.func_176740_k()) {
            enumfacing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)Orientation.HFACING, (Comparable)enumfacing);
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)Orientation.HFACING)).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof TileEntityBeefBase) {
            state = state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(((TileEntityBeefBase)te).isActive()));
        }
        return state;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        facing = null != placer ? placer.func_174811_aO().func_176734_d() : EnumFacing.NORTH;
        return this.func_176223_P().func_177226_a((IProperty)Orientation.HFACING, (Comparable)facing);
    }

    public void func_176213_c(World world, BlockPos position, IBlockState state) {
        EnumFacing newFacing = Orientation.suggestDefaultHorizontalFacing((World)world, (BlockPos)position, (EnumFacing)((EnumFacing)state.func_177229_b((IProperty)Orientation.HFACING)));
        world.func_180501_a(position, state.func_177226_a((IProperty)Orientation.HFACING, (Comparable)newFacing), 2);
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        switch (this._type) {
            case CyaniteReprocessor: {
                return new TileEntityCyaniteReprocessor();
            }
        }
        throw new IllegalArgumentException("Unknown device type for tile entity");
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        if (entityPlayer.func_70093_af()) {
            if (StaticUtils.Inventory.isPlayerHoldingWrench(heldItem)) {
                this.dismantleBlock(entityPlayer, world, pos, false);
                return true;
            }
            return false;
        }
        if (te instanceof IWrenchable && StaticUtils.Inventory.isPlayerHoldingWrench(heldItem)) {
            return ((IWrenchable)te).onWrench(entityPlayer, side);
        }
        if (te instanceof IFluidHandler) {
            if (FluidContainerRegistry.isEmptyContainer((ItemStack)entityPlayer.field_71071_by.func_70448_g())) {
                FluidTankInfo[] infoz;
                IFluidHandler fluidHandler = (IFluidHandler)te;
                for (FluidTankInfo info : infoz = fluidHandler.getTankInfo(side)) {
                    if (!StaticUtils.Fluids.fillContainerFromTank(world, fluidHandler, entityPlayer, info.fluid)) continue;
                    return true;
                }
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)entityPlayer.field_71071_by.func_70448_g()) && StaticUtils.Fluids.fillTankWithContainer(world, (IFluidHandler)te, entityPlayer)) {
                return true;
            }
        }
        if (te instanceof TileEntityBeefBase) {
            if (!world.field_72995_K) {
                entityPlayer.openGui((Object)BigReactors.getInstance(), 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
            return true;
        }
        return false;
    }

    public boolean canDismantle(EntityPlayer player, World world, BlockPos pos) {
        return true;
    }

    public ArrayList<ItemStack> dismantleBlock(EntityPlayer player, World world, BlockPos position, boolean returnDrops) {
        TileEntity te;
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        IBlockState blockState = world.func_180495_p(position);
        stacks.add(new ItemStack(this.func_180660_a(blockState, world.field_73012_v, 0), 1, this.func_180651_a(blockState)));
        if (returnDrops && (te = world.func_175625_s(position)) instanceof IInventory) {
            IInventory invTe = (IInventory)te;
            for (int i = 0; i < invTe.func_70302_i_(); ++i) {
                ItemStack stack = invTe.func_70301_a(i);
                if (stack == null) continue;
                stacks.add(stack);
                invTe.func_70299_a(i, null);
            }
        }
        world.func_175698_g(position);
        if (!returnDrops) {
            int x = position.func_177958_n();
            int y = position.func_177956_o();
            int z = position.func_177952_p();
            for (ItemStack stack : stacks) {
                WorldHelper.spawnItemStack((ItemStack)stack, (World)world, (double)x, (double)y, (double)z, (boolean)true);
            }
        }
        return stacks;
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{ACTIVE});
        builder.add(new IProperty[]{Orientation.HFACING});
    }
}

