/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.block.BlockBR;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import it.zerono.mods.zerocore.api.multiblock.IMultiblockPart;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import it.zerono.mods.zerocore.api.multiblock.validation.ValidationError;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockPart
extends BlockBR {
    protected final PartType _type;

    public BlockPart(PartType type, String blockName, Material material) {
        super(blockName, material);
        this._type = type;
        this.func_149672_a(SoundType.field_185852_e);
    }

    public PartType getType() {
        return this._type;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public boolean func_180639_a(World world, BlockPos posistion, IBlockState state, EntityPlayer player, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.hasTileEntity(state) && !player.func_70093_af()) {
            ModTileEntity modTe;
            TileEntity te = world.func_175625_s(posistion);
            if (te instanceof ModTileEntity && EnumHand.MAIN_HAND == hand && (modTe = (ModTileEntity)te).canOpenGui(world, posistion, state)) {
                if (WorldHelper.calledByLogicalServer((World)world)) {
                    player.openGui((Object)BigReactors.getInstance(), 0, world, posistion.func_177958_n(), posistion.func_177956_o(), posistion.func_177952_p());
                }
                return true;
            }
            if (te instanceof IMultiblockPart && WorldHelper.calledByLogicalServer((World)world) && null == heldItem && hand == EnumHand.OFF_HAND) {
                IMultiblockPart part = (IMultiblockPart)te;
                MultiblockControllerBase controller = part.getMultiblockController();
                TextComponentTranslation message = null;
                if (null != controller) {
                    ValidationError error = controller.getLastError();
                    if (null != error) {
                        message = error.getChatMessage();
                    }
                } else {
                    message = new TextComponentTranslation("multiblock.validation.block_not_connected", new Object[0]);
                }
                if (null != message) {
                    player.func_145747_a((ITextComponent)message);
                    return true;
                }
            }
        }
        return super.func_180639_a(world, posistion, state, player, hand, heldItem, side, hitX, hitY, hitZ);
    }

    public void func_189540_a(IBlockState stateAtPosition, World world, BlockPos position, Block neighbor) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborBlockChange(world, position, stateAtPosition, neighbor);
        }
    }

    public void onNeighborChange(IBlockAccess world, BlockPos position, BlockPos neighbor) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof INeighborUpdatableEntity) {
            ((INeighborUpdatableEntity)te).onNeighborTileChange(world, position, neighbor);
        }
    }

    public void func_180663_b(World world, BlockPos position, IBlockState state) {
        TileEntity te = world.func_175625_s(position);
        if (null == te) {
            return;
        }
        if (te instanceof IInventory) {
            IInventory inventory = (IInventory)te;
            int size = inventory.func_70302_i_();
            double x = position.func_177958_n();
            double y = position.func_177956_o();
            double z = position.func_177952_p();
            for (int slot = 0; slot < size; ++slot) {
                ItemStack stack = inventory.func_70304_b(slot);
                if (null == stack) continue;
                WorldHelper.spawnItemStack((ItemStack)stack, (World)world, (double)x, (double)y, (double)z, (boolean)false);
            }
        }
        world.func_175713_t(position);
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos position, EnumFacing side) {
        IBlockState sideState = blockAccess.func_180495_p(position.func_177972_a(side));
        Block sideBlock = sideState.func_177230_c();
        return sideBlock != this;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos position) {
        TileEntity te = world.func_175625_s(position);
        if (te instanceof MultiblockTileEntityBase) {
            state = this.buildActualState(state, world, position, (MultiblockTileEntityBase)te);
        }
        return state;
    }

    protected IBlockState buildActualState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos position, @Nonnull MultiblockTileEntityBase part) {
        return state;
    }
}

