/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.block.BlockPart;
import erogenousbeef.bigreactors.common.multiblock.block.ItemBlockPartTier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.IForgeRegistryEntry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTieredPart
extends BlockPart {
    private List<ItemStack> _subBlocks;

    public BlockTieredPart(PartType type, String blockName, Material material) {
        super(type, blockName, material);
    }

    @Override
    public void onPostRegister() {
        GameRegistry.register((IForgeRegistryEntry)new ItemBlockPartTier(this).setRegistryName(this.getRegistryName()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onPostClientRegister() {
        Item item = Item.func_150898_a((Block)this);
        ResourceLocation location = this.getRegistryName();
        IBlockState defaultState = this.func_176223_P();
        StringBuilder sb = new StringBuilder(32);
        boolean first = true;
        for (IProperty prop : defaultState.func_177228_b().keySet()) {
            String name = prop.func_177701_a();
            if (!first) {
                sb.append(',');
            }
            if ("tier".equals(name)) {
                sb.append("tier=%s");
            } else {
                sb.append(name);
                sb.append('=');
                sb.append(defaultState.func_177229_b(prop));
            }
            first = false;
        }
        String mapFormat = sb.toString();
        for (PartTier tier : PartTier.RELEASED_TIERS) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)tier.toMeta(), (ModelResourceLocation)new ModelResourceLocation(location, String.format(mapFormat, tier.func_176610_l())));
        }
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((PartTier)((Object)state.func_177229_b(Properties.TIER))).toMeta();
    }

    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a(Properties.TIER, (Comparable)((Object)PartTier.fromMeta(meta)));
    }

    public int func_180651_a(IBlockState state) {
        return ((PartTier)((Object)state.func_177229_b(Properties.TIER))).toMeta();
    }

    public ItemStack createItemStack(PartTier tier, int amount) {
        return new ItemStack((Block)this, amount, tier.toMeta());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List<ItemStack> list) {
        if (null == this._subBlocks) {
            PartTier[] tiers = PartTier.RELEASED_TIERS;
            int length = tiers.length;
            this._subBlocks = new ArrayList<ItemStack>(length);
            for (int i = 0; i < length; ++i) {
                this._subBlocks.add(new ItemStack(item, 1, tiers[i].toMeta()));
            }
        }
        list.addAll(this._subBlocks);
    }

    public PartTier getTierFromState(IBlockState state) {
        return (PartTier)((Object)state.func_177229_b(Properties.TIER));
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.TIER});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.TIER, (Comparable)((Object)PartTier.Legacy));
    }
}

