/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.block;

import erogenousbeef.bigreactors.common.Properties;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.common.multiblock.PartTier;
import erogenousbeef.bigreactors.common.multiblock.PartType;
import erogenousbeef.bigreactors.common.multiblock.RotorBladeState;
import erogenousbeef.bigreactors.common.multiblock.RotorShaftState;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTieredPart;
import erogenousbeef.bigreactors.common.multiblock.block.BlockTurbineRotorShaft;
import erogenousbeef.bigreactors.common.multiblock.block.ITurbineRotorPart;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityTurbineRotorBlade;
import erogenousbeef.bigreactors.init.BrBlocks;
import it.zerono.mods.zerocore.api.multiblock.MultiblockTileEntityBase;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockTurbineRotorBlade
extends BlockTieredPart
implements ITurbineRotorPart {
    private IBlockState[] _neighbors;

    public BlockTurbineRotorBlade(String blockName) {
        super(PartType.TurbineRotorBlade, blockName, Material.field_151573_f);
        this.func_149715_a(0.9f);
        this._neighbors = new IBlockState[EnumFacing.field_82609_l.length];
    }

    @Override
    public void registerRecipes() {
        if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Legacy)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Legacy, 1), new Object[]{"CII", Character.valueOf('C'), "ingotCyanite", Character.valueOf('I'), "ingotIron"}));
        }
        if (PartTier.TURBINE_TIERS.contains((Object)PartTier.Basic)) {
            GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(this.createItemStack(PartTier.Basic, 1), new Object[]{"CII", Character.valueOf('C'), "ingotCyanite", Character.valueOf('I'), "ingotIron"}));
        }
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTurbineRotorBlade();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_185481_k(IBlockState state) {
        return false;
    }

    public boolean func_176214_u() {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public int getMass(IBlockState blockState) {
        return 10;
    }

    @Override
    public boolean isShaft() {
        return false;
    }

    @Override
    public boolean isBlade() {
        return true;
    }

    @Override
    protected void buildBlockState(BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{Properties.ROTORBLADESTATE});
    }

    @Override
    protected IBlockState buildDefaultState(IBlockState state) {
        return super.buildDefaultState(state).func_177226_a(Properties.ROTORBLADESTATE, (Comparable)((Object)RotorBladeState.Z_X_POS));
    }

    @Override
    protected IBlockState buildActualState(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part) {
        return this.buildActualStateInternal(state, world, position, part, false);
    }

    public IBlockState buildActualStateInternal(IBlockState state, IBlockAccess world, BlockPos position, MultiblockTileEntityBase part, boolean buildingClientRotor) {
        IBlockState neighborState;
        MultiblockTurbine turbine;
        MultiblockTurbine multiblockTurbine = turbine = part.isConnected() ? (MultiblockTurbine)part.getMultiblockController() : null;
        if (!buildingClientRotor && null != turbine && turbine.getActive()) {
            return super.buildActualState(state, world, position, part).func_177226_a(Properties.ROTORBLADESTATE, (Comparable)((Object)RotorBladeState.HIDDEN));
        }
        RotorBladeState candidateState = null;
        int neighborsSlotCount = this._neighbors.length;
        BlockTurbineRotorShaft turbineRotorShaft = BrBlocks.turbineRotorShaft;
        for (int i = 0; i < neighborsSlotCount; ++i) {
            this._neighbors[i] = null;
        }
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            BlockPos neighborPos = position.func_177972_a(facing);
            this._neighbors[facing.func_176745_a()] = neighborState = world.func_180495_p(neighborPos);
            if (turbineRotorShaft != neighborState.func_177230_c()) continue;
            neighborState = turbineRotorShaft.buildActualStateInternal(neighborState, world, neighborPos, part, buildingClientRotor);
            candidateState = RotorBladeState.from((RotorShaftState)((Object)neighborState.func_177229_b(Properties.ROTORSHAFTSTATE)), facing);
            break;
        }
        if (null == candidateState) {
            for (EnumFacing facing : EnumFacing.field_82609_l) {
                Block checkBlock;
                int index = facing.func_176745_a();
                neighborState = this._neighbors[index];
                if (null == neighborState) {
                    neighborState = world.func_180495_p(position.func_177972_a(facing));
                }
                if (this != neighborState.func_177230_c()) continue;
                BlockPos checkPos = position;
                do {
                    IBlockState checkState;
                    if (turbineRotorShaft != (checkBlock = (checkState = world.func_180495_p(checkPos = checkPos.func_177972_a(facing))).func_177230_c())) continue;
                    checkState = turbineRotorShaft.buildActualStateInternal(checkState, world, checkPos, part, buildingClientRotor);
                    candidateState = RotorBladeState.from((RotorShaftState)((Object)checkState.func_177229_b(Properties.ROTORSHAFTSTATE)), facing);
                    break;
                } while (this == checkBlock);
                if (null != candidateState) break;
            }
        }
        if (null == candidateState) {
            candidateState = RotorBladeState.Z_X_POS;
        }
        return super.buildActualState(state, world, position, part).func_177226_a(Properties.ROTORBLADESTATE, (Comparable)((Object)candidateState));
    }
}

