/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.multiblock.tileentity;

import erogenousbeef.bigreactors.api.data.OreDictToReactantMapping;
import erogenousbeef.bigreactors.api.data.SourceProductMapping;
import erogenousbeef.bigreactors.api.registry.Reactants;
import erogenousbeef.bigreactors.client.gui.GuiReactorAccessPort;
import erogenousbeef.bigreactors.common.BRLog;
import erogenousbeef.bigreactors.common.ItemHandlerWrapper;
import erogenousbeef.bigreactors.common.MetalType;
import erogenousbeef.bigreactors.common.data.StandardReactants;
import erogenousbeef.bigreactors.common.multiblock.IInputOutputPort;
import erogenousbeef.bigreactors.common.multiblock.interfaces.INeighborUpdatableEntity;
import erogenousbeef.bigreactors.common.multiblock.tileentity.TileEntityReactorPart;
import erogenousbeef.bigreactors.gui.container.ContainerReactorAccessPort;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.api.multiblock.MultiblockControllerBase;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.lib.item.TileEntityItemStackHandler;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityReactorAccessPort
extends TileEntityReactorPart
implements INeighborUpdatableEntity,
IInputOutputPort {
    protected TileEntityItemStackHandler _fuelInventory;
    protected TileEntityItemStackHandler _wasteInventory;
    protected IItemHandler _fuelInventoryWrapper = null;
    protected IItemHandler _wasteInventoryWrapper = null;
    protected IItemHandler _adjacentInventory = null;
    protected IInputOutputPort.Direction _direction = IInputOutputPort.Direction.Input;

    public TileEntityReactorAccessPort() {
        this._fuelInventory = new TileEntityItemStackHandler((TileEntity)this, 1);
        this._wasteInventory = new TileEntityItemStackHandler((TileEntity)this, 1);
    }

    public ItemStackHandler getItemStackHandler(boolean fuel) {
        return fuel ? this._fuelInventory : this._wasteInventory;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == capability) {
            if (IInputOutputPort.Direction.Input == this._direction) {
                if (null == this._fuelInventoryWrapper) {
                    this._fuelInventoryWrapper = new ItemHandlerWrapper(this._fuelInventory){

                        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                            return null != stack && Reactants.isFuel(stack) ? this._handler.insertItem(slot, stack, simulate) : stack;
                        }
                    };
                }
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this._fuelInventoryWrapper);
            }
            if (null == this._wasteInventoryWrapper) {
                this._wasteInventoryWrapper = new ItemHandlerWrapper(this._wasteInventory){

                    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
                        return stack;
                    }
                };
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this._wasteInventoryWrapper);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean canOpenGui(World world, BlockPos posistion, IBlockState state) {
        return true;
    }

    public String getInputReactantType() {
        ItemStack inputItem = this._fuelInventory.getStackInSlot(0);
        OreDictToReactantMapping mapping = null != inputItem ? Reactants.getSolidToReactant(inputItem) : null;
        return null != mapping ? mapping.getProduct() : null;
    }

    public int getInputReactantAmount() {
        ItemStack inputItem = this._fuelInventory.getStackInSlot(0);
        OreDictToReactantMapping mapping = null != inputItem ? Reactants.getSolidToReactant(inputItem) : null;
        return null != mapping ? mapping.getProductAmount(inputItem.field_77994_a) : 0;
    }

    public int consumeReactantItem(int reactantDesired) {
        int sourceItemsToConsume;
        ItemStack inputItem = this._fuelInventory.getStackInSlot(0);
        OreDictToReactantMapping mapping = null != inputItem ? Reactants.getSolidToReactant(inputItem) : null;
        int n = sourceItemsToConsume = null != mapping ? Math.min(inputItem.field_77994_a, mapping.getSourceAmount(reactantDesired)) : 0;
        if (sourceItemsToConsume <= 0) {
            return 0;
        }
        this._fuelInventory.extractItem(0, sourceItemsToConsume, false);
        return mapping.getProductAmount(sourceItemsToConsume);
    }

    public int emitReactant(String reactantType, int amount) {
        int itemsToProduce;
        int outputItemMaxSize;
        if (reactantType == null || amount <= 0) {
            return 0;
        }
        ItemStack outputItem = this._wasteInventory.getStackInSlot(0);
        int n = outputItemMaxSize = null != outputItem ? outputItem.func_77976_d() : 64;
        if (outputItem != null && outputItem.field_77994_a >= outputItemMaxSize) {
            return 0;
        }
        if (outputItem != null) {
            OreDictToReactantMapping mapping = Reactants.getSolidToReactant(outputItem);
            if (mapping == null || !reactantType.equals(mapping.getProduct())) {
                return 0;
            }
            int amtToProduce = mapping.getSourceAmount(amount);
            if ((amtToProduce = Math.min(amtToProduce, outputItemMaxSize - outputItem.field_77994_a)) <= 0) {
                return 0;
            }
            int reactantToConsume = mapping.getProductAmount(amtToProduce);
            if (reactantToConsume <= 0) {
                return 0;
            }
            outputItem.field_77994_a += amtToProduce;
            this.onItemsReceived();
            return reactantToConsume;
        }
        SourceProductMapping bestMapping = null;
        List<SourceProductMapping> mappings = Reactants.getReactantToSolids(reactantType);
        if (mappings != null) {
            int bestReactantAmount = 0;
            for (SourceProductMapping mapping : mappings) {
                int potentialProducts = mapping.getProductAmount(amount);
                int potentialReactant = mapping.getSourceAmount(potentialProducts);
                if (bestMapping != null && bestReactantAmount >= potentialReactant) continue;
                bestMapping = mapping;
                bestReactantAmount = potentialReactant;
            }
        }
        if (bestMapping == null) {
            BRLog.warning("There are no mapped item types for reactant %s. Using cyanite instead.", reactantType);
            bestMapping = StandardReactants.cyaniteMapping;
        }
        if ((itemsToProduce = Math.min(bestMapping.getProductAmount(amount), outputItemMaxSize)) <= 0) {
            return 0;
        }
        int reactantConsumed = bestMapping.getSourceAmount(itemsToProduce);
        itemsToProduce = bestMapping.getProductAmount(reactantConsumed);
        ItemStack newItem = OreDictionaryHelper.getOre((String)bestMapping.getProduct());
        if (newItem == null) {
            BRLog.warning("Could not find item for oredict entry %s, using cyanite instead.", bestMapping.getSource());
            newItem = BrItems.ingotMetals.createItemStack(MetalType.Cyanite, 1);
        } else {
            newItem = newItem.func_77946_l();
        }
        newItem.field_77994_a = itemsToProduce;
        this._wasteInventory.setStackInSlot(0, newItem);
        this.onItemsReceived();
        return reactantConsumed;
    }

    @Override
    public void onMachineAssembled(MultiblockControllerBase controller) {
        super.onMachineAssembled(controller);
        this._adjacentInventory = null;
        this.checkForAdjacentInventories();
    }

    @Override
    public void onMachineBroken() {
        super.onMachineBroken();
        this._adjacentInventory = null;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            this._direction = IInputOutputPort.Direction.from(!data.func_74764_b("isInlet") || data.func_74767_n("isInlet"));
            if (data.func_74764_b("invI")) {
                this._fuelInventory.deserializeNBT((NBTTagCompound)data.func_74781_a("invI"));
            }
            if (data.func_74764_b("invO")) {
                this._wasteInventory.deserializeNBT((NBTTagCompound)data.func_74781_a("invO"));
            }
        } else if (data.func_74764_b("inlet")) {
            this.setDirection(IInputOutputPort.Direction.from(data.func_74767_n("inlet")), true);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            data.func_74757_a("isInlet", IInputOutputPort.Direction.Input == this._direction);
            data.func_74782_a("invI", (NBTBase)this._fuelInventory.serializeNBT());
            data.func_74782_a("invO", (NBTBase)this._wasteInventory.serializeNBT());
        } else {
            data.func_74757_a("inlet", IInputOutputPort.Direction.Input == this._direction);
        }
    }

    public Object getServerGuiElement(int guiId, EntityPlayer player) {
        return new ContainerReactorAccessPort(this, player.field_71071_by);
    }

    public Object getClientGuiElement(int guiId, EntityPlayer player) {
        return new GuiReactorAccessPort(new ContainerReactorAccessPort(this, player.field_71071_by), this);
    }

    public void onItemsReceived() {
        this.distributeItems();
        this.markChunkDirty();
    }

    @Override
    public IInputOutputPort.Direction getDirection() {
        return this._direction;
    }

    @Override
    public void setDirection(IInputOutputPort.Direction direction, boolean markForUpdate) {
        if (direction == this._direction) {
            return;
        }
        this._direction = direction;
        WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.getWorldPosition(), null, null);
        if (!this.field_145850_b.field_72995_K) {
            this.distributeItems();
            this.func_70296_d();
        }
        this.notifyNeighborsOfTileChange();
    }

    @Override
    public void toggleDirection(boolean markForUpdate) {
        this.setDirection(this._direction.opposite(), markForUpdate);
    }

    protected void distributeItems() {
        if (this.field_145850_b.field_72995_K || this._adjacentInventory == null || this.getDirection().isInput()) {
            return;
        }
        this._wasteInventory.setStackInSlot(0, ItemHandlerHelper.insertItem((IItemHandler)this._adjacentInventory, (ItemStack)this._wasteInventory.getStackInSlot(0), (boolean)false));
        this.markChunkDirty();
    }

    protected void checkForAdjacentInventories() {
        TileEntity te;
        EnumFacing facing = this.getOutwardFacing();
        IItemHandler candidateInventory = null;
        if (null != facing && null != (te = this.field_145850_b.func_175625_s(this.getWorldPosition().func_177972_a(facing))) && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d())) {
            candidateInventory = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, facing.func_176734_d());
        }
        if (this._adjacentInventory != candidateInventory) {
            this._adjacentInventory = candidateInventory;
            if (null != this._adjacentInventory) {
                this.distributeItems();
            }
        }
    }

    @Override
    public void onNeighborBlockChange(World world, BlockPos position, IBlockState stateAtPosition, Block neighborBlock) {
        this.checkForAdjacentInventories();
    }

    @Override
    public void onNeighborTileChange(IBlockAccess world, BlockPos position, BlockPos neighbor) {
        EnumFacing facing = this.getOutwardFacing();
        if (null != facing && neighbor.equals((Object)position.func_177972_a(facing))) {
            this.checkForAdjacentInventories();
        }
    }
}

