/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cofh.api.tileentity.IReconfigurableFacing;
import erogenousbeef.bigreactors.common.interfaces.IBeefReconfigurableSides;
import erogenousbeef.bigreactors.common.interfaces.IWrenchable;
import erogenousbeef.bigreactors.gui.IBeefGuiEntity;
import erogenousbeef.bigreactors.net.CommonPacketHandler;
import erogenousbeef.bigreactors.net.message.DeviceUpdateExposureMessage;
import erogenousbeef.bigreactors.net.message.DeviceUpdateRotationMessage;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import zero.temp.BlockHelper;

public abstract class TileEntityBeefBase
extends ModTileEntity
implements IBeefGuiEntity,
IBeefReconfigurableSides,
IReconfigurableFacing,
IWrenchable,
ITickable {
    private Set<EntityPlayer> updatePlayers;
    private int ticksSinceLastUpdate;
    private static final int ticksBetweenUpdates = 3;
    protected static final int SIDE_UNEXPOSED = -1;
    protected static final int[] kEmptyIntArray = new int[0];
    protected EnumFacing facing = EnumFacing.NORTH;
    int[] exposures = new int[6];

    public TileEntityBeefBase() {
        for (int i = 0; i < this.exposures.length; ++i) {
            this.exposures[i] = -1;
        }
        this.ticksSinceLastUpdate = 0;
        this.updatePlayers = new HashSet<EntityPlayer>();
    }

    public int getFacing() {
        return this.facing.func_176745_a();
    }

    public boolean setFacing(EnumFacing newFacing) {
        if (this.facing == newFacing) {
            return false;
        }
        if (!(this.allowYAxisFacing() || newFacing != EnumFacing.UP && newFacing != EnumFacing.DOWN)) {
            return false;
        }
        this.facing = newFacing;
        if (!this.field_145850_b.field_72995_K) {
            BlockPos position = this.func_174877_v();
            CommonPacketHandler.INSTANCE.sendToAllAround((IMessage)new DeviceUpdateRotationMessage(this.func_174877_v(), this.facing), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 50.0));
            this.markChunkDirty();
        }
        this.callNeighborBlockChange();
        return true;
    }

    public int getRotatedSide(EnumFacing side) {
        return BlockHelper.ICON_ROTATION_MAP[this.facing.func_176745_a()][side.func_176745_a()];
    }

    public boolean rotateBlock() {
        return this.setFacing(EnumFacing.field_82609_l[BlockHelper.SIDE_LEFT[this.facing.func_176745_a()]]);
    }

    @Override
    public boolean onWrench(EntityPlayer player, EnumFacing hitSide) {
        return this.rotateBlock();
    }

    public boolean allowYAxisFacing() {
        return false;
    }

    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        int newFacing = data.func_74764_b("facing") ? Math.max(0, Math.min(5, data.func_74762_e("facing"))) : 2;
        this.facing = EnumFacing.field_82609_l[newFacing];
        if (data.func_74764_b("exposures")) {
            int[] tagExposures = data.func_74759_k("exposures");
            assert (tagExposures.length == this.exposures.length);
            System.arraycopy(tagExposures, 0, this.exposures, 0, this.exposures.length);
        }
    }

    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        data.func_74768_a("facing", this.facing.func_176745_a());
        data.func_74783_a("exposures", this.exposures);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.updatePlayers.size() > 0) {
            ++this.ticksSinceLastUpdate;
            if (this.ticksSinceLastUpdate >= 3) {
                this.sendUpdatePacket();
                this.ticksSinceLastUpdate = 0;
            }
        }
    }

    public abstract boolean isActive();

    @Override
    public void beginUpdatingPlayer(EntityPlayer player) {
        this.updatePlayers.add(player);
        this.sendUpdatePacketToClient(player);
    }

    @Override
    public void stopUpdatingPlayer(EntityPlayer player) {
        this.updatePlayers.remove(player);
    }

    private void sendUpdatePacketToClient(EntityPlayer recipient) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
    }

    private void sendUpdatePacket() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.updatePlayers.size() <= 0) {
            return;
        }
    }

    public boolean setSide(EnumFacing side, int config) {
        int rotatedSide = this.getRotatedSide(side);
        int numConfig = this.getNumConfig(side);
        if (config >= numConfig || config < -1) {
            config = -1;
        }
        this.exposures[rotatedSide] = config;
        this.sendExposureUpdate();
        return true;
    }

    protected int getExposure(EnumFacing worldSide) {
        return this.exposures[this.getRotatedSide(worldSide)];
    }

    public void setSides(int[] newExposures) {
        assert (newExposures.length == this.exposures.length);
        System.arraycopy(newExposures, 0, this.exposures, 0, newExposures.length);
        this.sendExposureUpdate();
    }

    public boolean incrSide(EnumFacing side) {
        return this.changeSide(side, 1);
    }

    public boolean decrSide(EnumFacing side) {
        return this.changeSide(side, -1);
    }

    private boolean changeSide(EnumFacing side, int amount) {
        int rotatedSide = this.getRotatedSide(side);
        int numConfig = this.getNumConfig(side);
        if (numConfig <= 0) {
            return false;
        }
        int newConfig = this.exposures[rotatedSide] + amount;
        if (newConfig >= numConfig) {
            newConfig = -1;
        }
        return this.setSide(side, newConfig);
    }

    public boolean resetSides() {
        boolean changed = false;
        for (int i = 0; i < this.exposures.length; ++i) {
            if (this.exposures[i] == -1) continue;
            changed = true;
            this.exposures[i] = -1;
        }
        if (changed) {
            this.sendExposureUpdate();
        }
        return true;
    }

    private void sendExposureUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            BlockPos position = this.func_174877_v();
            CommonPacketHandler.INSTANCE.sendToAllAround((IMessage)new DeviceUpdateExposureMessage(this.func_174877_v(), this.exposures), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.getDimension(), (double)position.func_177958_n(), (double)position.func_177956_o(), (double)position.func_177952_p(), 50.0));
            this.markChunkDirty();
        } else {
            WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v(), null, null);
        }
        this.callNeighborTileChange();
        this.callNeighborBlockChange();
    }

    protected void onSendUpdate(NBTTagCompound updateTag) {
    }

    public void onReceiveUpdate(NBTTagCompound updateTag) {
    }

    public String getName() {
        return this.func_145838_q().func_149739_a();
    }

    public int getType() {
        return this.func_145832_p();
    }
}

