/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.common.tileentity.base;

import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import erogenousbeef.bigreactors.common.tileentity.base.TileEntityInventory;
import it.zerono.mods.zerocore.lib.block.ModTileEntity;
import it.zerono.mods.zerocore.util.WorldHelper;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class TileEntityPoweredInventory
extends TileEntityInventory
implements IEnergyHandler,
ITickable {
    public static float energyPerRF = 1.0f;
    protected boolean m_ReceivesEnergy = true;
    protected boolean m_ProvidesEnergy = true;
    private int cycledTicks = -1;
    private EnergyStorage energyStorage = new EnergyStorage(this.getMaxEnergyStored());

    protected abstract int getMaxEnergyStored();

    public abstract int getCycleEnergyCost();

    public abstract int getCycleLength();

    public abstract boolean canBeginCycle();

    public abstract void onPoweredCycleBegin();

    public abstract void onPoweredCycleEnd();

    public int getCurrentCycleTicks() {
        return this.cycledTicks;
    }

    @Override
    public boolean isActive() {
        return this.cycledTicks >= 0;
    }

    public float getCycleCompletion() {
        if (this.cycledTicks < 0) {
            return 0.0f;
        }
        return (float)this.cycledTicks / (float)this.getCycleLength();
    }

    @Override
    protected void syncDataFrom(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            if (data.func_74764_b("energyStorage")) {
                this.energyStorage.readFromNBT(data.func_74775_l("energyStorage"));
            }
            if (data.func_74764_b("cycledTicks")) {
                this.cycledTicks = data.func_74762_e("cycledTicks");
            }
        }
    }

    @Override
    protected void syncDataTo(NBTTagCompound data, ModTileEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        if (ModTileEntity.SyncReason.FullSync == syncReason) {
            NBTTagCompound energyTag = new NBTTagCompound();
            this.energyStorage.writeToNBT(energyTag);
            data.func_74782_a("energyStorage", (NBTBase)energyTag);
            data.func_74768_a("cycledTicks", this.cycledTicks);
        }
    }

    @Override
    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.cycledTicks >= 0) {
                ++this.cycledTicks;
                if (!this.canBeginCycle()) {
                    this.cycledTicks = -1;
                    WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v(), null, null);
                } else if (this.cycledTicks >= this.getCycleLength()) {
                    this.onPoweredCycleEnd();
                    this.cycledTicks = -1;
                    WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v(), null, null);
                }
            }
            if (this.cycledTicks < 0 && this.getCycleEnergyCost() <= this.energyStorage.getEnergyStored() && this.canBeginCycle()) {
                this.energyStorage.extractEnergy(this.getCycleEnergyCost(), false);
                this.cycledTicks = 0;
                this.onPoweredCycleBegin();
                WorldHelper.notifyBlockUpdate((World)this.field_145850_b, (BlockPos)this.func_174877_v(), null, null);
            }
        }
    }

    @Override
    protected void onSendUpdate(NBTTagCompound updateTag) {
        super.onSendUpdate(updateTag);
        NBTTagCompound energyTag = new NBTTagCompound();
        this.energyStorage.writeToNBT(energyTag);
        updateTag.func_74782_a("energyStorage", (NBTBase)energyTag);
        updateTag.func_74768_a("cycledTicks", this.cycledTicks);
    }

    @Override
    public void onReceiveUpdate(NBTTagCompound updateTag) {
        super.onReceiveUpdate(updateTag);
        this.energyStorage.readFromNBT(updateTag.func_74775_l("energyStorage"));
        this.cycledTicks = updateTag.func_74762_e("cycledTicks");
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }
}

