/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiTextureProgressBar;
import net.minecraft.util.ResourceLocation;

public class BeefGuiHeatBar
extends BeefGuiTextureProgressBar
implements IBeefTooltipControl {
    private float heatMax = 2000.0f;
    private float heat = 0.0f;
    private String[] tooltip;
    private static ResourceLocation s_bgTexture;

    public BeefGuiHeatBar(BeefGuiBase container, int x, int y, String tooltipTitle, String[] tooltipExtra) {
        super(container, x, y);
        if (tooltipExtra == null) {
            this.tooltip = new String[3];
        } else {
            this.tooltip = new String[3 + tooltipExtra.length];
            for (int i = 0; i < tooltipExtra.length; ++i) {
                this.tooltip[i + 3] = tooltipExtra[i];
            }
        }
        this.tooltip[0] = tooltipTitle;
        this.tooltip[1] = "";
        this.tooltip[2] = "";
    }

    public void setHeat(float newHeat) {
        this.heat = newHeat;
        this.tooltip[1] = String.format("  %.0f C", Float.valueOf(newHeat));
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        if (null == s_bgTexture) {
            s_bgTexture = BigReactors.createGuiResourceLocation("controls/HeatBar.png");
        }
        return s_bgTexture;
    }

    @Override
    protected float getProgress() {
        return Math.min(1.0f, Math.max(0.0f, this.heat / this.heatMax));
    }

    @Override
    public String[] getTooltip() {
        return this.tooltip;
    }
}

