/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.gui.controls;

import erogenousbeef.bigreactors.client.gui.BeefGuiBase;
import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.multiblock.MultiblockTurbine;
import erogenousbeef.bigreactors.gui.IBeefTooltipControl;
import erogenousbeef.bigreactors.gui.controls.BeefGuiTextureProgressBar;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class BeefGuiRpmBar
extends BeefGuiTextureProgressBar
implements IBeefTooltipControl {
    MultiblockTurbine turbine;
    String[] tooltip = null;
    private static ResourceLocation s_bgTexture;

    public BeefGuiRpmBar(BeefGuiBase container, int x, int y, MultiblockTurbine turbine, String tooltipTitle, String[] extraTooltip) {
        super(container, x, y);
        this.turbine = turbine;
        if (extraTooltip == null || extraTooltip.length <= 0) {
            this.tooltip = new String[2];
        } else {
            this.tooltip = new String[3 + extraTooltip.length];
            this.tooltip[2] = "";
            for (int i = 0; i < extraTooltip.length; ++i) {
                this.tooltip[i + 3] = extraTooltip[i];
            }
        }
        this.tooltip[0] = TextFormatting.AQUA + tooltipTitle;
        this.tooltip[1] = "";
    }

    @Override
    protected ResourceLocation getBackgroundTexture() {
        if (null == s_bgTexture) {
            s_bgTexture = BigReactors.createGuiResourceLocation("controls/RpmBar.png");
        }
        return s_bgTexture;
    }

    @Override
    public String[] getTooltip() {
        this.tooltip[1] = this.turbine != null ? String.format("  %.0f RPM", Float.valueOf(this.turbine.getRotorSpeed())) : "  0 RPM";
        return this.tooltip;
    }

    @Override
    protected float getProgress() {
        if (this.turbine == null) {
            return 0.0f;
        }
        return Math.min(1.0f, this.turbine.getRotorSpeed() / (this.turbine.getMaxRotorSpeed() * 1.1f));
    }
}

