/*
 * Decompiled with CFR 0.152.
 */
package erogenousbeef.bigreactors.init;

import erogenousbeef.bigreactors.common.BigReactors;
import erogenousbeef.bigreactors.common.CommonProxy;
import erogenousbeef.bigreactors.common.block.BlockBR;
import erogenousbeef.bigreactors.common.block.BlockBRGenericFluid;
import erogenousbeef.bigreactors.common.item.ItemBase;
import erogenousbeef.bigreactors.init.BrBlocks;
import erogenousbeef.bigreactors.init.BrFluids;
import erogenousbeef.bigreactors.init.BrItems;
import it.zerono.mods.zerocore.lib.IGameObject;
import it.zerono.mods.zerocore.lib.IModInitializationHandler;
import it.zerono.mods.zerocore.util.OreDictionaryHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;

public final class InitHandler
implements IModInitializationHandler {
    public static final InitHandler INSTANCE = new InitHandler();
    private List<IGameObject> _objects = new ArrayList<IGameObject>();
    private CommonProxy _proxy = BigReactors.getProxy();

    public void onPreInit(FMLPreInitializationEvent event) {
        BrFluids.initialize();
        BrItems.initialize();
        BrBlocks.initialize();
    }

    public void onInit(FMLInitializationEvent event) {
        if (!OreDictionaryHelper.doesOreNameExist((String)"blockSnow")) {
            OreDictionary.registerOre((String)"blockSnow", (ItemStack)new ItemStack(Blocks.field_150433_aE, 1));
        }
        if (!OreDictionaryHelper.doesOreNameExist((String)"blockIce")) {
            OreDictionary.registerOre((String)"blockIce", (ItemStack)new ItemStack(Blocks.field_150432_aD, 1));
        }
        for (IGameObject obj : this._objects) {
            obj.registerOreDictionaryEntries();
        }
        for (IGameObject obj : this._objects) {
            obj.registerRecipes();
        }
    }

    public void onPostInit(FMLPostInitializationEvent event) {
        this._objects.clear();
        this._objects = null;
        this._proxy = null;
    }

    private InitHandler() {
    }

    protected ItemBase register(ItemBase item) {
        this._objects.add(item);
        return this._proxy.register(item);
    }

    protected BlockBR register(BlockBR block) {
        this._objects.add(block);
        return this._proxy.register(block);
    }

    protected BlockBRGenericFluid register(BlockBRGenericFluid block) {
        this._objects.add(block);
        return this._proxy.register(block);
    }

    protected void register(Class<? extends TileEntity> tileEntityClass) {
        GameRegistry.registerTileEntity(tileEntityClass, (String)("bigreactors" + tileEntityClass.getSimpleName()));
    }
}

