/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.craftingstation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingRequest;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingStationContainer;
import mcjty.rftoolscontrol.blocks.craftingstation.GuiCraftingStation;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.logic.registry.Inventory;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CraftingStationTileEntity
extends GenericTileEntity
implements DefaultSidedInventory {
    public static final String CMD_GETCRAFTABLE = "getCraftable";
    public static final String CLIENTCMD_GETCRAFTABLE = "getCraftable";
    public static final String CMD_GETREQUESTS = "getRequests";
    public static final String CLIENTCMD_GETREQUESTS = "getRequests";
    public static final String CMD_REQUEST = "request";
    public static final String CMD_CANCEL = "cancel";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, CraftingStationContainer.factory, 9);
    private List<BlockPos> processorList = new ArrayList<BlockPos>();
    private int currentTicket = 0;
    private List<CraftingRequest> activeCraftingRequests = new ArrayList<CraftingRequest>();
    private int cleanupCounter = 50;

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    public void registerProcessor(BlockPos pos) {
        if (!this.processorList.contains(pos)) {
            this.processorList.add(pos);
        }
        this.func_70296_d();
    }

    public ItemStack getCraftResult(String craftId) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!craftId.equals(request.getTicket())) continue;
            return request.getStack();
        }
        return null;
    }

    private Pair<ProcessorTileEntity, ItemStack> findCraftableItem(int index) {
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            processor.getCraftableItems(items);
            for (ItemStack item : items) {
                if (index == 0) {
                    return Pair.of((Object)((Object)processor), (Object)item);
                }
                --index;
            }
        }
        return null;
    }

    public ItemStack craftOk(ProcessorTileEntity processor, String ticket, @Nullable ItemStack stack) {
        CraftingRequest foundRequest = null;
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            foundRequest = request;
            break;
        }
        if (foundRequest != null) {
            this.func_70296_d();
            foundRequest.decrTodo();
            if (foundRequest.getTodo() <= 0) {
                foundRequest.setOk(System.currentTimeMillis() + 1000L);
            } else {
                processor.fireCraftEvent(ticket, stack);
            }
            if (stack != null) {
                Inventory inventory = this.getInventoryFromTicket(ticket);
                if (inventory != null) {
                    IItemHandler handlerAt = processor.getItemHandlerAt(inventory);
                    if (handlerAt == null) {
                        throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
                    }
                    return ItemHandlerHelper.insertItem((IItemHandler)handlerAt, (ItemStack)stack, (boolean)false);
                }
                return ItemHandlerHelper.insertItem((IItemHandler)((IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)), (ItemStack)stack, (boolean)false);
            }
        }
        return stack;
    }

    public void craftFail(String ticket) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!ticket.equals(request.getTicket())) continue;
            request.setFailed(System.currentTimeMillis() + 2000L);
            this.func_70296_d();
        }
    }

    private void cancelCraft(int index) {
        try {
            this.activeCraftingRequests.remove(index);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void startCraft(int index, int amount) {
        Pair<ProcessorTileEntity, ItemStack> pair = this.findCraftableItem(index);
        if (pair == null) {
            System.out.println("What? Can't happen");
            return;
        }
        String ticket = this.getNewTicket(null);
        ItemStack stack = (ItemStack)pair.getValue();
        int count = (amount + stack.field_77994_a - 1) / stack.field_77994_a;
        CraftingRequest request = new CraftingRequest(ticket, stack, count);
        this.activeCraftingRequests.add(request);
        ((ProcessorTileEntity)((Object)pair.getKey())).fireCraftEvent(ticket, stack);
        --this.cleanupCounter;
        if (this.cleanupCounter <= 0) {
            this.cleanupCounter = 50;
            this.cleanupStaleRequests();
        }
    }

    public boolean isRequested(ItemStack item) {
        for (CraftingRequest request : this.activeCraftingRequests) {
            if (!request.getStack().func_77969_a(item)) continue;
            return true;
        }
        return false;
    }

    public boolean request(ItemStack item, @Nullable Inventory destination) {
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            processor.getCraftableItems(items);
            for (ItemStack i : items) {
                if (!item.func_77969_a(i)) continue;
                String ticket = this.getNewTicket(destination);
                this.activeCraftingRequests.add(new CraftingRequest(ticket, i, 1));
                processor.fireCraftEvent(ticket, i);
                return true;
            }
        }
        return false;
    }

    private String getNewTicket(@Nullable Inventory destInv) {
        ++this.currentTicket;
        this.func_70296_d();
        if (destInv != null) {
            return destInv.serialize() + "#" + this.currentTicket;
        }
        return BlockPosTools.toString((BlockPos)this.field_174879_c) + ":" + this.currentTicket;
    }

    @Nullable
    private Inventory getInventoryFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return Inventory.deserialize(ticket);
        }
        return null;
    }

    @Nullable
    private BlockPos getPositionFromTicket(String ticket) {
        if (ticket.startsWith("#")) {
            return null;
        }
        String[] splitted = StringUtils.split((String)ticket, (char)';');
        String[] poss = StringUtils.split((String)splitted[0], (char)',');
        return new BlockPos(Integer.parseInt(poss[0]), Integer.parseInt(poss[1]), Integer.parseInt(poss[2]));
    }

    public List<ItemStack> getCraftableItems() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            processor.getCraftableItems(items);
        }
        return items;
    }

    private void cleanupStaleRequests() {
        long time = System.currentTimeMillis();
        List<CraftingRequest> oldRequests = this.activeCraftingRequests;
        this.activeCraftingRequests = new ArrayList<CraftingRequest>();
        for (CraftingRequest request : oldRequests) {
            long failed = request.getFailed();
            long ok = request.getOk();
            if (failed != -1L && time > failed || ok != -1L && time > ok) continue;
            this.activeCraftingRequests.add(request);
        }
    }

    public List<CraftingRequest> getRequests() {
        this.cleanupStaleRequests();
        return new ArrayList<CraftingRequest>(this.activeCraftingRequests);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.readProcessorList(tagCompound);
        this.readRequests(tagCompound);
    }

    private void readRequests(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.func_150295_c("requests", 10);
        this.activeCraftingRequests.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound requestTag = list.func_150305_b(i);
            String craftId = requestTag.func_74779_i("craftId");
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)requestTag.func_74775_l("stack"));
            int count = requestTag.func_74762_e("count");
            CraftingRequest request = new CraftingRequest(craftId, stack, count);
            request.setFailed(requestTag.func_74763_f("failed"));
            request.setOk(requestTag.func_74763_f("ok"));
            this.activeCraftingRequests.add(request);
        }
    }

    private void readProcessorList(NBTTagCompound tagCompound) {
        NBTTagList list = tagCompound.func_150295_c("processors", 10);
        this.processorList.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            this.processorList.add(new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z")));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        this.writeProcessorList(tagCompound);
        this.writeRequests(tagCompound);
        return tagCompound;
    }

    private void writeRequests(NBTTagCompound tagCompound) {
        NBTTagList list = new NBTTagList();
        for (CraftingRequest request : this.activeCraftingRequests) {
            NBTTagCompound requestTag = new NBTTagCompound();
            requestTag.func_74778_a("craftId", request.getTicket());
            NBTTagCompound stackNbt = new NBTTagCompound();
            request.getStack().func_77955_b(stackNbt);
            requestTag.func_74782_a("stack", (NBTBase)stackNbt);
            requestTag.func_74768_a("count", request.getTodo());
            requestTag.func_74772_a("failed", request.getFailed());
            requestTag.func_74772_a("ok", request.getOk());
            list.func_74742_a((NBTBase)requestTag);
        }
        tagCompound.func_74782_a("requests", (NBTBase)list);
    }

    private void writeProcessorList(NBTTagCompound tagCompound) {
        NBTTagList list = new NBTTagList();
        for (BlockPos p : this.processorList) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("x", p.func_177958_n());
            tag.func_74768_a("y", p.func_177956_o());
            tag.func_74768_a("z", p.func_177952_p());
            list.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("processors", (NBTBase)list);
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.currentTicket = tagCompound.func_74762_e("craftId");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        tagCompound.func_74768_a("craftId", this.currentTicket);
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    private int findItem(String itemName) {
        int index = 0;
        for (BlockPos p : this.processorList) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof ProcessorTileEntity)) continue;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            processor.getCraftableItems(items);
            for (ItemStack item : items) {
                if (itemName.equals(item.func_77973_b().getRegistryName().toString())) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_REQUEST.equals(command)) {
            String itemName = args.get("item").getString();
            int index = this.findItem(itemName);
            if (index == -1) {
                return true;
            }
            int amount = args.get("amount").getInteger();
            this.startCraft(index, amount);
            return true;
        }
        if (CMD_CANCEL.equals(command)) {
            int index = args.get("index").getInteger();
            this.cancelCraft(index);
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getCraftable".equals(command)) {
            return this.getCraftableItems();
        }
        if ("getRequests".equals(command)) {
            return this.getRequests();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getCraftable".equals(command)) {
            GuiCraftingStation.storeCraftableForClient(list);
            return true;
        }
        if ("getRequests".equals(command)) {
            GuiCraftingStation.storeRequestsForClient(list);
            return true;
        }
        return false;
    }
}

