/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.node;

import java.util.Map;
import mcjty.lib.entity.GenericTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;

public class NodeTileEntity
extends GenericTileEntity {
    public static final String CMD_UPDATE = "update";
    private String channel;
    private String node;
    private BlockPos processor = null;
    private int prevIn = 0;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};

    public String getNodeName() {
        return this.node;
    }

    public String getChannelName() {
        return this.channel;
    }

    public BlockPos getProcessor() {
        return this.processor;
    }

    public void setProcessor(BlockPos processor) {
        this.processor = processor;
        this.func_70296_d();
    }

    public void setPowerInput(int powered) {
        if (this.powerLevel != powered) {
            TileEntity te;
            if (this.processor != null && (te = this.field_145850_b.func_175625_s(this.processor)) instanceof ProcessorTileEntity) {
                ProcessorTileEntity processorTileEntity = (ProcessorTileEntity)te;
                processorTileEntity.redstoneNodeChange(this.prevIn, powered, this.node);
            }
            this.prevIn = powered;
        }
        super.setPowerInput(powered);
    }

    public int getPowerOut(EnumFacing side) {
        return this.powerOut[side.ordinal()];
    }

    public void setPowerOut(EnumFacing side, int powerOut) {
        this.powerOut[side.ordinal()] = powerOut;
        this.func_70296_d();
        this.field_145850_b.func_180496_d(this.field_174879_c.func_177972_a(side), this.func_145838_q());
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74762_e("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.channel = tagCompound.func_74779_i("channel");
        this.node = tagCompound.func_74779_i("node");
        this.processor = BlockPosTools.readFromNBT((NBTTagCompound)tagCompound, (String)"processor");
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        if (this.channel != null) {
            tagCompound.func_74778_a("channel", this.channel);
        }
        if (this.node != null) {
            tagCompound.func_74778_a("node", this.node);
        }
        if (this.processor != null) {
            BlockPosTools.writeToNBT((NBTTagCompound)tagCompound, (String)"processor", (BlockPos)this.processor);
        }
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_UPDATE.equals(command)) {
            this.node = args.get("node").getString();
            this.channel = args.get("channel").getString();
            this.markDirtyClient();
            return true;
        }
        return false;
    }
}

