/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.processor;

import mcjty.rftoolscontrol.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import net.minecraft.nbt.NBTTagCompound;

public class CardInfo {
    private int itemAllocation;
    private int varAllocation;
    private CompiledCard compiledCard;
    private int[] slotCache = null;
    private int[] varCache = null;

    public int getItemAllocation() {
        return this.itemAllocation;
    }

    public void setItemAllocation(int itemAllocation) {
        this.itemAllocation = itemAllocation;
        this.slotCache = null;
    }

    public int getVarAllocation() {
        return this.varAllocation;
    }

    public void setVarAllocation(int varAllocation) {
        this.varAllocation = varAllocation;
        this.varCache = null;
    }

    public void setCompiledCard(CompiledCard compiledCard) {
        this.compiledCard = compiledCard;
    }

    public CompiledCard getCompiledCard() {
        return this.compiledCard;
    }

    public Integer getRealSlot(Integer virtualSlot) {
        if (virtualSlot == null) {
            return null;
        }
        return this.getRealSlot((int)virtualSlot);
    }

    public int getRealSlot(int virtualSlot) {
        if (this.slotCache == null) {
            this.slotCache = new int[24];
            int idx = 0;
            for (int i = 0; i < 24; ++i) {
                if ((this.itemAllocation >> i & 1) != 1) continue;
                this.slotCache[idx] = i;
                ++idx;
            }
            while (idx < 24) {
                this.slotCache[idx] = -1;
                ++idx;
            }
        }
        if (virtualSlot < 0 && virtualSlot >= 24) {
            throw new ProgException(ExceptionType.EXCEPT_NOINTERNALSLOT);
        }
        int realSlot = this.slotCache[virtualSlot];
        if (realSlot == -1) {
            throw new ProgException(ExceptionType.EXCEPT_NOINTERNALSLOT);
        }
        return realSlot + 22;
    }

    public int getRealVar(int virtualVar) {
        if (this.varCache == null) {
            this.varCache = new int[32];
            int idx = 0;
            for (int i = 0; i < 32; ++i) {
                if ((this.varAllocation >> i & 1) != 1) continue;
                this.varCache[idx] = i;
                ++idx;
            }
            while (idx < 32) {
                this.varCache[idx] = -1;
                ++idx;
            }
        }
        if (virtualVar < 0 && virtualVar >= 32) {
            return -1;
        }
        return this.varCache[virtualVar];
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("itemAlloc", this.itemAllocation);
        tag.func_74768_a("varAlloc", this.varAllocation);
        return tag;
    }

    public static CardInfo readFromNBT(NBTTagCompound tag) {
        CardInfo cardInfo = new CardInfo();
        cardInfo.itemAllocation = tag.func_74762_e("itemAlloc");
        cardInfo.varAllocation = tag.func_74762_e("varAlloc");
        cardInfo.slotCache = null;
        cardInfo.varCache = null;
        return cardInfo;
    }
}

