/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.processor;

import java.util.List;
import mcjty.lib.container.GenericGuiContainer;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.GenericRFToolsBlock;
import mcjty.rftoolscontrol.blocks.processor.GuiProcessor;
import mcjty.rftoolscontrol.blocks.processor.ProcessorContainer;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.ProbeMode;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ProcessorBlock
extends GenericRFToolsBlock<ProcessorTileEntity, ProcessorContainer> {
    public static final PropertyBool WORKING = PropertyBool.func_177716_a((String)"working");

    public boolean needsRedstoneCheck() {
        return true;
    }

    public ProcessorBlock() {
        super(Material.field_151573_f, ProcessorTileEntity.class, ProcessorContainer.class, "processor", false);
    }

    @SideOnly(value=Side.CLIENT)
    public Class<? extends GenericGuiContainer> getGuiClass() {
        return GuiProcessor.class;
    }

    public int getGuiID() {
        return RFToolsControl.GUI_PROCESSOR;
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, EntityPlayer playerIn, List<String> list, boolean advanced) {
        super.addInformation(stack, playerIn, list, advanced);
        list.add("The processor executes programs");
        list.add("for automation");
    }

    public void addProbeInfo(ProbeMode mode, IProbeInfo probeInfo, EntityPlayer player, World world, IBlockState blockState, IProbeHitData data) {
        super.addProbeInfo(mode, probeInfo, player, world, blockState, data);
        TileEntity te = world.func_175625_s(data.getPos());
        if (te instanceof ProcessorTileEntity) {
            List<String> lastMessages;
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            if (processor.hasNetworkCard()) {
                probeInfo.text(TextFormatting.GREEN + "Channel: " + processor.getChannelName());
                probeInfo.text(TextFormatting.GREEN + "Nodes: " + processor.getNodeCount());
            }
            if (mode == ProbeMode.EXTENDED && !(lastMessages = processor.getLastMessages(6)).isEmpty()) {
                IProbeInfo v = probeInfo.vertical(probeInfo.defaultLayoutStyle().borderColor(Integer.valueOf(-65536)));
                for (String s : lastMessages) {
                    v.text("    " + s);
                }
            }
        }
    }

    private int getInputStrength(World world, BlockPos pos, EnumFacing side) {
        return world.func_175651_c(pos.func_177972_a(side), side);
    }

    protected void checkRedstone(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ProcessorBlock && te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            int powered = 0;
            if (this.getInputStrength(world, pos, EnumFacing.DOWN) > 0) {
                ++powered;
            }
            if (this.getInputStrength(world, pos, EnumFacing.UP) > 0) {
                powered += 2;
            }
            if (this.getInputStrength(world, pos, EnumFacing.NORTH) > 0) {
                powered += 4;
            }
            if (this.getInputStrength(world, pos, EnumFacing.SOUTH) > 0) {
                powered += 8;
            }
            if (this.getInputStrength(world, pos, EnumFacing.WEST) > 0) {
                powered += 16;
            }
            if (this.getInputStrength(world, pos, EnumFacing.EAST) > 0) {
                powered += 32;
            }
            processor.setPowerInput(powered);
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    protected int getRedstoneOutput(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ProcessorBlock && te instanceof ProcessorTileEntity) {
            ProcessorTileEntity processor = (ProcessorTileEntity)te;
            return processor.getPowerOut(side.func_176734_d());
        }
        return 0;
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        boolean working = false;
        if (te instanceof ProcessorTileEntity) {
            working = ((ProcessorTileEntity)te).isWorking();
        }
        return state.func_177226_a((IProperty)WORKING, (Comparable)Boolean.valueOf(working));
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, WORKING});
    }
}

