/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.processor;

import cofh.api.energy.IEnergyHandler;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.container.DefaultSidedInventory;
import mcjty.lib.container.InventoryHelper;
import mcjty.lib.entity.GenericEnergyReceiverTileEntity;
import mcjty.lib.network.Argument;
import mcjty.lib.varia.BlockPosTools;
import mcjty.lib.varia.WorldTools;
import mcjty.rftools.api.storage.IStorageScanner;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingStationTileEntity;
import mcjty.rftoolscontrol.blocks.node.NodeTileEntity;
import mcjty.rftoolscontrol.blocks.processor.CardInfo;
import mcjty.rftoolscontrol.blocks.processor.Commands;
import mcjty.rftoolscontrol.blocks.processor.GuiProcessor;
import mcjty.rftoolscontrol.blocks.processor.ProcessorContainer;
import mcjty.rftoolscontrol.blocks.processor.QueuedEvent;
import mcjty.rftoolscontrol.blocks.processor.WaitForItem;
import mcjty.rftoolscontrol.config.GeneralConfiguration;
import mcjty.rftoolscontrol.items.CPUCoreItem;
import mcjty.rftoolscontrol.items.ModItems;
import mcjty.rftoolscontrol.items.craftingcard.CraftingCardItem;
import mcjty.rftoolscontrol.logic.InventoryTools;
import mcjty.rftoolscontrol.logic.Parameter;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.logic.registry.BlockSide;
import mcjty.rftoolscontrol.logic.registry.Inventory;
import mcjty.rftoolscontrol.logic.registry.OpcodeRunnable;
import mcjty.rftoolscontrol.logic.registry.Opcodes;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import mcjty.rftoolscontrol.logic.running.CpuCore;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import mcjty.rftoolscontrol.logic.running.RunningProgram;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.commons.lang3.tuple.Pair;

public class ProcessorTileEntity
extends GenericEnergyReceiverTileEntity
implements DefaultSidedInventory,
ITickable {
    public static final int CARD_SLOTS = 6;
    public static final int ITEM_SLOTS = 24;
    public static final int EXPANSION_SLOTS = 16;
    public static final int MAXVARS = 32;
    public static final String CMD_ALLOCATE = "allocate";
    public static final String CMD_CLEARLOG = "clearLog";
    public static final String CMD_GETLOG = "getLog";
    public static final String CLIENTCMD_GETLOG = "getLog";
    public static final String CMD_GETVARS = "getVars";
    public static final String CLIENTCMD_GETVARS = "getVars";
    private InventoryHelper inventoryHelper = new InventoryHelper((TileEntity)this, ProcessorContainer.factory, 46);
    private boolean working = false;
    private List<CpuCore> cpuCores = new ArrayList<CpuCore>();
    private boolean cardsDirty = true;
    private boolean coresDirty = true;
    private int maxVars = -1;
    private boolean hasNetworkCard = false;
    private int storageCard = -2;
    private String channel = "";
    private Map<String, BlockPos> networkNodes = new HashMap<String, BlockPos>();
    private Set<BlockPos> craftingStations = new HashSet<BlockPos>();
    private int prevIn = 0;
    private int[] powerOut = new int[]{0, 0, 0, 0, 0, 0};
    private int tickCount = 0;
    private Parameter[] variables = new Parameter[32];
    private CardInfo[] cardInfo = new CardInfo[6];
    private Queue<QueuedEvent> eventQueue = new ArrayDeque<QueuedEvent>();
    private List<WaitForItem> waitingForItems = new ArrayList<WaitForItem>();
    private Queue<String> logMessages = new ArrayDeque<String>();
    private Set<Pair<Integer, Integer>> runningEvents = new HashSet<Pair<Integer, Integer>>();
    private Set<String> locks = new HashSet<String>();

    public ProcessorTileEntity() {
        super(GeneralConfiguration.processorMaxenergy, GeneralConfiguration.processorReceivepertick);
        int i;
        for (i = 0; i < this.cardInfo.length; ++i) {
            this.cardInfo[i] = new CardInfo();
        }
        for (i = 0; i < 32; ++i) {
            this.variables[i] = null;
        }
    }

    public InventoryHelper getInventoryHelper() {
        return this.inventoryHelper;
    }

    public Parameter getParameter(int idx) {
        return this.variables[idx];
    }

    protected boolean needsCustomInvWrapper() {
        return true;
    }

    private BlockPos getAdjacentPosition(@Nonnull BlockSide side, @Nonnull RunningProgram program) {
        BlockPos p;
        if (side.getNodeName() != null && !side.getNodeName().isEmpty()) {
            p = this.networkNodes.get(side.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof NodeTileEntity)) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        } else {
            p = this.field_174879_c;
        }
        return p;
    }

    public int readRedstoneIn(@Nonnull BlockSide side, @Nonnull RunningProgram program) {
        EnumFacing facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side, program);
        if (p == null) {
            return 0;
        }
        return this.field_145850_b.func_175651_c(p.func_177972_a(facing), facing);
    }

    public void setPowerOut(@Nonnull BlockSide side, int level, RunningProgram program) {
        EnumFacing facing = side.getSide();
        BlockPos p = this.getAdjacentPosition(side, program);
        if (p == null) {
            return;
        }
        if (p.equals((Object)this.field_174879_c)) {
            this.powerOut[facing.ordinal()] = level;
            this.func_70296_d();
            this.field_145850_b.func_180496_d(this.field_174879_c.func_177972_a(facing), this.func_145838_q());
        } else {
            NodeTileEntity te = (NodeTileEntity)this.field_145850_b.func_175625_s(p);
            te.setPowerOut(facing, level);
        }
    }

    public int getPowerOut(EnumFacing side) {
        return this.powerOut[side.ordinal()];
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.canPlayerAccess(player);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            boolean old = this.working;
            this.working = true;
            if (this.working != old) {
                this.markDirtyClient();
            }
            if (this.working) {
                this.process();
            }
            this.prevIn = this.powerLevel;
        }
    }

    private void process() {
        ++this.tickCount;
        this.func_70296_d();
        this.updateCores();
        this.compileCards();
        this.processEventQueue();
        this.handleEvents();
        this.run();
    }

    private void processEventQueue() {
        QueuedEvent queuedEvent = this.eventQueue.peek();
        if (queuedEvent != null) {
            CompiledEvent compiledEvent = queuedEvent.getCompiledEvent();
            if (compiledEvent.isSingle() && this.runningEvents.contains(Pair.of((Object)queuedEvent.getCardIndex(), (Object)compiledEvent.getIndex()))) {
                return;
            }
            CpuCore core = this.findAvailableCore();
            if (core != null) {
                this.eventQueue.remove();
                RunningProgram program = new RunningProgram(queuedEvent.getCardIndex());
                program.startFromEvent(compiledEvent);
                program.setCraftTicket(queuedEvent.getTicket());
                core.startProgram(program);
            }
        }
    }

    public void getCraftableItems(List<ItemStack> stacks) {
        try {
            for (CardInfo info : this.cardInfo) {
                CompiledCard compiledCard = info.getCompiledCard();
                if (compiledCard == null) continue;
                for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                    int index = event.getIndex();
                    CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                    ItemStack stack = (ItemStack)this.evaluateParameter(compiledOpcode, null, 0);
                    Inventory inv = (Inventory)this.evaluateParameter(compiledOpcode, null, 1);
                    if (stack != null && inv != null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (stack == null && inv == null) {
                        throw new ProgException(ExceptionType.EXCEPT_BADPARAMETERS);
                    }
                    if (stack != null) {
                        stacks.add(stack);
                        continue;
                    }
                    IItemHandler handler = this.getItemHandlerAt(inv);
                    for (int i = 0; i < handler.getSlots(); ++i) {
                        ItemStack result;
                        ItemStack s = handler.getStackInSlot(i);
                        if (s == null || s.func_77973_b() != ModItems.craftingCardItem || (result = CraftingCardItem.getResult(s)) == null) continue;
                        stacks.add(result);
                    }
                }
            }
        }
        catch (ProgException e) {
            this.exception(e.getExceptionType(), null);
        }
    }

    public void craftOk(RunningProgram program, @Nullable Integer slot) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        CardInfo info = this.cardInfo[program.getCardIndex()];
        Integer realSlot = info.getRealSlot(slot);
        ItemStack craftedItem = null;
        if (realSlot != null) {
            craftedItem = this.getItemHandler().getStackInSlot(realSlot.intValue());
        }
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftedItem = craftingStation.craftOk(this, ticket, craftedItem);
        }
        if (realSlot != null) {
            this.getInventoryHelper().setStackInSlot(realSlot.intValue(), craftedItem);
        }
    }

    public void craftFail(RunningProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        String ticket = program.getCraftTicket();
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            craftingStation.craftFail(ticket);
        }
    }

    public int pushItemsMulti(RunningProgram program, Inventory inv, int slot1, int slot2, @Nullable Integer extSlot) {
        IItemHandler handler = this.getItemHandlerAt(inv);
        IStorageScanner scanner = this.getScannerForInv(inv);
        CardInfo info = this.cardInfo[program.getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        int e = 0;
        if (extSlot != null) {
            e = extSlot;
        }
        int failed = 0;
        for (int slot = slot1; slot <= slot2; ++slot) {
            int realSlot = info.getRealSlot(slot);
            ItemStack stack = itemHandler.getStackInSlot(realSlot);
            if (stack != null) {
                ItemStack remaining = InventoryTools.insertItem(handler, scanner, stack, extSlot == null ? null : Integer.valueOf(e));
                if (remaining != null) {
                    ++failed;
                }
                this.inventoryHelper.setStackInSlot(realSlot, remaining);
            }
            ++e;
        }
        return failed;
    }

    public boolean checkIngredients(RunningProgram program, Inventory cardInv, @Nullable ItemStack item, int slot1, int slot2) {
        if (item == null) {
            item = this.getCraftResult(program);
        }
        if (item == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(cardInv);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[program.getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        int slot = slot1;
        List<ItemStack> ingredients = CraftingCardItem.fitsGrid(card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid(card) : CraftingCardItem.getIngredients(card);
        boolean failed = false;
        for (ItemStack ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            ItemStack localStack = itemHandler.getStackInSlot(realSlot);
            if (ingredient != null) {
                if (!ingredient.func_77969_a(localStack)) {
                    return false;
                }
                if (ingredient.field_77994_a != localStack.field_77994_a) {
                    return false;
                }
            } else if (localStack != null) {
                return false;
            }
            ++slot;
        }
        return true;
    }

    public int getIngredientsSmart(RunningProgram program, Inventory inv, Inventory cardInv, @Nullable ItemStack item, int slot1, int slot2, Inventory destInv) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        if (item == null) {
            item = this.getCraftResult(program);
        }
        if (item == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        IItemHandler destHandler = this.getHandlerForInv(destInv);
        if (destHandler == null) {
            throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(cardInv);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[program.getCardIndex()];
        List<ItemStack> ingredients = CraftingCardItem.fitsGrid(card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid(card) : CraftingCardItem.getIngredients(card);
        List<ItemStack> needed = this.combineIngredients(ingredients);
        int requested = this.checkAvailableItemsAndRequestMissing(destInv, scanner, handler, needed);
        if (requested != 0) {
            return requested;
        }
        IItemHandler itemHandler = this.getItemHandler();
        int slot = slot1;
        for (ItemStack ingredient : ingredients) {
            ItemStack stack;
            int realSlot = info.getRealSlot(slot);
            if (ingredient != null && (stack = InventoryTools.extractItem(handler, scanner, ingredient.field_77994_a, true, false, ingredient, null)) != null) {
                itemHandler.insertItem(realSlot, stack, false);
            }
            ++slot;
        }
        return 0;
    }

    private int checkAvailableItemsAndRequestMissing(Inventory destInv, IStorageScanner scanner, IItemHandler handler, List<ItemStack> needed) {
        int requested = 0;
        for (ItemStack ingredient : needed) {
            int cnt;
            if (ingredient == null || (cnt = InventoryTools.countItem(handler, scanner, ingredient, false, ingredient.field_77994_a)) >= ingredient.field_77994_a) continue;
            ++requested;
            ItemStack requestedItem = ingredient.func_77946_l();
            requestedItem.field_77994_a = ingredient.field_77994_a - cnt;
            if (this.isRequested(requestedItem) || this.requestCraft(requestedItem, destInv)) continue;
            return -1;
        }
        return requested;
    }

    private List<ItemStack> combineIngredients(List<ItemStack> ingredients) {
        ArrayList<ItemStack> needed = new ArrayList<ItemStack>();
        for (ItemStack ingredient : ingredients) {
            if (ingredient == null) continue;
            boolean found = false;
            for (ItemStack neededStack : needed) {
                if (!neededStack.func_77969_a(ingredient)) continue;
                neededStack.field_77994_a += ingredient.field_77994_a;
                found = true;
                break;
            }
            if (found) continue;
            needed.add(ingredient.func_77946_l());
        }
        return needed;
    }

    public int getIngredients(RunningProgram program, Inventory inv, Inventory cardInv, @Nullable ItemStack item, int slot1, int slot2) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        if (item == null) {
            item = this.getCraftResult(program);
        }
        if (item == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        IItemHandler cardHandler = this.getItemHandlerAt(cardInv);
        ItemStack card = this.findCraftingCard(cardHandler, item);
        if (card == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGCARD);
        }
        CardInfo info = this.cardInfo[program.getCardIndex()];
        IItemHandler itemHandler = this.getItemHandler();
        int slot = slot1;
        List<ItemStack> ingredients = CraftingCardItem.fitsGrid(card) && slot2 - slot1 >= 8 ? CraftingCardItem.getIngredientsGrid(card) : CraftingCardItem.getIngredients(card);
        int failed = 0;
        for (ItemStack ingredient : ingredients) {
            int realSlot = info.getRealSlot(slot);
            if (ingredient != null) {
                ItemStack stack = InventoryTools.extractItem(handler, scanner, ingredient.field_77994_a, true, false, ingredient, null);
                if (stack != null) {
                    ItemStack remainder = itemHandler.insertItem(realSlot, stack, false);
                    if (remainder != null) {
                        InventoryTools.insertItem(handler, scanner, remainder, null);
                    }
                } else {
                    ++failed;
                }
            }
            ++slot;
        }
        return failed;
    }

    private IItemHandler getItemHandler() {
        return (IItemHandler)this.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public void craftWait(RunningProgram program, Inventory inv, ItemStack stack) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        if (stack == null && (stack = this.getCraftResult(program)) == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTRESULT);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), stack, inv);
        this.waitingForItems.add(waitForItem);
        this.func_70296_d();
    }

    public void craftWaitTimed(RunningProgram program) {
        if (!program.hasCraftTicket()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTTICKET);
        }
        WaitForItem waitForItem = new WaitForItem(program.getCraftTicket(), null, null);
        this.waitingForItems.add(waitForItem);
        this.func_70296_d();
    }

    public boolean isRequested(ItemStack stack) {
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.isRequested(stack);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public boolean requestCraft(ItemStack stack, @Nullable Inventory inventory) {
        for (BlockPos p : this.craftingStations) {
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity)) continue;
            CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
            return craftingStation.request(stack, inventory);
        }
        throw new ProgException(ExceptionType.EXCEPT_MISSINGCRAFTINGSTATION);
    }

    public void setCraftTicket(RunningProgram program, String ticket) {
        program.setCraftTicket(ticket);
    }

    public ItemStack getCraftResult(RunningProgram program) {
        if (!program.hasCraftTicket()) {
            return null;
        }
        for (BlockPos p : this.craftingStations) {
            CraftingStationTileEntity craftingStation;
            ItemStack stack;
            TileEntity te = this.field_145850_b.func_175625_s(p);
            if (!(te instanceof CraftingStationTileEntity) || (stack = (craftingStation = (CraftingStationTileEntity)te).getCraftResult(program.getCraftTicket())) == null) continue;
            return stack;
        }
        return null;
    }

    private ItemStack findCraftingCard(IItemHandler handler, ItemStack craftResult) {
        for (int j = 0; j < handler.getSlots(); ++j) {
            ItemStack result;
            ItemStack s = handler.getStackInSlot(j);
            if (s == null || s.func_77973_b() != ModItems.craftingCardItem || (result = CraftingCardItem.getResult(s)) == null || !result.func_77969_a(craftResult)) continue;
            return s;
        }
        return null;
    }

    public void fireCraftEvent(String ticket, ItemStack stackToCraft) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFT)) {
                IItemHandler handler;
                ItemStack craftingCard;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                ItemStack stack = (ItemStack)this.evaluateParameter(compiledOpcode, null, 0);
                Inventory inv = (Inventory)this.evaluateParameter(compiledOpcode, null, 1);
                if (stack != null) {
                    if (!stack.func_77969_a(stackToCraft)) continue;
                    this.runOrQueueEvent(i, event, ticket);
                    return;
                }
                if (inv == null || (craftingCard = this.findCraftingCard(handler = this.getItemHandlerAt(inv), stackToCraft)) == null) continue;
                this.runOrQueueEvent(i, event, ticket);
                return;
            }
        }
    }

    private void handleEvents() {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard);
            this.handleEventsRedstoneOff(i, compiledCard);
            this.handleEventsTimer(i, compiledCard);
            this.handleEventsCraftResume(i, compiledCard);
        }
    }

    private void handleEventsCraftResume(int cardIndex, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_CRAFTRESUME)) {
            int index = event.getIndex();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = (Integer)this.evaluateParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0 || this.waitingForItems.isEmpty()) continue;
            WaitForItem found = null;
            int foundIdx = -1;
            for (int i = 0; i < this.waitingForItems.size(); ++i) {
                WaitForItem wfi = this.waitingForItems.get(i);
                if (wfi.getInventory() == null || wfi.getItemStack() == null) {
                    foundIdx = i;
                    found = wfi;
                    break;
                }
                IItemHandler handler = this.getItemHandlerAt(wfi.getInventory());
                int cnt = this.countItemInHandler(wfi.getItemStack(), handler);
                if (cnt < wfi.getItemStack().field_77994_a) continue;
                foundIdx = i;
                found = wfi;
                break;
            }
            if (found == null) continue;
            this.waitingForItems.remove(foundIdx);
            this.runOrQueueEvent(cardIndex, event, found.getTicket());
        }
    }

    private void handleEventsTimer(int i, CompiledCard compiledCard) {
        for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_TIMER)) {
            int index = event.getIndex();
            CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
            int ticks = (Integer)this.evaluateParameter(compiledOpcode, null, 0);
            if (ticks <= 0 || this.tickCount % ticks != 0) continue;
            this.runOrDropEvent(i, event, null);
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard) {
        int redstoneOffMask = this.prevIn & ~this.powerLevel;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = (BlockSide)this.evaluateParameter(compiledOpcode, null, 0);
                if (side.hasNodeName()) continue;
                EnumFacing enumFacing = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard) {
        int redstoneOnMask = this.powerLevel & ~this.prevIn;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = (BlockSide)this.evaluateParameter(compiledOpcode, null, 0);
                if (side.hasNodeName()) continue;
                EnumFacing enumFacing = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null);
            }
        }
    }

    private void handleEventsRedstoneOff(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOffMask = prevMask & ~newMask;
        if (redstoneOffMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_OFF)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = (BlockSide)this.evaluateParameter(compiledOpcode, null, 0);
                if (!node.equals(side.getNodeName())) continue;
                EnumFacing enumFacing = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOffMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null);
            }
        }
    }

    private void handleEventsRedstoneOn(int i, CompiledCard compiledCard, String node, int prevMask, int newMask) {
        int redstoneOnMask = newMask & ~prevMask;
        if (redstoneOnMask != 0) {
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_REDSTONE_ON)) {
                EnumFacing facing;
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                BlockSide side = (BlockSide)this.evaluateParameter(compiledOpcode, null, 0);
                if (!node.equals(side.getNodeName())) continue;
                EnumFacing enumFacing = facing = side == null ? null : side.getSide();
                if (facing != null && (redstoneOnMask >> facing.ordinal() & 1) != 1) continue;
                this.runOrQueueEvent(i, event, null);
            }
        }
    }

    public void clearRunningEvent(int cardIndex, int eventIndex) {
        this.runningEvents.remove(Pair.of((Object)cardIndex, (Object)eventIndex));
    }

    private void runOrDropEvent(int cardIndex, CompiledEvent event, @Nullable String ticket) {
        if (event.isSingle() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.getIndex()))) {
            return;
        }
        CpuCore core = this.findAvailableCore();
        if (core != null) {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            core.startProgram(program);
            if (event.isSingle()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.getIndex()));
            }
        }
    }

    private void runOrQueueEvent(int cardIndex, CompiledEvent event, @Nullable String ticket) {
        if (event.isSingle() && this.runningEvents.contains(Pair.of((Object)cardIndex, (Object)event.getIndex()))) {
            this.eventQueue.add(new QueuedEvent(cardIndex, event, ticket));
            return;
        }
        CpuCore core = this.findAvailableCore();
        if (core == null) {
            this.eventQueue.add(new QueuedEvent(cardIndex, event, ticket));
        } else {
            RunningProgram program = new RunningProgram(cardIndex);
            program.startFromEvent(event);
            program.setCraftTicket(ticket);
            core.startProgram(program);
            if (event.isSingle()) {
                this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)event.getIndex()));
            }
        }
    }

    public int signal(String signal) {
        int cnt = 0;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_SIGNAL)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String sig = (String)this.evaluateParameter(compiledOpcode, null, 0);
                if (!signal.equals(sig)) continue;
                this.runOrQueueEvent(i, event, null);
                ++cnt;
            }
        }
        return cnt;
    }

    public void listStatus() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            if (core.hasProgram()) {
                RunningProgram program = core.getProgram();
                if (program.getDelay() > 0) {
                    this.log("Core: " + n + " -> <delayed: " + program.getDelay() + ">");
                } else if (program.getLock() != null) {
                    this.log("Core: " + n + " -> <locked: " + program.getLock() + ">");
                } else {
                    this.log("Core: " + n + " -> <busy>");
                }
            } else {
                this.log("Core: " + n + " -> <idle>");
            }
            ++n;
        }
        this.log("Event queue: " + this.eventQueue.size());
        this.log("Waiting items: " + this.waitingForItems.size());
        this.log("Locks: " + this.locks.size());
    }

    public int stopPrograms() {
        int n = 0;
        for (CpuCore core : this.getCpuCores()) {
            if (!core.hasProgram()) continue;
            ++n;
            core.stopProgram();
        }
        this.locks.clear();
        this.runningEvents.clear();
        return n;
    }

    public void reset() {
        this.waitingForItems.clear();
        this.eventQueue.clear();
        this.stopPrograms();
        this.func_70296_d();
    }

    public OpcodeRunnable.OpcodeResult placeLock(RunningProgram program, String name) {
        if (this.testLock(program, name)) {
            return OpcodeRunnable.OpcodeResult.HOLD;
        }
        this.locks.add(name);
        return OpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void releaseLock(RunningProgram program, String name) {
        this.locks.remove(name);
    }

    public boolean testLock(RunningProgram program, String name) {
        return this.locks.contains(name);
    }

    public void clearLog() {
        this.logMessages.clear();
    }

    public void exception(ExceptionType exception, RunningProgram program) {
        String message;
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            for (CompiledEvent event : compiledCard.getEvents(Opcodes.EVENT_EXCEPTION)) {
                int index = event.getIndex();
                CompiledOpcode compiledOpcode = compiledCard.getOpcodes().get(index);
                String code = this.evaluateStringParameter(compiledOpcode, null, 0);
                if (!exception.getCode().equals(code)) continue;
                this.runOrQueueEvent(i, event, program.getCraftTicket());
                return;
            }
        }
        if (program != null) {
            CompiledCard card = this.getCompiledCard(program.getCardIndex());
            if (card == null) {
                message = TextFormatting.RED + "INTERNAL: " + exception.getDescription();
            } else {
                CompiledOpcode opcode = program.getCurrentOpcode(this);
                int gridX = opcode.getGridX();
                int gridY = opcode.getGridY();
                message = TextFormatting.RED + "[" + gridX + "," + gridY + "] " + exception.getDescription();
            }
        } else {
            message = TextFormatting.RED + exception.getDescription();
        }
        this.log(message);
    }

    public void log(String message) {
        if (message == null) {
            return;
        }
        this.logMessages.add(message);
        while (this.logMessages.size() > GeneralConfiguration.processorMaxloglines) {
            this.logMessages.remove();
        }
    }

    private List<String> getLog() {
        return this.logMessages.stream().collect(Collectors.toList());
    }

    public List<String> getLastMessages(int n) {
        ArrayList<String> rc = new ArrayList<String>();
        int i = 0;
        for (String s : this.logMessages) {
            if (i >= this.logMessages.size() - n) {
                rc.add(s);
            }
            ++i;
        }
        return rc;
    }

    public Parameter[] getVariableArray() {
        return this.variables;
    }

    public List<Parameter> getVariables() {
        ArrayList<Parameter> pars = new ArrayList<Parameter>();
        Collections.addAll(pars, this.variables);
        return pars;
    }

    public List<CpuCore> getCpuCores() {
        return this.cpuCores;
    }

    private CpuCore findAvailableCore() {
        for (CpuCore core : this.cpuCores) {
            if (core.hasProgram()) continue;
            return core;
        }
        return null;
    }

    private void run() {
        int rf = this.getEnergyStored(EnumFacing.DOWN);
        for (CpuCore core : this.cpuCores) {
            int rft;
            if (!core.hasProgram() || (rft = GeneralConfiguration.coreRFPerTick[core.getTier()]) >= rf) continue;
            core.run(this);
            this.consumeEnergy(rft);
            rf -= rft;
        }
    }

    private void updateCores() {
        if (this.coresDirty) {
            this.coresDirty = false;
            this.cpuCores.clear();
            for (int i = 0; i < 16; ++i) {
                ItemStack expansionStack = this.inventoryHelper.getStackInSlot(i);
                if (expansionStack == null || !(expansionStack.func_77973_b() instanceof CPUCoreItem)) continue;
                CPUCoreItem coreItem = (CPUCoreItem)expansionStack.func_77973_b();
                CpuCore core = new CpuCore();
                core.setTier(coreItem.getTier());
                this.cpuCores.add(core);
            }
        }
    }

    private void compileCards() {
        if (this.cardsDirty) {
            this.cardsDirty = false;
            for (int i = 16; i < 22; ++i) {
                int cardIndex;
                ItemStack cardStack = this.inventoryHelper.getStackInSlot(i);
                if (cardStack == null || this.cardInfo[cardIndex = i - 16].getCompiledCard() != null) continue;
                CompiledCard compiled = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
                this.cardInfo[cardIndex].setCompiledCard(compiled);
            }
        }
    }

    public int getEnergy(Inventory side, RunningProgram program) {
        TileEntity te = this.getTileEntityAt(side);
        if (te instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)te;
            return handler.getEnergyStored(side.getIntSide() == null ? EnumFacing.DOWN : side.getIntSide());
        }
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, side.getIntSide())) {
            IEnergyStorage energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.getIntSide());
            return energy.getEnergyStored();
        }
        throw new ProgException(ExceptionType.EXCEPT_NORF);
    }

    public int getMaxEnergy(Inventory side, RunningProgram program) {
        TileEntity te = this.getTileEntityAt(side);
        if (te instanceof IEnergyHandler) {
            IEnergyHandler handler = (IEnergyHandler)te;
            return handler.getMaxEnergyStored(side.getIntSide() == null ? EnumFacing.DOWN : side.getIntSide());
        }
        if (te != null && te.hasCapability(CapabilityEnergy.ENERGY, side.getIntSide())) {
            IEnergyStorage energy = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, side.getIntSide());
            return energy.getMaxEnergyStored();
        }
        throw new ProgException(ExceptionType.EXCEPT_NORF);
    }

    public int getLiquid(Inventory side, RunningProgram program) {
        TileEntity te = this.getTileEntityAt(side);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getIntSide())) {
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getIntSide());
            IFluidTankProperties[] properties = handler.getTankProperties();
            if (properties != null && properties.length > 0 && properties[0].getContents() != null) {
                return properties[0].getContents().amount;
            }
            return 0;
        }
        throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
    }

    public int getMaxLiquid(Inventory side, RunningProgram program) {
        TileEntity te = this.getTileEntityAt(side);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getIntSide())) {
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.getIntSide());
            IFluidTankProperties[] properties = handler.getTankProperties();
            if (properties != null && properties.length > 0) {
                return properties[0].getCapacity();
            }
            return 0;
        }
        throw new ProgException(ExceptionType.EXCEPT_NOLIQUID);
    }

    private IStorageScanner getScannerForInv(Inventory inv) {
        if (inv == null) {
            return this.getStorageScanner();
        }
        return null;
    }

    private IItemHandler getHandlerForInv(Inventory inv) {
        if (inv == null) {
            return null;
        }
        return this.getItemHandlerAt(inv);
    }

    public int fetchItems(RunningProgram program, Inventory inv, Integer slot, @Nullable ItemStack itemMatcher, boolean routable, boolean oredict, @Nullable Integer amount, int virtualSlot) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        CardInfo info = this.cardInfo[program.getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        ItemStack stack = InventoryTools.tryExtractItem(handler, scanner, amount, routable, oredict, itemMatcher, slot);
        if (stack == null) {
            return 0;
        }
        IItemHandler capability = this.getItemHandler();
        if (capability.insertItem(realSlot, stack, true) != null) {
            return 0;
        }
        stack = InventoryTools.extractItem(handler, scanner, amount, routable, oredict, itemMatcher, slot);
        capability.insertItem(realSlot, stack, false);
        return stack.field_77994_a;
    }

    public ItemStack getItemInternal(RunningProgram program, int virtualSlot) {
        CardInfo info = this.cardInfo[program.getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        IItemHandler capability = this.getItemHandler();
        return capability.getStackInSlot(realSlot);
    }

    public int pushItems(RunningProgram program, Inventory inv, Integer slot, @Nullable Integer amount, int virtualSlot) {
        IStorageScanner scanner = this.getScannerForInv(inv);
        IItemHandler handler = this.getHandlerForInv(inv);
        CardInfo info = this.cardInfo[program.getCardIndex()];
        int realSlot = info.getRealSlot(virtualSlot);
        IItemHandler itemHandler = this.getItemHandler();
        ItemStack extracted = itemHandler.extractItem(realSlot, amount == null ? 64 : amount, false);
        if (extracted == null) {
            return 0;
        }
        ItemStack remaining = InventoryTools.insertItem(handler, scanner, extracted, slot);
        if (remaining != null) {
            itemHandler.insertItem(realSlot, remaining, false);
            return extracted.field_77994_a - remaining.field_77994_a;
        }
        return extracted.field_77994_a;
    }

    public int getMaxvars() {
        if (this.maxVars == -1) {
            this.maxVars = 0;
            this.hasNetworkCard = false;
            this.storageCard = -1;
            Item storageCardItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("rftools", "storage_control_module"));
            for (int i = 0; i < 16; ++i) {
                ItemStack stack = this.func_70301_a(i);
                if (stack == null) continue;
                if (stack.func_77973_b() == ModItems.networkCardItem) {
                    this.hasNetworkCard = true;
                    continue;
                }
                if (stack.func_77973_b() == ModItems.ramChipItem) {
                    this.maxVars += 8;
                    continue;
                }
                if (stack.func_77973_b() != storageCardItem) continue;
                this.storageCard = i;
            }
            if (this.maxVars >= 32) {
                this.maxVars = 32;
            }
        }
        return this.maxVars;
    }

    public boolean hasNetworkCard() {
        if (this.maxVars == -1) {
            this.getMaxvars();
        }
        return this.hasNetworkCard;
    }

    public int getStorageCard() {
        if (this.storageCard == -2) {
            this.getMaxvars();
        }
        return this.storageCard;
    }

    public String getChannelName() {
        return this.channel;
    }

    public int getNodeCount() {
        return this.networkNodes.size();
    }

    public void stopOrResume(RunningProgram program) {
        program.popLoopStack(this);
    }

    public OpcodeRunnable.OpcodeResult handleLoop(RunningProgram program, int varIdx, int end) {
        CardInfo info = this.cardInfo[program.getCardIndex()];
        int realVar = info.getRealVar(varIdx);
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        int i = TypeConverters.convertToInt(this.getVariableArray()[realVar].getParameterValue().getValue());
        if (i > end) {
            return OpcodeRunnable.OpcodeResult.NEGATIVE;
        }
        program.pushLoopStack(realVar);
        return OpcodeRunnable.OpcodeResult.POSITIVE;
    }

    public void setVariable(RunningProgram program, int var) {
        CardInfo info = this.cardInfo[program.getCardIndex()];
        int realVar = info.getRealVar(var);
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        this.variables[realVar] = program.getLastValue();
    }

    public <T> T evaluateParameter(CompiledOpcode compiledOpcode, RunningProgram program, int parIndex) {
        List<Parameter> parameters = compiledOpcode.getParameters();
        if (parIndex >= parameters.size()) {
            return null;
        }
        ParameterValue value = parameters.get(parIndex).getParameterValue();
        if (value.isConstant()) {
            return (T)value.getValue();
        }
        if (value.isFunction()) {
            ParameterValue v = value.getFunction().getFunctionRunnable().run(this, program, value.getFunction());
            return (T)v.getValue();
        }
        CardInfo info = this.cardInfo[program.getCardIndex()];
        int realVar = info.getRealVar(value.getVariableIndex());
        if (realVar == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGVARIABLE);
        }
        if (realVar >= this.getMaxvars()) {
            throw new ProgException(ExceptionType.EXCEPT_NOTENOUGHVARIABLES);
        }
        Parameter par = this.variables[realVar];
        if (par == null) {
            return null;
        }
        return (T)(par.isSet() ? par.getParameterValue().getValue() : null);
    }

    public int evaluateIntParameter(CompiledOpcode compiledOpcode, RunningProgram program, int parIndex) {
        Object value = this.evaluateParameter(compiledOpcode, program, parIndex);
        return TypeConverters.convertToInt(value);
    }

    public Integer evaluateIntegerParameter(CompiledOpcode compiledOpcode, RunningProgram program, int parIndex) {
        Object value = this.evaluateParameter(compiledOpcode, program, parIndex);
        return TypeConverters.convertToInteger(value);
    }

    public String evaluateStringParameter(CompiledOpcode compiledOpcode, RunningProgram program, int parIndex) {
        Object value = this.evaluateParameter(compiledOpcode, program, parIndex);
        return TypeConverters.convertToString(value);
    }

    public boolean evaluateBoolParameter(CompiledOpcode compiledOpcode, RunningProgram program, int parIndex) {
        Object value = this.evaluateParameter(compiledOpcode, program, parIndex);
        return TypeConverters.convertToBool(value);
    }

    public int countItemStorage(ItemStack stack, boolean routable, boolean oredict) {
        IStorageScanner scanner = this.getStorageScanner();
        if (scanner == null) {
            return 0;
        }
        return scanner.countItems(stack, routable, oredict);
    }

    private IStorageScanner getStorageScanner() {
        int card = this.getStorageCard();
        if (card == -1) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        ItemStack storageStack = this.func_70301_a(card);
        if (!storageStack.func_77942_o()) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGECARD);
        }
        NBTTagCompound tagCompound = storageStack.func_77978_p();
        BlockPos c = new BlockPos(tagCompound.func_74762_e("monitorx"), tagCompound.func_74762_e("monitory"), tagCompound.func_74762_e("monitorz"));
        int dim = tagCompound.func_74762_e("monitordim");
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!WorldTools.chunkLoaded((World)world, (BlockPos)c)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        TileEntity te = world.func_175625_s(c);
        if (te == null) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        if (!(te instanceof IStorageScanner)) {
            throw new ProgException(ExceptionType.EXCEPT_MISSINGSTORAGE);
        }
        return (IStorageScanner)te;
    }

    public int countItem(Inventory inv, Integer slot, ItemStack itemMatcher, boolean oredict, boolean routable, RunningProgram program) {
        if (inv == null) {
            return this.countItemStorage(itemMatcher, routable, oredict);
        }
        IItemHandler handler = this.getItemHandlerAt(inv);
        if (slot != null) {
            ItemStack stackInSlot = handler.getStackInSlot(slot.intValue());
            return stackInSlot == null ? 0 : stackInSlot.field_77994_a;
        }
        if (itemMatcher != null) {
            return this.countItemInHandler(itemMatcher, handler);
        }
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null) continue;
            cnt += stack.field_77994_a;
        }
        return cnt;
    }

    private int countItemInHandler(ItemStack itemMatcher, IItemHandler handler) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack == null || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) continue;
            cnt += stack.field_77994_a;
        }
        return cnt;
    }

    public TileEntity getTileEntityAt(Inventory inv) {
        if (inv == null) {
            return null;
        }
        BlockPos p = this.field_174879_c;
        if (inv.hasNodeName()) {
            if (!this.hasNetworkCard()) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNETWORKCARD);
            }
            p = this.networkNodes.get(inv.getNodeName());
            if (p == null) {
                throw new ProgException(ExceptionType.EXCEPT_MISSINGNODE);
            }
        }
        BlockPos np = p.func_177972_a(inv.getSide());
        return this.field_145850_b.func_175625_s(np);
    }

    public IItemHandler getItemHandlerAt(Inventory inv) {
        TileEntity te = this.getTileEntityAt(inv);
        if (te != null && te.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv.getIntSide())) {
            IItemHandler handler = (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, inv.getIntSide());
            if (handler != null) {
                return handler;
            }
        } else {
            if (te instanceof ISidedInventory) {
                ISidedInventory sidedInventory = (ISidedInventory)te;
                return new SidedInvWrapper(sidedInventory, inv.getIntSide());
            }
            if (te instanceof IInventory) {
                IInventory inventory = (IInventory)te;
                return new InvWrapper(inventory);
            }
        }
        throw new ProgException(ExceptionType.EXCEPT_INVALIDINVENTORY);
    }

    private boolean isExpansionSlot(int index) {
        return index >= 0 && index < 16;
    }

    private boolean isCardSlot(int index) {
        return index >= 16 && index < 22;
    }

    private void removeCard(int index) {
        this.cardInfo[index].setCompiledCard(null);
        this.stopPrograms(index);
        ArrayDeque<QueuedEvent> newQueue = new ArrayDeque<QueuedEvent>();
        for (QueuedEvent event : this.eventQueue) {
            if (event.getCardIndex() == index) continue;
            newQueue.add(event);
        }
        this.eventQueue = newQueue;
    }

    private void stopPrograms(int cardIndex) {
        for (CpuCore core : this.cpuCores) {
            if (!core.hasProgram() || core.getProgram().getCardIndex() != cardIndex) continue;
            core.stopProgram();
        }
        HashSet<Pair<Integer, Integer>> newRunningEvents = new HashSet<Pair<Integer, Integer>>();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            if ((Integer)pair.getLeft() == cardIndex) continue;
            newRunningEvents.add(pair);
        }
        this.runningEvents = newRunningEvents;
    }

    public void func_70299_a(int index, ItemStack stack) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.coresDirty = true;
            this.maxVars = -1;
        }
        this.getInventoryHelper().setInventorySlotContents(this.func_70297_j_(), index, stack);
    }

    public ItemStack func_70298_a(int index, int count) {
        if (this.isCardSlot(index)) {
            this.removeCard(index - 16);
            this.cardsDirty = true;
        } else if (this.isExpansionSlot(index)) {
            this.coresDirty = true;
            this.maxVars = -1;
        }
        return this.getInventoryHelper().decrStackSize(index, count);
    }

    public void readClientDataFromNBT(NBTTagCompound tagCompound) {
        this.working = tagCompound.func_74767_n("working");
        this.readCardInfo(tagCompound);
    }

    public void writeClientDataToNBT(NBTTagCompound tagCompound) {
        tagCompound.func_74757_a("working", this.working);
        this.writeCardInfo(tagCompound);
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        this.prevIn = tagCompound.func_74762_e("prevIn");
        for (int i = 0; i < 6; ++i) {
            this.powerOut[i] = tagCompound.func_74771_c("p" + i);
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        tagCompound.func_74768_a("prevIn", this.prevIn);
        for (int i = 0; i < 6; ++i) {
            tagCompound.func_74774_a("p" + i, (byte)this.powerOut[i]);
        }
        return tagCompound;
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.working = tagCompound.func_74767_n("working");
        this.tickCount = tagCompound.func_74762_e("tickCount");
        this.channel = tagCompound.func_74779_i("channel");
        this.readBufferFromNBT(tagCompound, this.inventoryHelper);
        this.readCardInfo(tagCompound);
        this.readCores(tagCompound);
        this.readEventQueue(tagCompound);
        this.readLog(tagCompound);
        this.readVariables(tagCompound);
        this.readNetworkNodes(tagCompound);
        this.readCraftingStations(tagCompound);
        this.readWaitingForItems(tagCompound);
        this.readLocks(tagCompound);
        this.readRunningEvents(tagCompound);
    }

    private void readRunningEvents(NBTTagCompound tagCompound) {
        this.runningEvents.clear();
        NBTTagList evList = tagCompound.func_150295_c("singev", 10);
        for (int i = 0; i < evList.func_74745_c(); ++i) {
            NBTTagCompound tag = evList.func_150305_b(i);
            int cardIndex = tag.func_74762_e("card");
            int eventIndex = tag.func_74762_e("event");
            this.runningEvents.add((Pair<Integer, Integer>)Pair.of((Object)cardIndex, (Object)eventIndex));
        }
    }

    private void readLocks(NBTTagCompound tagCompound) {
        this.locks.clear();
        NBTTagList lockList = tagCompound.func_150295_c("locks", 8);
        for (int i = 0; i < lockList.func_74745_c(); ++i) {
            String name = lockList.func_150307_f(i);
            this.locks.add(name);
        }
    }

    private void readWaitingForItems(NBTTagCompound tagCompound) {
        this.waitingForItems.clear();
        NBTTagList waitingList = tagCompound.func_150295_c("waiting", 10);
        for (int i = 0; i < waitingList.func_74745_c(); ++i) {
            NBTTagCompound tag = waitingList.func_150305_b(i);
            String ticket = tag.func_74779_i("ticket");
            ItemStack stack = tag.func_74764_b("item") ? ItemStack.func_77949_a((NBTTagCompound)tag.func_74775_l("item")) : null;
            Inventory inventory = tag.func_74764_b("inv") ? Inventory.readFromNBT(tag.func_74775_l("inv")) : null;
            WaitForItem waitForItem = new WaitForItem(ticket, stack, inventory);
            this.waitingForItems.add(waitForItem);
        }
    }

    private void readCraftingStations(NBTTagCompound tagCompound) {
        this.craftingStations.clear();
        NBTTagList stationList = tagCompound.func_150295_c("stations", 10);
        for (int i = 0; i < stationList.func_74745_c(); ++i) {
            NBTTagCompound tag = stationList.func_150305_b(i);
            BlockPos nodePos = new BlockPos(tag.func_74762_e("nodex"), tag.func_74762_e("nodey"), tag.func_74762_e("nodez"));
            this.craftingStations.add(nodePos);
        }
    }

    private void readNetworkNodes(NBTTagCompound tagCompound) {
        this.networkNodes.clear();
        NBTTagList networkList = tagCompound.func_150295_c("nodes", 10);
        for (int i = 0; i < networkList.func_74745_c(); ++i) {
            NBTTagCompound tag = networkList.func_150305_b(i);
            String name = tag.func_74779_i("name");
            BlockPos nodePos = new BlockPos(tag.func_74762_e("nodex"), tag.func_74762_e("nodey"), tag.func_74762_e("nodez"));
            this.networkNodes.put(name, nodePos);
        }
    }

    private void readVariables(NBTTagCompound tagCompound) {
        for (int i = 0; i < 32; ++i) {
            this.variables[i] = null;
        }
        NBTTagList varList = tagCompound.func_150295_c("vars", 10);
        for (int i = 0; i < varList.func_74745_c(); ++i) {
            NBTTagCompound var = varList.func_150305_b(i);
            int index = var.func_74762_e("varidx");
            this.variables[index] = Parameter.readFromNBT(var);
        }
    }

    private void readLog(NBTTagCompound tagCompound) {
        this.logMessages.clear();
        NBTTagList logList = tagCompound.func_150295_c("log", 8);
        for (int i = 0; i < logList.func_74745_c(); ++i) {
            this.logMessages.add(logList.func_150307_f(i));
        }
    }

    private void readCores(NBTTagCompound tagCompound) {
        NBTTagList coreList = tagCompound.func_150295_c("cores", 10);
        this.cpuCores.clear();
        this.coresDirty = false;
        for (int i = 0; i < coreList.func_74745_c(); ++i) {
            CpuCore core = new CpuCore();
            core.readFromNBT(coreList.func_150305_b(i));
            this.cpuCores.add(core);
        }
        if (this.cpuCores.isEmpty()) {
            this.coresDirty = true;
        }
    }

    private void readEventQueue(NBTTagCompound tagCompound) {
        this.eventQueue.clear();
        NBTTagList eventQueueList = tagCompound.func_150295_c("events", 10);
        for (int i = 0; i < eventQueueList.func_74745_c(); ++i) {
            NBTTagCompound tag = eventQueueList.func_150305_b(i);
            int card = tag.func_74762_e("card");
            int index = tag.func_74762_e("index");
            boolean single = tag.func_74767_n("single");
            String ticket = tag.func_74764_b("ticket") ? tag.func_74779_i("ticket") : null;
            this.eventQueue.add(new QueuedEvent(card, new CompiledEvent(index, single), ticket));
        }
    }

    private void readCardInfo(NBTTagCompound tagCompound) {
        NBTTagList cardInfoList = tagCompound.func_150295_c("cardInfo", 10);
        for (int i = 0; i < cardInfoList.func_74745_c(); ++i) {
            this.cardInfo[i] = CardInfo.readFromNBT(cardInfoList.func_150305_b(i));
        }
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74757_a("working", this.working);
        tagCompound.func_74768_a("tickCount", this.tickCount);
        tagCompound.func_74778_a("channel", this.channel == null ? "" : this.channel);
        this.writeBufferToNBT(tagCompound, this.inventoryHelper);
        this.writeCardInfo(tagCompound);
        this.writeCores(tagCompound);
        this.writeEventQueue(tagCompound);
        this.writeLog(tagCompound);
        this.writeVariables(tagCompound);
        this.writeNetworkNodes(tagCompound);
        this.writeCraftingStations(tagCompound);
        this.writeWaitingForItems(tagCompound);
        this.writeLocks(tagCompound);
        this.writeRunningEvents(tagCompound);
    }

    private void writeRunningEvents(NBTTagCompound tagCompound) {
        NBTTagList evList = new NBTTagList();
        for (Pair<Integer, Integer> pair : this.runningEvents) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("card", ((Integer)pair.getLeft()).intValue());
            tag.func_74768_a("event", ((Integer)pair.getRight()).intValue());
            evList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("singev", (NBTBase)evList);
    }

    private void writeLocks(NBTTagCompound tagCompound) {
        NBTTagList lockList = new NBTTagList();
        for (String name : this.locks) {
            lockList.func_74742_a((NBTBase)new NBTTagString(name));
        }
        tagCompound.func_74782_a("locks", (NBTBase)lockList);
    }

    private void writeWaitingForItems(NBTTagCompound tagCompound) {
        NBTTagList waitingList = new NBTTagList();
        for (WaitForItem waitingForItem : this.waitingForItems) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("ticket", waitingForItem.getTicket());
            if (waitingForItem.getInventory() != null) {
                tag.func_74782_a("inv", (NBTBase)waitingForItem.getInventory().writeToNBT());
            }
            if (waitingForItem.getItemStack() != null) {
                tag.func_74782_a("item", (NBTBase)waitingForItem.getItemStack().serializeNBT());
            }
            waitingList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("waiting", (NBTBase)waitingList);
    }

    private void writeCraftingStations(NBTTagCompound tagCompound) {
        NBTTagList stationList = new NBTTagList();
        for (BlockPos pos : this.craftingStations) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("nodex", pos.func_177958_n());
            tag.func_74768_a("nodey", pos.func_177956_o());
            tag.func_74768_a("nodez", pos.func_177952_p());
            stationList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("stations", (NBTBase)stationList);
    }

    private void writeNetworkNodes(NBTTagCompound tagCompound) {
        NBTTagList networkList = new NBTTagList();
        for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("name", entry.getKey());
            tag.func_74768_a("nodex", entry.getValue().func_177958_n());
            tag.func_74768_a("nodey", entry.getValue().func_177956_o());
            tag.func_74768_a("nodez", entry.getValue().func_177952_p());
            networkList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("nodes", (NBTBase)networkList);
    }

    private void writeVariables(NBTTagCompound tagCompound) {
        NBTTagList varList = new NBTTagList();
        for (int i = 0; i < 32; ++i) {
            if (this.variables[i] == null) continue;
            NBTTagCompound var = Parameter.writeToNBT(this.variables[i]);
            var.func_74768_a("varidx", i);
            varList.func_74742_a((NBTBase)var);
        }
        tagCompound.func_74782_a("vars", (NBTBase)varList);
    }

    private void writeLog(NBTTagCompound tagCompound) {
        NBTTagList logList = new NBTTagList();
        for (String message : this.logMessages) {
            logList.func_74742_a((NBTBase)new NBTTagString(message));
        }
        tagCompound.func_74782_a("log", (NBTBase)logList);
    }

    private void writeCores(NBTTagCompound tagCompound) {
        NBTTagList coreList = new NBTTagList();
        for (CpuCore core : this.cpuCores) {
            coreList.func_74742_a((NBTBase)core.writeToNBT());
        }
        tagCompound.func_74782_a("cores", (NBTBase)coreList);
    }

    private void writeEventQueue(NBTTagCompound tagCompound) {
        NBTTagList eventQueueList = new NBTTagList();
        for (QueuedEvent queuedEvent : this.eventQueue) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("card", queuedEvent.getCardIndex());
            tag.func_74768_a("index", queuedEvent.getCompiledEvent().getIndex());
            tag.func_74757_a("single", queuedEvent.getCompiledEvent().isSingle());
            if (queuedEvent.getTicket() != null) {
                tag.func_74778_a("ticket", queuedEvent.getTicket());
            }
            eventQueueList.func_74742_a((NBTBase)tag);
        }
        tagCompound.func_74782_a("events", (NBTBase)eventQueueList);
    }

    private void writeCardInfo(NBTTagCompound tagCompound) {
        NBTTagList cardInfoList = new NBTTagList();
        for (CardInfo info : this.cardInfo) {
            cardInfoList.func_74742_a((NBTBase)info.writeToNBT());
        }
        tagCompound.func_74782_a("cardInfo", (NBTBase)cardInfoList);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        boolean newWorking;
        boolean working = this.isWorking();
        super.onDataPacket(net, packet);
        if (this.field_145850_b.field_72995_K && (newWorking = this.isWorking()) != working) {
            this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
        }
    }

    public boolean isVarAllocated(int cardIndex, int varIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int varAlloc = info.getVarAllocation();
                if ((varAlloc >> varIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int varAlloc = info.getVarAllocation();
        return (varAlloc >> varIndex & 1) != 0;
    }

    public boolean isItemAllocated(int cardIndex, int itemIndex) {
        if (cardIndex == -1) {
            for (CardInfo info : this.cardInfo) {
                int itemAlloc = info.getItemAllocation();
                if ((itemAlloc >> itemIndex & 1) == 0) continue;
                return true;
            }
            return false;
        }
        CardInfo info = this.getCardInfo(cardIndex);
        int itemAlloc = info.getItemAllocation();
        return (itemAlloc >> itemIndex & 1) != 0;
    }

    public CardInfo getCardInfo(int index) {
        return this.cardInfo[index];
    }

    public CompiledCard getCompiledCard(int index) {
        CardInfo info = this.getCardInfo(index);
        CompiledCard card = info.getCompiledCard();
        ItemStack cardStack = this.inventoryHelper.getStackInSlot(index + 16);
        if (card == null && cardStack != null) {
            card = CompiledCard.compile(ProgramCardInstance.parseInstance(cardStack));
            this.cardInfo[index].setCompiledCard(card);
        }
        return card;
    }

    public boolean isWorking() {
        return this.working && this.isMachineEnabled();
    }

    private void allocate(int card, int itemAlloc, int varAlloc) {
        this.cardInfo[card].setItemAllocation(itemAlloc);
        this.cardInfo[card].setVarAllocation(varAlloc);
        this.func_70296_d();
    }

    public void showNetworkInfo() {
        this.log("Channel: " + this.channel);
        this.log("Nodes: " + this.networkNodes.size());
    }

    public void listNodes() {
        if (this.networkNodes.isEmpty()) {
            this.log("No nodes!");
        } else {
            for (Map.Entry<String, BlockPos> entry : this.networkNodes.entrySet()) {
                this.log("Node " + entry.getKey() + " at " + BlockPosTools.toString((BlockPos)entry.getValue()));
            }
        }
    }

    public void setupNetwork(String name) {
        this.channel = name;
        this.func_70296_d();
    }

    public void redstoneNodeChange(int previousMask, int newMask, String node) {
        for (int i = 0; i < this.cardInfo.length; ++i) {
            CardInfo info = this.cardInfo[i];
            CompiledCard compiledCard = info.getCompiledCard();
            if (compiledCard == null) continue;
            this.handleEventsRedstoneOn(i, compiledCard, node, previousMask, newMask);
            this.handleEventsRedstoneOff(i, compiledCard, node, previousMask, newMask);
        }
    }

    public void scanNodes() {
        if (this.channel == null || this.channel.isEmpty()) {
            this.log("Setup a channel first!");
            return;
        }
        this.networkNodes.clear();
        this.craftingStations.clear();
        for (int x = -8; x <= 8; ++x) {
            for (int y = -8; y <= 8; ++y) {
                for (int z = -8; z <= 8; ++z) {
                    BlockPos n = new BlockPos(this.field_174879_c.func_177958_n() + x, this.field_174879_c.func_177956_o() + y, this.field_174879_c.func_177952_p() + z);
                    TileEntity te = this.field_145850_b.func_175625_s(n);
                    if (te instanceof NodeTileEntity) {
                        NodeTileEntity node = (NodeTileEntity)te;
                        if (!this.channel.equals(node.getChannelName())) continue;
                        if (node.getNodeName() == null || node.getNodeName().isEmpty()) {
                            this.log("Node is missing a name!");
                            continue;
                        }
                        this.networkNodes.put(node.getNodeName(), n);
                        node.setProcessor(this.func_174877_v());
                        continue;
                    }
                    if (!(te instanceof CraftingStationTileEntity)) continue;
                    CraftingStationTileEntity craftingStation = (CraftingStationTileEntity)te;
                    craftingStation.registerProcessor(this.field_174879_c);
                    this.craftingStations.add(n);
                }
            }
        }
        this.log("Found " + this.networkNodes.size() + " node(s)");
        this.log("Found " + this.craftingStations.size() + " crafting station(s)");
        this.func_70296_d();
    }

    public boolean execute(EntityPlayerMP playerMP, String command, Map<String, Argument> args) {
        boolean rc = super.execute(playerMP, command, args);
        if (rc) {
            return true;
        }
        if (CMD_ALLOCATE.equals(command)) {
            int card = args.get("card").getInteger();
            int itemAlloc = args.get("items").getInteger();
            int varAlloc = args.get("vars").getInteger();
            this.allocate(card, itemAlloc, varAlloc);
            return true;
        }
        if (CMD_CLEARLOG.equals(command)) {
            Commands.executeCommand(this, args.get("cmd").getString());
            return true;
        }
        return false;
    }

    public List executeWithResultList(String command, Map<String, Argument> args) {
        List rc = super.executeWithResultList(command, args);
        if (rc != null) {
            return rc;
        }
        if ("getLog".equals(command)) {
            return this.getLog();
        }
        if ("getVars".equals(command)) {
            return this.getVariables();
        }
        return null;
    }

    public boolean execute(String command, List list) {
        boolean rc = super.execute(command, list);
        if (rc) {
            return true;
        }
        if ("getLog".equals(command)) {
            GuiProcessor.storeLogForClient(list);
            return true;
        }
        if ("getVars".equals(command)) {
            GuiProcessor.storeVarsForClient(list);
            return true;
        }
        return false;
    }
}

