/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.items.ProgramCardItem;
import mcjty.rftoolscontrol.logic.grid.ProgramCardInstance;
import mcjty.rftoolscontrol.network.PacketItemNBTToServer;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class ProgramCommand
extends CommandBase {
    public String func_71517_b() {
        return "rfctrl";
    }

    public String func_71518_a(ICommandSender sender) {
        return "rfctrl save | load";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length > 1) {
            ItemStack item = Minecraft.func_71410_x().field_71439_g.func_184614_ca();
            if (item == null || !(item.func_77973_b() instanceof ProgramCardItem)) {
                sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You need a program card in your hand!"));
                return;
            }
            if ("save".equals(args[0])) {
                this.saveProgram(sender, args[1], item);
            } else if ("load".equals(args[0])) {
                this.loadProgram(sender, args[1], item);
            }
        } else {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Missing parameter (save <file> or load <file>)!"));
        }
    }

    private void loadProgram(ICommandSender sender, String arg, ItemStack item) {
        String json;
        File file = new File(arg);
        try {
            FileInputStream stream = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            stream.read(data);
            json = new String(data, "UTF-8");
        }
        catch (IOException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error opening file for reading!"));
            return;
        }
        ProgramCardInstance program = ProgramCardInstance.readFromJson(json);
        program.writeToNBT(item);
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketItemNBTToServer(item.func_77978_p()));
        sender.func_145747_a((ITextComponent)new TextComponentString("Loaded program!"));
    }

    private void saveProgram(ICommandSender sender, String arg, ItemStack item) {
        PrintWriter writer;
        ProgramCardInstance program = ProgramCardInstance.parseInstance(item);
        String json = program.writeToJson();
        File file = new File(arg);
        if (file.exists()) {
            file.delete();
        }
        try {
            writer = new PrintWriter(file);
        }
        catch (FileNotFoundException e) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Error opening file for writing!"));
            return;
        }
        writer.print(json);
        writer.close();
        sender.func_145747_a((ITextComponent)new TextComponentString("Saved program!"));
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos pos) {
        if (args.length > 0) {
            return ProgramCommand.func_71530_a((String[])args, (String[])new String[]{"save", "load"});
        }
        return null;
    }
}

