/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.items.craftingcard;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.items.GenericRFToolsItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CraftingCardItem
extends GenericRFToolsItem {
    public CraftingCardItem() {
        super("crafting_card");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> list, boolean advanced) {
        super.func_77624_a(stack, playerIn, list, advanced);
        list.add("This item can be used for auto");
        list.add("crafting. It stores ingredients");
        list.add("and end result for a recipe");
        ItemStack result = CraftingCardItem.getResult(stack);
        if (result != null) {
            if (result.field_77994_a > 1) {
                list.add(TextFormatting.BLUE + "Item: " + TextFormatting.WHITE + result.func_82833_r() + "(" + result.field_77994_a + ")");
            } else {
                list.add(TextFormatting.BLUE + "Item: " + TextFormatting.WHITE + result.func_82833_r());
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(ItemStack stack, World world, EntityPlayer player, EnumHand hand) {
        if (hand != EnumHand.MAIN_HAND) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        if (!world.field_72995_K) {
            player.openGui((Object)RFToolsControl.instance, RFToolsControl.GUI_CRAFTINGCARD, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public static ItemStack getResult(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return null;
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(20);
        return ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
    }

    private static boolean isInGrid(int index) {
        int x = index % 5;
        int y = index / 5;
        return x <= 2 && y <= 2;
    }

    public static boolean fitsGrid(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return false;
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.func_77949_a((NBTTagCompound)(nbtTagCompound = bufferTagList.func_150305_b(i)))) == null || s.field_77994_a <= 0 || CraftingCardItem.isInGrid(i)) continue;
            return false;
        }
        return true;
    }

    public static List<ItemStack> getIngredientsGrid(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            if (i >= 20) continue;
            NBTTagCompound nbtTagCompound = bufferTagList.func_150305_b(i);
            ItemStack s = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
            if (!CraftingCardItem.isInGrid(i)) continue;
            stacks.add(s);
        }
        return stacks;
    }

    public static List<ItemStack> getIngredients(ItemStack card) {
        NBTTagCompound tagCompound = card.func_77978_p();
        if (tagCompound == null) {
            return Collections.emptyList();
        }
        NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < bufferTagList.func_74745_c(); ++i) {
            NBTTagCompound nbtTagCompound;
            ItemStack s;
            if (i >= 20 || (s = ItemStack.func_77949_a((NBTTagCompound)(nbtTagCompound = bufferTagList.func_150305_b(i)))) == null || s.field_77994_a <= 0) continue;
            stacks.add(s);
        }
        return stacks;
    }
}

