/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftools.api.storage.IStorageScanner;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class InventoryTools {
    public static int countItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, ItemStack itemMatcher, boolean oredict, int maxToCount) {
        if (itemHandler != null) {
            int cnt = 0;
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack == null || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher) || maxToCount == -1 || (cnt += stack.field_77994_a) < maxToCount) continue;
                return maxToCount;
            }
            return cnt;
        }
        if (scanner != null) {
            int cnt = scanner.countItems(itemMatcher, true, oredict);
            if (maxToCount != -1 && cnt >= maxToCount) {
                return maxToCount;
            }
            return cnt;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public static ItemStack extractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, boolean oredict, @Nullable ItemStack itemMatcher, @Nullable Integer slot) {
        block14: {
            block13: {
                int n;
                block11: {
                    int n2;
                    block12: {
                        if (itemHandler == null) break block11;
                        if (slot != null) break block12;
                        if (itemMatcher == null) break block13;
                        break block14;
                    }
                    if (itemMatcher == null) {
                        int n3;
                        int n4 = slot;
                        if (amount == null) {
                            n3 = 64;
                            return itemHandler.extractItem(n4, n3, false);
                        }
                        n3 = amount;
                        return itemHandler.extractItem(n4, n3, false);
                    }
                    if (!ItemStack.func_179545_c((ItemStack)itemMatcher, (ItemStack)itemHandler.getStackInSlot(slot.intValue()))) {
                        return null;
                    }
                    int n5 = slot;
                    if (amount == null) {
                        n2 = itemMatcher.func_77976_d();
                        return itemHandler.extractItem(n5, n2, false);
                    }
                    n2 = amount;
                    return itemHandler.extractItem(n5, n2, false);
                }
                if (scanner == null) return null;
                if (amount == null) {
                    n = itemMatcher.func_77976_d();
                    return scanner.requestItem(itemMatcher, n, routable, oredict);
                }
                n = amount;
                return scanner.requestItem(itemMatcher, n, routable, oredict);
            }
            int i = 0;
            while (i < itemHandler.getSlots()) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack != null && (amount == null || amount <= stack.field_77994_a)) {
                    int n;
                    if (amount == null) {
                        n = 64;
                        return itemHandler.extractItem(i, n, false);
                    }
                    n = amount;
                    return itemHandler.extractItem(i, n, false);
                }
                ++i;
            }
            return null;
        }
        int i = 0;
        while (i < itemHandler.getSlots()) {
            ItemStack stack = itemHandler.getStackInSlot(i);
            if (stack != null && ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) {
                int n;
                if (amount == null) {
                    n = itemMatcher.func_77976_d();
                    return itemHandler.extractItem(i, n, false);
                }
                n = amount;
                return itemHandler.extractItem(i, n, false);
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static ItemStack tryExtractItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nullable Integer amount, boolean routable, boolean oredict, @Nullable ItemStack itemMatcher, @Nullable Integer slot) {
        int cnt;
        if (itemHandler != null) {
            if (slot == null) {
                ItemStack stack;
                int i;
                if (itemMatcher == null) {
                    for (i = 0; i < itemHandler.getSlots(); ++i) {
                        stack = itemHandler.getStackInSlot(i);
                        if (stack == null || amount != null && amount > stack.field_77994_a) continue;
                        return itemHandler.extractItem(i, amount == null ? 64 : amount, true);
                    }
                } else {
                    for (i = 0; i < itemHandler.getSlots(); ++i) {
                        stack = itemHandler.getStackInSlot(i);
                        if (stack == null || !ItemStack.func_179545_c((ItemStack)stack, (ItemStack)itemMatcher)) continue;
                        return itemHandler.extractItem(i, amount == null ? itemMatcher.func_77976_d() : amount.intValue(), true);
                    }
                }
            } else {
                if (itemMatcher == null) {
                    return itemHandler.extractItem(slot.intValue(), amount == null ? 64 : amount, true);
                }
                if (!ItemStack.func_179545_c((ItemStack)itemMatcher, (ItemStack)itemHandler.getStackInSlot(slot.intValue()))) {
                    return null;
                }
                return itemHandler.extractItem(slot.intValue(), amount == null ? itemMatcher.func_77976_d() : amount.intValue(), true);
            }
        }
        if (scanner != null && (cnt = scanner.countItems(itemMatcher, routable, oredict)) > 0) {
            ItemStack copy = itemMatcher.func_77946_l();
            copy.field_77994_a = Math.min(cnt, amount == null ? itemMatcher.func_77976_d() : amount.intValue());
            return copy;
        }
        return null;
    }

    @Nullable
    public static ItemStack insertItem(@Nullable IItemHandler itemHandler, @Nullable IStorageScanner scanner, @Nonnull ItemStack item, @Nullable Integer slot) {
        if (itemHandler != null) {
            if (slot == null) {
                return ItemHandlerHelper.insertItem((IItemHandler)itemHandler, (ItemStack)item, (boolean)false);
            }
            return itemHandler.insertItem(slot.intValue(), item, false);
        }
        if (scanner != null) {
            int cnt = scanner.insertItem(item);
            if (cnt > 0) {
                ItemStack copy = item.func_77946_l();
                copy.field_77994_a = cnt;
                return copy;
            }
            return null;
        }
        return item;
    }
}

