/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import mcjty.rftoolscontrol.logic.registry.ParameterType;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class ExceptionEditor
extends AbstractParameterEditor {
    private ChoiceLabel label;

    private static ExceptionType parseFacingSafe(String t) {
        if ("*".equals(t)) {
            return null;
        }
        return ExceptionType.getExceptionForCode(t);
    }

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.label = (ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(160);
        this.label.addChoices(new String[]{"*"});
        for (ExceptionType exception : ExceptionType.values()) {
            this.label.addChoices(new String[]{exception.getCode()});
        }
        this.label.addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue()));
        constantPanel.addChild((Widget)this.label);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_EXCEPTION);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant((Object)ExceptionEditor.parseFacingSafe(this.label.getCurrentChoice()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.label.setChoice("*");
        } else {
            ExceptionType exception = (ExceptionType)((Object)value.getValue());
            this.label.setChoice(exception.getCode());
        }
    }
}

