/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import mcjty.rftoolscontrol.logic.registry.ParameterType;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class IntegerEditor
extends AbstractParameterEditor {
    private TextField field;

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.field = new TextField(mc, gui).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue()));
        constantPanel.addChild((Widget)this.field);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_INTEGER);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant(IntegerEditor.parseIntSafe(this.field.getText()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.setText("");
        } else {
            try {
                this.field.setText(Integer.toString((Integer)value.getValue()));
            }
            catch (Exception e) {
                this.field.setText("");
            }
        }
    }
}

