/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.VerticalLayout;
import mcjty.lib.gui.widgets.ChoiceLabel;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import mcjty.rftoolscontrol.logic.registry.BlockSide;
import mcjty.rftoolscontrol.logic.registry.ParameterType;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.StringUtils;

public class SideEditor
extends AbstractParameterEditor {
    private TextField nameLabel;
    private ChoiceLabel label;

    private static EnumFacing parseFacingSafe(String t) {
        if ("*".equals(t)) {
            return null;
        }
        return EnumFacing.func_176739_a((String)StringUtils.lowerCase((String)t));
    }

    @Override
    public int getHeight() {
        return 35;
    }

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new VerticalLayout());
        this.nameLabel = (TextField)((TextField)new TextField(mc, gui).addTextEvent((o, text) -> callback.valueChanged(this.readValue())).setDesiredWidth(50)).setDesiredHeight(14);
        constantPanel.addChild((Widget)this.createLabeledPanel(mc, gui, "Node name:", (Widget)this.nameLabel, "Optional name of a node in the network"));
        this.label = (ChoiceLabel)new ChoiceLabel(mc, gui).addChoices(new String[]{"*", "Down", "Up", "North", "South", "West", "East"}).addChoiceEvent((parent, newChoice) -> callback.valueChanged(this.readValue())).setDesiredWidth(60);
        constantPanel.addChild((Widget)this.createLabeledPanel(mc, gui, "Side:", (Widget)this.label, "Side relative to processor or node", "for the desired block"));
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_SIDE);
    }

    @Override
    protected ParameterValue readConstantValue() {
        BlockSide side = new BlockSide(this.nameLabel.getText(), SideEditor.parseFacingSafe(this.label.getCurrentChoice()));
        return ParameterValue.constant(side);
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.nameLabel.setText("");
            this.label.setChoice("*");
        } else {
            BlockSide side = (BlockSide)value.getValue();
            this.nameLabel.setText(side.getNodeName() == null ? "" : side.getNodeName());
            String choice = StringUtils.capitalize((String)side.toString());
            this.label.setChoice(choice);
        }
    }
}

