/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mcjty.rftoolscontrol.logic.registry.FunctionRunnable;
import mcjty.rftoolscontrol.logic.registry.ParameterType;

public class Function {
    private final String id;
    private final String name;
    private final FunctionRunnable functionRunnable;
    private final List<String> description;
    private final ParameterType returnType;

    private Function(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.functionRunnable = builder.functionRunnable;
        this.description = new ArrayList<String>(builder.description);
        this.returnType = builder.returnType;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public FunctionRunnable getFunctionRunnable() {
        return this.functionRunnable;
    }

    public List<String> getDescription() {
        return this.description;
    }

    public ParameterType getReturnType() {
        return this.returnType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final FunctionRunnable NOOP = (processor, program, opcode) -> null;
        private String id;
        private FunctionRunnable functionRunnable = NOOP;
        private List<String> description = Collections.emptyList();
        private ParameterType returnType;
        private String name;

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder runnable(FunctionRunnable runnable) {
            this.functionRunnable = runnable;
            return this;
        }

        public Builder description(String ... description) {
            this.description = new ArrayList<String>();
            Collections.addAll(this.description, description);
            return this;
        }

        public Builder type(ParameterType type) {
            this.returnType = type;
            return this;
        }

        public Function build() {
            return new Function(this);
        }
    }
}

