/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import mcjty.rftoolscontrol.logic.Parameter;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.registry.Function;
import mcjty.rftoolscontrol.logic.registry.ParameterType;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import net.minecraft.item.ItemStack;

public class Functions {
    public static Random random = new Random(System.currentTimeMillis());
    public static final Function LASTBOOL = Function.builder().id("last_bool").name("last").description("The last opcode result", "converted to a boolean").type(ParameterType.PAR_BOOLEAN).runnable((processor, program, function) -> Functions.convertToBool(program.getLastValue())).build();
    public static final Function LASTINT = Function.builder().id("last_int").name("last").description("The last opcode result", "converted to an integer").type(ParameterType.PAR_INTEGER).runnable((processor, program, function) -> Functions.convertToInt(program.getLastValue())).build();
    public static final Function LASTSTRING = Function.builder().id("last_str").name("last").description("The last opcode result", "converted to a string").type(ParameterType.PAR_STRING).runnable((processor, program, function) -> Functions.convertToString(program.getLastValue())).build();
    public static final Function TICKET = Function.builder().id("ticket").name("ticket").description("The current crafting ticket").type(ParameterType.PAR_STRING).runnable((processor, program, function) -> ParameterValue.constant(program.getCraftTicket())).build();
    public static final Function CRAFTRESULT = Function.builder().id("craftresult").name("craftresult").description("The current desired crafting result").type(ParameterType.PAR_ITEM).runnable((processor, program, function) -> ParameterValue.constant(processor.getCraftResult(program))).build();
    public static final Function RANDOMINT = Function.builder().id("random_int").name("random").description("A random integer between 0", "and the last opcode result (exclusive)", "(converted to integer)").type(ParameterType.PAR_INTEGER).runnable((processor, program, function) -> {
        int i = TypeConverters.convertToInt(program.getLastValue());
        return ParameterValue.constant(random.nextInt(i));
    }).build();
    public static final Function RANDOMFLOAT = Function.builder().id("random_float").name("random").description("A random floating number between 0", "and the last opcode result (exclusive)", "(converted to float)").type(ParameterType.PAR_FLOAT).runnable((processor, program, function) -> {
        float i = TypeConverters.convertToFloat(program.getLastValue());
        return ParameterValue.constant(Float.valueOf(random.nextFloat() * i));
    }).build();
    public static final Map<String, Function> FUNCTIONS = new HashMap<String, Function>();
    private static final Map<ParameterType, List<Function>> FUNCTIONS_BY_TYPE = new HashMap<ParameterType, List<Function>>();

    private static ParameterValue convertToBool(Parameter value) {
        if (value == null) {
            return ParameterValue.constant(false);
        }
        if (!value.isSet()) {
            return ParameterValue.constant(false);
        }
        Object v = value.getParameterValue().getValue();
        switch (value.getParameterType()) {
            case PAR_STRING: {
                return ParameterValue.constant(!((String)v).isEmpty());
            }
            case PAR_INTEGER: {
                return ParameterValue.constant((Integer)v != 0);
            }
            case PAR_FLOAT: {
                return ParameterValue.constant(((Float)v).floatValue() != 0.0f);
            }
            case PAR_SIDE: {
                return ParameterValue.constant(false);
            }
            case PAR_BOOLEAN: {
                return value.getParameterValue();
            }
        }
        return ParameterValue.constant(false);
    }

    private static ParameterValue convertToInt(Parameter value) {
        if (value == null) {
            return ParameterValue.constant(0);
        }
        if (!value.isSet()) {
            return ParameterValue.constant(0);
        }
        Object v = value.getParameterValue().getValue();
        switch (value.getParameterType()) {
            case PAR_STRING: {
                return ParameterValue.constant(Integer.parseInt((String)v));
            }
            case PAR_INTEGER: {
                return value.getParameterValue();
            }
            case PAR_FLOAT: {
                return ParameterValue.constant(((Float)v).intValue());
            }
            case PAR_SIDE: {
                return ParameterValue.constant(0);
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Boolean)v != false ? 1 : 0);
            }
            case PAR_ITEM: {
                return ParameterValue.constant(((ItemStack)v).field_77994_a);
            }
        }
        return ParameterValue.constant(0);
    }

    private static ParameterValue convertToString(Parameter value) {
        if (value == null) {
            return ParameterValue.constant("");
        }
        if (!value.isSet()) {
            return ParameterValue.constant("");
        }
        Object v = value.getParameterValue().getValue();
        switch (value.getParameterType()) {
            case PAR_STRING: {
                return value.getParameterValue();
            }
            case PAR_INTEGER: {
                return ParameterValue.constant(Integer.toString((Integer)v));
            }
            case PAR_FLOAT: {
                return ParameterValue.constant(Float.toString(((Float)v).floatValue()));
            }
            case PAR_SIDE: {
                return ParameterValue.constant(v.toString());
            }
            case PAR_BOOLEAN: {
                return ParameterValue.constant((Boolean)v != false ? "true" : "false");
            }
            case PAR_ITEM: {
                return ParameterValue.constant(((ItemStack)v).func_82833_r());
            }
        }
        return ParameterValue.constant("");
    }

    public static void init() {
        Functions.register(LASTBOOL);
        Functions.register(LASTINT);
        Functions.register(LASTSTRING);
        Functions.register(TICKET);
        Functions.register(CRAFTRESULT);
        Functions.register(RANDOMINT);
        Functions.register(RANDOMFLOAT);
    }

    private static void register(Function function) {
        FUNCTIONS.put(function.getId(), function);
        ParameterType type = function.getReturnType();
        if (!FUNCTIONS_BY_TYPE.containsKey((Object)type)) {
            FUNCTIONS_BY_TYPE.put(type, new ArrayList());
        }
        FUNCTIONS_BY_TYPE.get((Object)type).add(function);
    }

    @Nonnull
    public static List<Function> getFunctionsByType(ParameterType type) {
        if (FUNCTIONS_BY_TYPE.containsKey((Object)type)) {
            return FUNCTIONS_BY_TYPE.get((Object)type);
        }
        return Collections.emptyList();
    }
}

