/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.registry;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.network.NetworkTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import org.apache.commons.lang3.StringUtils;

public class Inventory {
    @Nullable
    private final String nodeName;
    @Nonnull
    private final EnumFacing side;
    @Nullable
    private final EnumFacing intSide;

    public Inventory(@Nullable String name, @Nonnull EnumFacing side, @Nullable EnumFacing intSide) {
        this.nodeName = name == null || name.isEmpty() ? null : name;
        this.side = side;
        this.intSide = intSide;
    }

    @Nullable
    public String getNodeName() {
        return this.nodeName;
    }

    public boolean hasNodeName() {
        return this.nodeName != null && !this.nodeName.isEmpty();
    }

    public String serialize() {
        return "#" + (this.hasNodeName() ? this.nodeName : "-") + "#" + this.side.func_176610_l() + "#" + (this.intSide == null ? "-" : this.intSide.func_176610_l()) + "#";
    }

    public static Inventory deserialize(String s) {
        String[] splitted = StringUtils.split((String)s, (char)'#');
        return new Inventory("-".equals(splitted[0]) ? null : splitted[0], EnumFacing.func_176739_a((String)splitted[1]), "-".equals(splitted[2]) ? null : EnumFacing.func_176739_a((String)splitted[2]));
    }

    @Nonnull
    public EnumFacing getSide() {
        return this.side;
    }

    @Nullable
    public EnumFacing getIntSide() {
        return this.intSide;
    }

    public void writeBuf(ByteBuf buf) {
        NetworkTools.writeString((ByteBuf)buf, (String)this.getNodeName());
        buf.writeByte(this.getSide().ordinal());
        buf.writeByte(this.getIntSide() == null ? -1 : this.getIntSide().ordinal());
    }

    public static Inventory readBuf(ByteBuf buf) {
        String nodeName = NetworkTools.readString((ByteBuf)buf);
        byte sideIdx = buf.readByte();
        EnumFacing side = EnumFacing.values()[sideIdx];
        sideIdx = buf.readByte();
        EnumFacing intSide = sideIdx == -1 ? null : EnumFacing.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        if (this.hasNodeName()) {
            tag.func_74778_a("node", this.getNodeName());
        }
        tag.func_74774_a("side", (byte)this.getSide().ordinal());
        tag.func_74774_a("intside", (byte)(this.getIntSide() == null ? -1 : this.getIntSide().ordinal()));
        return tag;
    }

    public static Inventory readFromNBT(NBTTagCompound tag) {
        String nodeName = null;
        if (tag.func_74764_b("node")) {
            nodeName = tag.func_74779_i("node");
        }
        byte sideIdx = tag.func_74771_c("side");
        EnumFacing side = EnumFacing.values()[sideIdx];
        sideIdx = tag.func_74771_c("intside");
        EnumFacing intSide = sideIdx == -1 ? null : EnumFacing.values()[sideIdx];
        return new Inventory(nodeName, side, intSide);
    }
}

