/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolscontrol.logic.registry.BlockSide;
import mcjty.rftoolscontrol.logic.registry.Functions;
import mcjty.rftoolscontrol.logic.registry.Inventory;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public enum ParameterType {
    PAR_STRING("string"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            return (String)value;
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            object.add("v", (JsonElement)new JsonPrimitive((String)value));
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            return ParameterValue.constant(object.get("v").getAsString());
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            tag.func_74778_a("v", (String)value);
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            return ParameterValue.constant(tag.func_74779_i("v"));
        }
    }
    ,
    PAR_INTEGER("integer"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            return Integer.toString((Integer)value);
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            object.add("v", (JsonElement)new JsonPrimitive((Number)((Integer)value)));
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            return ParameterValue.constant(object.get("v").getAsInt());
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            tag.func_74768_a("v", ((Integer)value).intValue());
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            return ParameterValue.constant(tag.func_74762_e("v"));
        }
    }
    ,
    PAR_FLOAT("float"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            return Float.toString(((Float)value).floatValue());
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            object.add("v", (JsonElement)new JsonPrimitive((Number)((Float)value)));
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            return ParameterValue.constant(Float.valueOf(object.get("v").getAsFloat()));
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            tag.func_74776_a("v", ((Float)value).floatValue());
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            return ParameterValue.constant(Float.valueOf(tag.func_74760_g("v")));
        }
    }
    ,
    PAR_SIDE("side"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            String s;
            BlockSide side = (BlockSide)value;
            EnumFacing facing = side.getSide();
            String string = s = facing == null ? "" : StringUtils.left((String)facing.func_176610_l().toUpperCase(), (int)1);
            if (side.getNodeName() == null) {
                return s;
            }
            return StringUtils.left((String)side.getNodeName(), (int)7) + " " + s;
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            BlockSide side = (BlockSide)value;
            if (side.getSide() != null) {
                object.add("side", (JsonElement)new JsonPrimitive(side.getSide().func_176610_l()));
            }
            if (side.getNodeName() != null) {
                object.add("node", (JsonElement)new JsonPrimitive(side.getNodeName()));
            }
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            EnumFacing side = object.has("side") ? EnumFacing.func_176739_a((String)object.get("side").getAsString()) : null;
            String node = object.has("node") ? object.get("node").getAsString() : null;
            return ParameterValue.constant(new BlockSide(node, side));
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            BlockSide side = (BlockSide)value;
            tag.func_74768_a("v", side.getSide() == null ? -1 : side.getSide().ordinal());
            tag.func_74778_a("node", side.getNodeName() == null ? "" : side.getNodeName());
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            int v = tag.func_74762_e("v");
            EnumFacing facing = v == -1 ? null : EnumFacing.values()[v];
            String node = tag.func_74779_i("node");
            return ParameterValue.constant(new BlockSide(node, facing));
        }
    }
    ,
    PAR_BOOLEAN("boolean"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            return (Boolean)value != false ? "true" : "false";
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            object.add("v", (JsonElement)new JsonPrimitive((Boolean)value));
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            return ParameterValue.constant(object.get("v").getAsBoolean());
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            tag.func_74757_a("v", ((Boolean)value).booleanValue());
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            return ParameterValue.constant(tag.func_74767_n("v"));
        }
    }
    ,
    PAR_INVENTORY("inventory"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            Inventory inv = (Inventory)value;
            String s = StringUtils.left((String)inv.getSide().func_176610_l().toUpperCase(), (int)1);
            if (inv.getIntSide() == null) {
                s = s + "/*";
            } else {
                String is = StringUtils.left((String)inv.getIntSide().func_176610_l().toUpperCase(), (int)1);
                s = s + "/" + is;
            }
            if (inv.getNodeName() == null) {
                return s;
            }
            return StringUtils.left((String)inv.getNodeName(), (int)6) + " " + s;
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            Inventory inv = (Inventory)value;
            object.add("side", (JsonElement)new JsonPrimitive(inv.getSide().func_176610_l()));
            if (inv.getIntSide() != null) {
                object.add("intside", (JsonElement)new JsonPrimitive(inv.getIntSide().func_176610_l()));
            }
            if (inv.getNodeName() != null) {
                object.add("node", (JsonElement)new JsonPrimitive(inv.getNodeName()));
            }
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            EnumFacing side = EnumFacing.func_176739_a((String)object.get("side").getAsString());
            EnumFacing intSide = object.has("intside") ? EnumFacing.func_176739_a((String)object.get("intside").getAsString()) : null;
            String node = object.has("node") ? object.get("node").getAsString() : null;
            return ParameterValue.constant(new Inventory(node, side, intSide));
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            Inventory inv = (Inventory)value;
            if (inv.getNodeName() != null) {
                tag.func_74778_a("nodeName", inv.getNodeName());
            }
            tag.func_74768_a("side", inv.getSide().ordinal());
            if (inv.getIntSide() != null) {
                tag.func_74768_a("intSide", inv.getIntSide().ordinal());
            }
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            EnumFacing side = EnumFacing.values()[tag.func_74762_e("side")];
            String name = null;
            EnumFacing intSide = null;
            if (tag.func_74764_b("nodeName")) {
                name = tag.func_74779_i("nodeName");
            }
            if (tag.func_74764_b("intSide")) {
                intSide = EnumFacing.values()[tag.func_74762_e("intSide")];
            }
            return ParameterValue.constant(new Inventory(name, side, intSide));
        }
    }
    ,
    PAR_ITEM("item"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            ItemStack inv = (ItemStack)value;
            return StringUtils.left((String)inv.func_82833_r(), (int)10);
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            ItemStack item = (ItemStack)value;
            object.add("item", (JsonElement)new JsonPrimitive(item.func_77973_b().getRegistryName().toString()));
            object.add("meta", (JsonElement)new JsonPrimitive((Number)item.func_77952_i()));
            if (item.func_77942_o()) {
                object.add("nbt", (JsonElement)new JsonPrimitive(item.func_77978_p().toString()));
            }
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            String itemReg = object.get("item").getAsString();
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemReg));
            int meta = object.get("meta").getAsInt();
            ItemStack stack = new ItemStack(item, meta);
            if (object.has("nbt")) {
                String nbt = object.get("nbt").getAsString();
                NBTTagCompound tagCompound = null;
                try {
                    tagCompound = JsonToNBT.func_180713_a((String)nbt);
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
                stack.func_77982_d(tagCompound);
            }
            return ParameterValue.constant(stack);
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            ItemStack item = (ItemStack)value;
            NBTTagCompound tc = new NBTTagCompound();
            item.func_77955_b(tc);
            tag.func_74782_a("item", (NBTBase)tc);
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            if (tag.func_74764_b("item")) {
                NBTTagCompound tc = (NBTTagCompound)tag.func_74781_a("item");
                ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)tc);
                return ParameterValue.constant(stack);
            }
            return ParameterValue.constant(null);
        }
    }
    ,
    PAR_EXCEPTION("exception"){

        @Override
        protected String stringRepresentationInternal(Object value) {
            ExceptionType exception = (ExceptionType)((Object)value);
            return exception.getCode();
        }

        @Override
        protected void writeToJsonInternal(JsonObject object, Object value) {
            ExceptionType exception = (ExceptionType)((Object)value);
            object.add("code", (JsonElement)new JsonPrimitive(exception.getCode()));
        }

        @Override
        protected ParameterValue readFromJsonInternal(JsonObject object) {
            String code = object.get("code").getAsString();
            return ParameterValue.constant((Object)ExceptionType.getExceptionForCode(code));
        }

        @Override
        protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
            ExceptionType exception = (ExceptionType)((Object)value);
            tag.func_74778_a("code", exception.getCode());
        }

        @Override
        protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
            String code = tag.func_74779_i("code");
            return ParameterValue.constant((Object)ExceptionType.getExceptionForCode(code));
        }
    };

    private final String name;
    private static final Map<String, ParameterType> TYPE_MAP;

    public String stringRepresentation(ParameterValue value) {
        if (value.isVariable()) {
            return "V:" + value.getVariableIndex();
        }
        if (value.isFunction()) {
            return "F:" + value.getFunction().getName();
        }
        if (value.getValue() == null) {
            return "";
        }
        return this.stringRepresentationInternal(value.getValue());
    }

    protected String stringRepresentationInternal(Object value) {
        return "?";
    }

    public JsonElement writeToJson(ParameterValue value) {
        JsonObject jsonObject = new JsonObject();
        if (value.isVariable()) {
            jsonObject.add("var", (JsonElement)new JsonPrimitive((Number)value.getVariableIndex()));
        } else if (value.isFunction()) {
            jsonObject.add("fun", (JsonElement)new JsonPrimitive(value.getFunction().getId()));
        } else if (value.getValue() == null) {
            jsonObject.add("null", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        } else {
            this.writeToJsonInternal(jsonObject, value.getValue());
        }
        return jsonObject;
    }

    public ParameterValue readFromJson(JsonObject object) {
        if (object.has("var")) {
            return ParameterValue.variable(object.get("var").getAsInt());
        }
        if (object.has("fun")) {
            return ParameterValue.function(Functions.FUNCTIONS.get(object.get("fun").getAsString()));
        }
        if (object.has("null")) {
            return ParameterValue.constant(null);
        }
        return this.readFromJsonInternal(object);
    }

    public void writeToNBT(NBTTagCompound tag, ParameterValue value) {
        if (value.isVariable()) {
            tag.func_74768_a("varIdx", value.getVariableIndex());
        } else if (value.isFunction()) {
            tag.func_74778_a("funId", value.getFunction().getId());
        } else if (value.getValue() == null) {
            tag.func_74757_a("null", true);
        } else {
            this.writeToNBTInternal(tag, value.getValue());
        }
    }

    public ParameterValue readFromNBT(NBTTagCompound tag) {
        if (tag.func_74764_b("varIdx")) {
            return ParameterValue.variable(tag.func_74762_e("varIdx"));
        }
        if (tag.func_74764_b("funId")) {
            return ParameterValue.function(Functions.FUNCTIONS.get(tag.func_74779_i("funId")));
        }
        if (tag.func_74764_b("null")) {
            return ParameterValue.constant(null);
        }
        return this.readFromNBTInternal(tag);
    }

    protected ParameterValue readFromNBTInternal(NBTTagCompound tag) {
        return ParameterValue.constant(null);
    }

    protected void writeToNBTInternal(NBTTagCompound tag, Object value) {
    }

    protected void writeToJsonInternal(JsonObject object, Object value) {
    }

    protected ParameterValue readFromJsonInternal(JsonObject object) {
        return null;
    }

    private ParameterType(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static ParameterType getByName(String name) {
        return TYPE_MAP.get(name);
    }

    static {
        TYPE_MAP = new HashMap<String, ParameterType>();
        for (ParameterType type : ParameterType.values()) {
            TYPE_MAP.put(type.getName(), type);
        }
    }
}

