/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.running;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import mcjty.rftoolscontrol.blocks.processor.ProcessorTileEntity;
import mcjty.rftoolscontrol.logic.Parameter;
import mcjty.rftoolscontrol.logic.TypeConverters;
import mcjty.rftoolscontrol.logic.compiled.CompiledCard;
import mcjty.rftoolscontrol.logic.compiled.CompiledEvent;
import mcjty.rftoolscontrol.logic.compiled.CompiledOpcode;
import mcjty.rftoolscontrol.logic.registry.OpcodeRunnable;
import mcjty.rftoolscontrol.logic.registry.ParameterType;
import mcjty.rftoolscontrol.logic.registry.ParameterValue;
import mcjty.rftoolscontrol.logic.running.ExceptionType;
import mcjty.rftoolscontrol.logic.running.ProgException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;

public class RunningProgram {
    public static boolean DEBUG = false;
    private final int cardIndex;
    private int current = 0;
    private int eventIndex = 0;
    private String ticket = null;
    private String lock = null;
    private int delay = 0;
    private boolean dead = false;
    private Parameter lastValue;
    private List<Pair<Integer, Integer>> loopStack = new ArrayList<Pair<Integer, Integer>>();
    private List<CompiledOpcode> opcodeCache = null;

    public RunningProgram(int cardIndex) {
        this.cardIndex = cardIndex;
    }

    public void startFromEvent(CompiledEvent event) {
        this.current = event.getIndex();
        this.eventIndex = event.getIndex();
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public int getEventIndex() {
        return this.eventIndex;
    }

    public void setCraftTicket(@Nullable String craftId) {
        this.ticket = craftId;
    }

    @Nullable
    public String getCraftTicket() {
        return this.ticket;
    }

    public boolean hasCraftTicket() {
        return this.ticket != null && !this.ticket.isEmpty();
    }

    public void setDelay(int delay) {
        this.delay = delay;
    }

    public int getDelay() {
        return this.delay;
    }

    public String getLock() {
        return this.lock;
    }

    public void setLock(String lock) {
        this.lock = lock;
    }

    public void killMe() {
        this.dead = true;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getCardIndex() {
        return this.cardIndex;
    }

    public void setLastValue(Parameter value) {
        this.lastValue = value;
    }

    public Parameter getLastValue() {
        return this.lastValue;
    }

    public CompiledOpcode getCurrentOpcode(ProcessorTileEntity processor) {
        return this.opcodes(processor).get(this.current);
    }

    public void pushLoopStack(int varIndex) {
        this.loopStack.add((Pair<Integer, Integer>)Pair.of((Object)this.current, (Object)varIndex));
    }

    public void popLoopStack(ProcessorTileEntity processor) {
        if (this.loopStack.isEmpty()) {
            this.killMe();
        } else {
            Pair<Integer, Integer> pair = this.loopStack.get(this.loopStack.size() - 1);
            this.current = (Integer)pair.getLeft();
            int varIdx = (Integer)pair.getRight();
            this.loopStack.remove(this.loopStack.size() - 1);
            int i = TypeConverters.convertToInt(processor.getVariableArray()[varIdx].getParameterValue().getValue());
            processor.getVariableArray()[varIdx] = Parameter.builder().type(ParameterType.PAR_INTEGER).value(ParameterValue.constant(++i)).build();
        }
    }

    public boolean run(ProcessorTileEntity processor) {
        if (this.delay > 0) {
            --this.delay;
            return false;
        }
        if (this.lock != null) {
            if (processor.testLock(this, this.lock)) {
                return false;
            }
            this.lock = null;
        }
        try {
            OpcodeRunnable.OpcodeResult result;
            CompiledOpcode opcode = this.opcodes(processor).get(this.current);
            if (DEBUG) {
                System.out.println(opcode.getOpcode());
            }
            if ((result = opcode.run(processor, this)) == OpcodeRunnable.OpcodeResult.POSITIVE) {
                this.current = opcode.getPrimaryIndex();
            } else if (result == OpcodeRunnable.OpcodeResult.NEGATIVE) {
                this.current = opcode.getSecondaryIndex();
            }
        }
        catch (ProgException e) {
            throw e;
        }
        catch (Exception e) {
            LogManager.getLogger().log(Level.WARN, "Opcode failed with: ", (Throwable)e);
            throw new ProgException(ExceptionType.EXCEPT_INTERNALERROR);
        }
        return true;
    }

    private List<CompiledOpcode> opcodes(ProcessorTileEntity processor) {
        if (this.opcodeCache == null) {
            CompiledCard card = processor.getCompiledCard(this.cardIndex);
            this.opcodeCache = card.getOpcodes();
        }
        return this.opcodeCache;
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("card", this.cardIndex);
        tag.func_74768_a("current", this.current);
        tag.func_74768_a("event", this.eventIndex);
        tag.func_74768_a("delay", this.delay);
        tag.func_74757_a("dead", this.dead);
        if (this.ticket != null) {
            tag.func_74778_a("ticket", this.ticket);
        }
        if (this.lock != null) {
            tag.func_74778_a("lock", this.lock);
        }
        if (this.lastValue != null) {
            NBTTagCompound varTag = new NBTTagCompound();
            varTag.func_74768_a("type", this.lastValue.getParameterType().ordinal());
            this.lastValue.getParameterType().writeToNBT(varTag, this.lastValue.getParameterValue());
            tag.func_74782_a("lastvar", (NBTBase)varTag);
        }
        if (!this.loopStack.isEmpty()) {
            NBTTagList loopList = new NBTTagList();
            for (Pair<Integer, Integer> pair : this.loopStack) {
                NBTTagCompound t = new NBTTagCompound();
                t.func_74768_a("index", ((Integer)pair.getLeft()).intValue());
                t.func_74768_a("var", ((Integer)pair.getRight()).intValue());
                loopList.func_74742_a((NBTBase)t);
            }
            tag.func_74782_a("loopStack", (NBTBase)loopList);
        }
    }

    public static RunningProgram readFromNBT(NBTTagCompound tag) {
        if (!tag.func_74764_b("card")) {
            return null;
        }
        int cardIndex = tag.func_74762_e("card");
        RunningProgram program = new RunningProgram(cardIndex);
        program.setCurrent(tag.func_74762_e("current"));
        program.eventIndex = tag.func_74762_e("event");
        program.setDelay(tag.func_74762_e("delay"));
        program.dead = tag.func_74767_n("dead");
        if (tag.func_74764_b("ticket")) {
            program.ticket = tag.func_74779_i("ticket");
        }
        if (tag.func_74764_b("lock")) {
            program.lock = tag.func_74779_i("lock");
        }
        if (tag.func_74764_b("lastvar")) {
            NBTTagCompound varTag = tag.func_74775_l("lastvar");
            int t = varTag.func_74762_e("type");
            ParameterType type = ParameterType.values()[t];
            program.lastValue = Parameter.builder().type(type).value(type.readFromNBT(varTag)).build();
        }
        if (tag.func_74764_b("loopStack")) {
            program.loopStack.clear();
            NBTTagList loopList = tag.func_150295_c("loopStack", 10);
            for (int i = 0; i < loopList.func_74745_c(); ++i) {
                NBTTagCompound t = loopList.func_150305_b(i);
                program.loopStack.add((Pair<Integer, Integer>)Pair.of((Object)tag.func_74762_e("index"), (Object)tag.func_74762_e("var")));
            }
        }
        return program;
    }
}

