/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.network;

import io.netty.buffer.ByteBuf;
import java.util.List;
import mcjty.lib.network.ClientCommandHandler;
import mcjty.lib.network.NetworkTools;
import mcjty.lib.network.PacketListToClient;
import mcjty.lib.varia.Logging;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingRequest;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketRequestsReady
extends PacketListToClient<CraftingRequest> {
    public PacketRequestsReady() {
    }

    public PacketRequestsReady(BlockPos pos, String command, List<CraftingRequest> list) {
        super(pos, command, list);
    }

    protected CraftingRequest createItem(ByteBuf buf) {
        String id = NetworkTools.readString((ByteBuf)buf);
        ItemStack stack = NetworkTools.readItemStack((ByteBuf)buf);
        int amount = buf.readInt();
        CraftingRequest request = new CraftingRequest(id, stack, amount);
        request.setOk(buf.readLong());
        request.setFailed(buf.readLong());
        return request;
    }

    protected void writeItemToBuf(ByteBuf buf, CraftingRequest s) {
        NetworkTools.writeString((ByteBuf)buf, (String)s.getTicket());
        NetworkTools.writeItemStack((ByteBuf)buf, (ItemStack)s.getStack());
        buf.writeInt(s.getTodo());
        buf.writeLong(s.getOk());
        buf.writeLong(s.getFailed());
    }

    public static class Handler
    implements IMessageHandler<PacketRequestsReady, IMessage> {
        public IMessage onMessage(PacketRequestsReady message, MessageContext ctx) {
            RFToolsControl.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketRequestsReady message, MessageContext ctx) {
            TileEntity te = RFToolsControl.proxy.getClientWorld().func_175625_s(message.pos);
            if (!(te instanceof ClientCommandHandler)) {
                Logging.log((String)"TileEntity is not a ClientCommandHandler!");
                return;
            }
            ClientCommandHandler clientCommandHandler = (ClientCommandHandler)te;
            if (!clientCommandHandler.execute(message.command, message.list)) {
                Logging.log((String)("Command " + message.command + " was not handled!"));
            }
        }
    }
}

