/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.awt.Color;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.color.IBlockColor;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.brew.Brew;
import vazkii.botania.api.brew.IBrewItem;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.state.enums.PoolVariant;
import vazkii.botania.api.state.enums.SpreaderVariant;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.BlockCamo;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.tile.TileCamo;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.ItemManaGun;
import vazkii.botania.common.item.ItemManaMirror;
import vazkii.botania.common.item.ItemManaTablet;
import vazkii.botania.common.item.ItemTwigWand;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.bauble.ItemBloodPendant;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;
import vazkii.botania.common.item.lens.ItemLens;

public final class ColorHandler {
    public static void init() {
        BlockColors blocks = Minecraft.func_71410_x().func_184125_al();
        Map map = (Map)ReflectionHelper.getPrivateValue(BlockColors.class, (Object)blocks, (String[])new String[]{"blockColorMap"});
        blocks.func_186722_a((IBlockColor)map.get(Blocks.field_150395_bd.delegate), new Block[]{ModBlocks.solidVines});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            if (state.func_177229_b(BotaniaStateProps.POOL_VARIANT) == PoolVariant.FABULOUS) {
                float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
                return Color.HSBtoRGB(time * 0.005f, 0.6f, 1.0f);
            }
            return ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176768_e().field_76291_p;
        }, new Block[]{ModBlocks.pool});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            if (state.func_177229_b(BotaniaStateProps.SPREADER_VARIANT) != SpreaderVariant.GAIA) {
                return 0xFFFFFF;
            }
            float time = (float)ClientTickHandler.ticksInGame + ClientTickHandler.partialTicks;
            return Color.HSBtoRGB(time * 5.0f % 360.0f / 360.0f, 0.4f, 0.9f);
        }, new Block[]{ModBlocks.spreader});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            int meta = ModBlocks.petalBlock.func_176201_c(state);
            return EnumDyeColor.func_176764_b((int)meta).func_176768_e().field_76291_p;
        }, new Block[]{ModBlocks.petalBlock});
        blocks.func_186722_a((state, world, pos, tintIndex) -> {
            TileEntity tile;
            if (world != null && pos != null && (tile = world.func_175625_s(pos)) instanceof TileCamo) {
                TileCamo camo = (TileCamo)tile;
                IBlockState camoState = camo.camoState;
                if (camoState != null) {
                    return camoState.func_177230_c() instanceof BlockCamo ? 0xFFFFFF : Minecraft.func_71410_x().func_184125_al().func_186724_a(camoState, world, pos, tintIndex);
                }
            }
            return 0xFFFFFF;
        }, new Block[]{ModBlocks.platform});
        ItemColors items = Minecraft.func_71410_x().getItemColors();
        items.func_186730_a((s, t) -> s.func_77952_i() == 5 || s.func_77952_i() == 14 ? Color.HSBtoRGB((float)(Botania.proxy.getWorldElapsedTicks() * 2L % 360L) / 360.0f, 0.25f, 1.0f) : -1, new Item[]{ModItems.manaResource});
        items.func_186730_a((s, t) -> t == 1 ? EnumDyeColor.func_176764_b((int)ItemTwigWand.getColor1((ItemStack)s)).func_176768_e().field_76291_p : (t == 2 ? EnumDyeColor.func_176764_b((int)ItemTwigWand.getColor2((ItemStack)s)).func_176768_e().field_76291_p : -1), new Item[]{ModItems.twigWand});
        items.func_186730_a((s, t) -> EnumDyeColor.func_176764_b((int)s.func_77952_i()).func_176768_e().field_76291_p, new Item[]{ModItems.dye, ModItems.petal});
        items.func_186731_a((s, t) -> Minecraft.func_71410_x().func_184125_al().func_186724_a(((ItemBlock)s.func_77973_b()).field_150939_a.func_176203_a(s.func_77960_j()), null, null, t), new Block[]{ModBlocks.petalBlock, ModBlocks.pool, ModBlocks.spreader});
        items.func_186730_a((s, t) -> t == 1 ? Color.HSBtoRGB(0.528f, ((ItemManaMirror)ModItems.manaMirror).getMana(s) / 1000000, 1.0f) : -1, new Item[]{ModItems.manaMirror});
        items.func_186730_a((s, t) -> t == 1 ? Color.HSBtoRGB(0.528f, ((ItemManaTablet)ModItems.manaTablet).getMana(s) / 500000, 1.0f) : -1, new Item[]{ModItems.manaTablet});
        items.func_186730_a((s, t) -> Color.HSBtoRGB(0.55f, ((float)s.func_77958_k() - (float)s.func_77952_i()) / (float)s.func_77958_k() * 0.5f, 1.0f), new Item[]{ModItems.spellCloth});
        items.func_186730_a((s, t) -> {
            if (t != 1) {
                return -1;
            }
            Brew brew = ((IBrewItem)s.func_77973_b()).getBrew(s);
            if (brew == BotaniaAPI.fallbackBrew) {
                return s.func_77973_b() instanceof ItemBloodPendant ? 12976142 : 0x989898;
            }
            Color color = new Color(brew.getColor(s));
            double speed = s.func_77973_b() == ModItems.brewFlask || s.func_77973_b() == ModItems.brewVial ? 0.1 : 0.2;
            int add = (int)(Math.sin((double)ClientTickHandler.ticksInGame * speed) * 24.0);
            int r = Math.max(0, Math.min(255, color.getRed() + add));
            int g = Math.max(0, Math.min(255, color.getGreen() + add));
            int b = Math.max(0, Math.min(255, color.getBlue() + add));
            return r << 16 | g << 8 | b;
        }, new Item[]{ModItems.bloodPendant, ModItems.incenseStick, ModItems.brewFlask, ModItems.brewVial});
        items.func_186730_a((s, t) -> {
            ItemStack lens = ItemManaGun.getLens(s);
            if (lens != null && t == 0) {
                return Minecraft.func_71410_x().getItemColors().func_186728_a(lens, t);
            }
            if (t == 2) {
                EntityManaBurst burst = ((ItemManaGun)s.func_77973_b()).getBurst((EntityPlayer)Minecraft.func_71410_x().field_71439_g, s, false);
                Color color = new Color(burst == null ? 0x20FF20 : burst.getColor());
                float mul = (float)(Math.sin((double)ClientTickHandler.ticksInGame / 5.0) * (double)0.15f);
                int c = (int)(255.0f * mul);
                return new Color(Math.max(0, Math.min(255, color.getRed() + c)), Math.max(0, Math.min(255, color.getGreen() + c)), Math.max(0, Math.min(255, color.getBlue() + c))).getRGB();
            }
            return -1;
        }, new Item[]{ModItems.manaGun});
        items.func_186730_a((s, t) -> t == 1 ? Color.HSBtoRGB(0.75f, 1.0f, 1.5f - (float)Math.min(1.0, Math.sin((double)System.currentTimeMillis() / 100.0) * 0.5 + (double)1.2f)) : -1, new Item[]{ModItems.enderDagger});
        items.func_186730_a((s, t) -> t == 1 && ItemTerraPick.isEnabled(s) ? Color.HSBtoRGB(0.375f, (float)Math.min(1.0, Math.sin((double)System.currentTimeMillis() / 200.0) * 0.5 + 1.0), 1.0f) : -1, new Item[]{ModItems.terraPick});
        items.func_186730_a((s, t) -> t == 0 ? ((ItemLens)s.func_77973_b()).getLensColor(s) : -1, new Item[]{ModItems.lens});
    }

    private ColorHandler() {
    }
}

