/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.util.ArrayDeque;
import java.util.Queue;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import org.lwjgl.opengl.GL11;
import vazkii.botania.client.core.handler.ClientMethodHandles;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.common.block.tile.string.TileRedString;
import vazkii.botania.common.core.helper.PlayerHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.item.ModItems;

public final class RedStringRenderer {
    public static final Queue<TileRedString> redStringTiles = new ArrayDeque<TileRedString>();
    private static float sizeAlpha = 0.0f;

    public static void renderAll() {
        if (!redStringTiles.isEmpty()) {
            TileRedString tile;
            GlStateManager.func_179094_E();
            GlStateManager.func_179090_x();
            GlStateManager.func_179147_l();
            GL11.glPushAttrib((int)64);
            GlStateManager.func_179140_f();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)0.0f, (float)0.0f, (float)sizeAlpha);
            while ((tile = redStringTiles.poll()) != null) {
                RedStringRenderer.renderTile(tile);
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
            GL11.glPopAttrib();
            GlStateManager.func_179121_F();
        }
    }

    public static void tick() {
        boolean hasWand;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        boolean bl = hasWand = player != null && PlayerHelper.hasHeldItem((EntityPlayer)player, ModItems.twigWand);
        if (sizeAlpha > 0.0f && !hasWand) {
            sizeAlpha -= 0.1f;
        } else if (sizeAlpha < 1.0f && hasWand) {
            sizeAlpha += 0.1f;
        }
    }

    private static void renderTile(TileRedString tile) {
        double renderPosZ;
        double renderPosY;
        double renderPosX;
        try {
            renderPosX = ClientMethodHandles.renderPosX_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosY = ClientMethodHandles.renderPosY_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
            renderPosZ = ClientMethodHandles.renderPosZ_getter.invokeExact(Minecraft.func_71410_x().func_175598_ae());
        }
        catch (Throwable t) {
            return;
        }
        EnumFacing dir = tile.getOrientation();
        BlockPos bind = tile.getBinding();
        if (bind != null) {
            Vector3 vecMag;
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)((double)tile.func_174877_v().func_177958_n() + 0.5 - renderPosX), (double)((double)tile.func_174877_v().func_177956_o() + 0.5 - renderPosY), (double)((double)tile.func_174877_v().func_177952_p() + 0.5 - renderPosZ));
            Vector3 vecOrig = new Vector3(bind.func_177958_n() - tile.func_174877_v().func_177958_n(), bind.func_177956_o() - tile.func_174877_v().func_177956_o(), bind.func_177952_p() - tile.func_174877_v().func_177952_p());
            Vector3 vecNorm = vecOrig.normalize();
            Vector3 vecApply = vecMag = vecNorm.multiply(0.025);
            int stages = (int)(vecOrig.mag() / vecMag.mag());
            Tessellator tessellator = Tessellator.func_178181_a();
            GL11.glLineWidth((float)1.0f);
            tessellator.func_178180_c().func_181668_a(1, DefaultVertexFormats.field_181705_e);
            double len = (double)(-ClientTickHandler.ticksInGame) / 100.0 + (double)new Random(dir.ordinal() ^ tile.func_174877_v().hashCode()).nextInt(10000);
            double add = vecMag.mag();
            double rand = Math.random() - 0.5;
            for (int i = 0; i < stages; ++i) {
                RedStringRenderer.addVertexAtWithTranslation(tessellator, dir, vecApply.x, vecApply.y, vecApply.z, rand, len);
                rand = Math.random() - 0.5;
                vecApply = vecApply.add(vecMag);
                RedStringRenderer.addVertexAtWithTranslation(tessellator, dir, vecApply.x, vecApply.y, vecApply.z, rand, len += add);
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    private static void addVertexAtWithTranslation(Tessellator tess, EnumFacing dir, double xpos, double ypos, double zpos, double rand, double l) {
        double freq = 20.0;
        double ampl = (0.15 * (Math.sin(l * 2.0) * 0.5 + 0.5) + 0.1) * (double)sizeAlpha;
        double randMul = 0.05;
        double x = xpos + Math.sin(l * freq) * ampl * (double)Math.abs(Math.abs(dir.func_82601_c()) - 1) + rand * randMul;
        double y = ypos + Math.cos(l * freq) * ampl * (double)Math.abs(Math.abs(dir.func_96559_d()) - 1) + rand * randMul;
        double z = zpos + (dir.func_96559_d() == 0 ? Math.sin(l * freq) : Math.cos(l * freq)) * ampl * (double)Math.abs(Math.abs(dir.func_82599_e()) - 1) + rand * randMul;
        tess.func_178180_c().func_181662_b(x, y, z).func_181675_d();
    }
}

