/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelBook;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderSpecificHandEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import vazkii.botania.client.core.handler.ClientTickHandler;
import vazkii.botania.client.gui.lexicon.GuiLexicon;
import vazkii.botania.common.Botania;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.ItemLexicon;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lexicon.page.PageText;

public class RenderLexicon {
    private final ModelBook model = new ModelBook();
    private final ResourceLocation texture = new ResourceLocation("botania:textures/model/lexica.png");
    private final String[] QUOTES = new String[]{"\"Neat!\" - Direwolf20", "\"It's pretty ledge.\" - Haighyorkie", "\"I don't really like it.\" - CrustyMustard", "\"It's a very thinky mod.\" - AdamG3691", "\"You must craft the tiny potato.\" - TheFractangle", "\"Vazkii did a thing.\" - cpw"};
    int quote = -1;

    @SubscribeEvent
    public void renderItem(RenderSpecificHandEvent evt) {
        Minecraft mc = Minecraft.func_71410_x();
        if (!ConfigHandler.lexicon3dModel || mc.field_71474_y.field_74320_O != 0 || mc.field_71439_g.func_184586_b(evt.getHand()) == null || mc.field_71439_g.func_184586_b(evt.getHand()).func_77973_b() != ModItems.lexicon) {
            return;
        }
        evt.setCanceled(true);
        try {
            this.renderItemInFirstPerson((AbstractClientPlayer)mc.field_71439_g, evt.getPartialTicks(), evt.getInterpolatedPitch(), evt.getHand(), evt.getSwingProgress(), evt.getItemStack(), evt.getEquipProgress());
        }
        catch (Throwable throwable) {
            Botania.LOGGER.warn("Failed to render lexicon");
        }
    }

    private void renderItemInFirstPerson(AbstractClientPlayer player, float partialTicks, float interpPitch, EnumHand hand, float swingProgress, ItemStack stack, float equipProgress) throws Throwable {
        boolean flag = hand == EnumHand.MAIN_HAND;
        EnumHandSide enumhandside = flag ? player.func_184591_cq() : player.func_184591_cq().func_188468_a();
        GlStateManager.func_179094_E();
        boolean flag1 = enumhandside == EnumHandSide.RIGHT;
        float f = -0.4f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * (float)Math.PI));
        float f1 = 0.2f * MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)swingProgress) * ((float)Math.PI * 2)));
        float f2 = -0.2f * MathHelper.func_76126_a((float)(swingProgress * (float)Math.PI));
        int i = flag1 ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * f), (float)f1, (float)f2);
        this.transformSideFirstPerson(enumhandside, equipProgress);
        this.transformFirstPerson(enumhandside, swingProgress);
        this.doRender(enumhandside, partialTicks, stack);
        GlStateManager.func_179121_F();
    }

    private void doRender(EnumHandSide side, float partialTicks, ItemStack stack) {
        Minecraft mc = Minecraft.func_71410_x();
        GlStateManager.func_179094_E();
        mc.field_71446_o.func_110577_a(this.texture);
        float ticks = ClientTickHandler.ticksWithLexicaOpen;
        if (ticks > 0.0f && ticks < 10.0f) {
            ticks = Minecraft.func_71410_x().field_71462_r instanceof GuiLexicon ? (ticks += partialTicks) : (ticks -= partialTicks);
        }
        GlStateManager.func_179109_b((float)(0.3f + 0.02f * ticks), (float)(0.475f + 0.01f * ticks), (float)(-0.2f - 0.01f * ticks));
        GlStateManager.func_179114_b((float)(87.5f + ticks * (float)(side == EnumHandSide.RIGHT ? 5 : 10)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(ticks * 2.85f), (float)0.0f, (float)0.0f, (float)1.0f);
        float opening = ticks / 12.0f;
        float pageFlipTicks = ClientTickHandler.pageFlipTicks;
        if (pageFlipTicks > 0.0f) {
            pageFlipTicks -= ClientTickHandler.partialTicks;
        }
        float pageFlip = pageFlipTicks / 5.0f;
        this.model.func_78088_a(null, 0.0f, 0.0f, pageFlip, opening, 0.0f, 0.0625f);
        if (ticks < 3.0f) {
            String title;
            FontRenderer font = Minecraft.func_71410_x().field_71466_p;
            GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)-0.3f, (float)-0.21f, (float)-0.07f);
            GlStateManager.func_179152_a((float)0.0035f, (float)0.0035f, (float)-0.0035f);
            String origTitle = title = ModItems.lexicon.func_77653_i(null);
            if (stack != null) {
                title = stack.func_82833_r();
            }
            font.func_78276_b(font.func_78269_a(title, 80), 0, 0, 14063360);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.6f, (float)0.6f, (float)0.6f);
            font.func_78276_b(TextFormatting.ITALIC + "" + TextFormatting.BOLD + I18n.func_135052_a((String)"botaniamisc.edition", (Object[])new Object[]{ItemLexicon.getEdition()}), 0, 0, 10514688);
            if (this.quote == -1) {
                this.quote = mc.field_71441_e.field_73012_v.nextInt(this.QUOTES.length);
            }
            String quoteStr = this.QUOTES[this.quote];
            GlStateManager.func_179109_b((float)-5.0f, (float)3.0f, (float)0.0f);
            PageText.renderText(0, 0, 140, 100, 0, false, 7995282, quoteStr);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)2.0f, (float)98.0f, (float)0.0f);
            font.func_78276_b(I18n.func_135052_a((String)"botaniamisc.lexiconcover0", (Object[])new Object[0]), 0, 0, 7995282);
            GlStateManager.func_179109_b((float)0.0f, (float)10.0f, (float)0.0f);
            font.func_78276_b(TextFormatting.UNDERLINE + "" + TextFormatting.ITALIC + I18n.func_135052_a((String)"botaniamisc.lexiconcover1", (Object[])new Object[0]), 0, 0, 7995282);
            GlStateManager.func_179109_b((float)0.0f, (float)-30.0f, (float)0.0f);
            String authorTitle = I18n.func_135052_a((String)"botaniamisc.lexiconcover2", (Object[])new Object[0]);
            int len = font.func_78256_a(authorTitle);
            font.func_78276_b(authorTitle, 62 - len / 2, 0, 14063360);
        }
        GlStateManager.func_179121_F();
    }

    private void transformSideFirstPerson(EnumHandSide p_187459_1_, float p_187459_2_) {
        int i = p_187459_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)((float)i * 0.56f), (float)(-0.52f + p_187459_2_ * -0.6f), (float)-0.72f);
    }

    private void transformFirstPerson(EnumHandSide p_187453_1_, float p_187453_2_) {
        int i = p_187453_1_ == EnumHandSide.RIGHT ? 1 : -1;
        GlStateManager.func_179109_b((float)(p_187453_1_ == EnumHandSide.RIGHT ? 0.5f : 0.3f), (float)-0.25f, (float)0.2f);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)12.0f, (float)0.0f, (float)0.0f, (float)-1.0f);
        float f = MathHelper.func_76126_a((float)(p_187453_2_ * p_187453_2_ * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * (45.0f + f * -20.0f)), (float)0.0f, (float)1.0f, (float)0.0f);
        float f1 = MathHelper.func_76126_a((float)(MathHelper.func_76129_c((float)p_187453_2_) * (float)Math.PI));
        GlStateManager.func_179114_b((float)((float)i * f1 * -20.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)(f1 * -80.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)((float)i * -45.0f), (float)0.0f, (float)1.0f, (float)0.0f);
    }
}

