/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.model;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.vecmath.Matrix4f;
import javax.vecmath.Tuple4f;
import javax.vecmath.Vector3f;
import javax.vecmath.Vector4f;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.UnpackedBakedQuad;
import net.minecraftforge.client.model.pipeline.VertexTransformer;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.common.property.IExtendedBlockState;
import org.apache.commons.lang3.tuple.Pair;
import vazkii.botania.api.BotaniaAPIClient;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.block.ItemBlockFloatingSpecialFlower;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class FloatingFlowerModel
implements IBakedModel {
    private static final String MUNDANE_PREFIX = "botania:shimmeringFlower_";
    private final Table<IFloatingFlower.IslandType, String, CompositeBakedModel> CACHE = HashBasedTable.create();
    private final ItemOverrideList itemHandler = new ItemOverrideList((List)ImmutableList.of()){

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel model, ItemStack stack, @Nonnull World world, @Nonnull EntityLivingBase entity) {
            IFloatingFlower.IslandType islandType = IFloatingFlower.IslandType.GRASS;
            String identifier = Block.func_149634_a((Item)stack.func_77973_b()) == ModBlocks.floatingSpecialFlower ? ItemBlockFloatingSpecialFlower.getType(stack) : FloatingFlowerModel.MUNDANE_PREFIX + stack.func_77952_i();
            return FloatingFlowerModel.this.getModel(islandType, identifier);
        }
    };

    protected static BakedQuad transform(BakedQuad quad, final TRSRTransformation transform) {
        UnpackedBakedQuad.Builder builder = new UnpackedBakedQuad.Builder(DefaultVertexFormats.field_176599_b);
        VertexTransformer consumer = new VertexTransformer((IVertexConsumer)builder){

            public void put(int element, float ... data) {
                VertexFormatElement formatElement = DefaultVertexFormats.field_176599_b.func_177348_c(element);
                switch (formatElement.func_177375_c()) {
                    case POSITION: {
                        float[] newData = new float[4];
                        Vector4f vec = new Vector4f(data);
                        transform.getMatrix().transform((Tuple4f)vec);
                        vec.get(newData);
                        this.parent.put(element, newData);
                        break;
                    }
                    default: {
                        this.parent.put(element, data);
                    }
                }
            }
        };
        quad.pipe((IVertexConsumer)consumer);
        return builder.build();
    }

    @Nonnull
    public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
        if (state.func_177230_c() != ModBlocks.floatingSpecialFlower && state.func_177230_c() != ModBlocks.floatingFlower) {
            return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178126_b().func_174951_a().func_188616_a(state, face, rand);
        }
        IExtendedBlockState realState = (IExtendedBlockState)state;
        IFloatingFlower.IslandType islandType = (IFloatingFlower.IslandType)realState.getValue(BotaniaStateProps.ISLAND_TYPE);
        String identifier = state.func_177230_c() == ModBlocks.floatingSpecialFlower ? (String)realState.getValue(BotaniaStateProps.SUBTILE_ID) : MUNDANE_PREFIX + ((EnumDyeColor)state.func_177229_b(BotaniaStateProps.COLOR)).func_176765_a();
        return this.getModel(islandType, identifier).func_188616_a(state, face, rand);
    }

    private CompositeBakedModel getModel(IFloatingFlower.IslandType islandType, String identifier) {
        IBakedModel flowerModel;
        IBakedModel islandModel;
        ModelManager modelManager = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178083_a();
        if (this.CACHE.contains((Object)islandType, (Object)identifier)) {
            return (CompositeBakedModel)this.CACHE.get((Object)islandType, (Object)identifier);
        }
        try {
            islandModel = ModelLoaderRegistry.getModel((ResourceLocation)((ResourceLocation)BotaniaAPIClient.getRegisteredIslandTypeModels().get(islandType))).bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, ModelLoader.defaultTextureGetter());
        }
        catch (Exception e) {
            islandModel = modelManager.func_174951_a();
        }
        if (identifier.startsWith(MUNDANE_PREFIX)) {
            int meta = Integer.parseInt(identifier.substring(identifier.indexOf(MUNDANE_PREFIX) + MUNDANE_PREFIX.length()));
            flowerModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(new ItemStack(ModBlocks.shinyFlower, 1, meta));
        } else {
            ItemStack stack = ItemBlockSpecialFlower.ofType(identifier);
            IBakedModel specialFlowerModel = Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178089_a(stack);
            flowerModel = specialFlowerModel.func_188617_f().handleItemState(specialFlowerModel, stack, null, null);
        }
        CompositeBakedModel model = new CompositeBakedModel(flowerModel, islandModel);
        Botania.LOGGER.debug("Cached floating flower model for islandtype %s and flowertype %s", new Object[]{islandType, identifier});
        this.CACHE.put((Object)islandType, (Object)identifier, (Object)model);
        return model;
    }

    @Nonnull
    public ItemOverrideList func_188617_f() {
        return this.itemHandler;
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return true;
    }

    public boolean func_188618_c() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return Minecraft.func_71410_x().func_147117_R().func_110572_b("minecraft:blocks/dirt");
    }

    @Nonnull
    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    private static class CompositeBakedModel
    implements IPerspectiveAwareModel {
        private final IBakedModel flower;
        private final IBakedModel island;
        private final List<BakedQuad> genQuads;
        private final Map<EnumFacing, List<BakedQuad>> faceQuads = new EnumMap<EnumFacing, List<BakedQuad>>(EnumFacing.class);

        public CompositeBakedModel(IBakedModel flower, IBakedModel island) {
            this.flower = flower;
            this.island = island;
            ImmutableList.Builder genBuilder = ImmutableList.builder();
            TRSRTransformation transform = TRSRTransformation.blockCenterToCorner((TRSRTransformation)new TRSRTransformation(new Vector3f(0.0f, 0.2f, 0.0f), null, new Vector3f(0.5f, 0.5f, 0.5f), null));
            for (EnumFacing e : EnumFacing.field_82609_l) {
                this.faceQuads.put(e, new ArrayList());
            }
            flower.func_188616_a(null, null, 0L).stream().map(q -> FloatingFlowerModel.transform(q, transform)).forEach(arg_0 -> ((ImmutableList.Builder)genBuilder).add(arg_0));
            for (EnumFacing e : EnumFacing.field_82609_l) {
                List<BakedQuad> faceQ = this.faceQuads.get(e);
                flower.func_188616_a(null, e, 0L).stream().map(input -> FloatingFlowerModel.transform(input, transform)).forEach(faceQ::add);
            }
            genBuilder.addAll((Iterable)island.func_188616_a(null, null, 0L));
            for (EnumFacing e : EnumFacing.field_82609_l) {
                this.faceQuads.get(e).addAll(island.func_188616_a(null, e, 0L));
            }
            this.genQuads = genBuilder.build();
        }

        @Nonnull
        public List<BakedQuad> func_188616_a(IBlockState state, EnumFacing face, long rand) {
            return face == null ? this.genQuads : this.faceQuads.get(face);
        }

        public boolean func_177555_b() {
            return this.flower.func_177555_b();
        }

        public boolean func_177556_c() {
            return this.flower.func_177556_c();
        }

        public boolean func_188618_c() {
            return this.flower.func_188618_c();
        }

        @Nonnull
        public TextureAtlasSprite func_177554_e() {
            return this.flower.func_177554_e();
        }

        @Nonnull
        public ItemCameraTransforms func_177552_f() {
            return this.flower.func_177552_f();
        }

        @Nonnull
        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
            Pair pair;
            if (this.island instanceof IPerspectiveAwareModel && (pair = ((IPerspectiveAwareModel)this.island).handlePerspective(cameraTransformType)) != null && pair.getRight() != null) {
                return Pair.of((Object)this, (Object)pair.getRight());
            }
            return Pair.of((Object)this, (Object)TRSRTransformation.identity().getMatrix());
        }
    }
}

